package com.biz.crm.tpm.business.activity.detail.plan.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mn.common.base.dto.audit.AutoAuditParamsDto;
import com.biz.crm.tpm.business.activity.detail.plan.feign.ActivityDetailPlanFeign;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanOutDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanBudgetVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanVo;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.RedPacketQueryScheme2Dto;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.RedPacketQueryScheme2Vo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import java.util.Collection;
import java.util.List;
import java.util.Set;

/**
 * @ClassName ActivityDetailPlanSdkServiceImpl
 * @Description
 * @Author: jiangyin
 * @Date 2023/5/16
 */
@Service
public class ActivityDetailPlanSdkServiceImpl implements ActivityDetailPlanSdkService {

    @Autowired(required = false)
    private ActivityDetailPlanFeign activityDetailPlanFeign;

    @Override
    public Page<ActivityDetailPlanVo> findByConditions(Pageable pageable, ActivityDetailPlanDto activityDetailPlanDto) {
        return null;
    }

    @Override
    public Page<ActivityDetailPlanItemVo> queryActivityDetailPlan(Pageable pageable, ActivityDetailPlanItemDto activityDetailPlanItemDto) {
        return null;
    }

    @Override
    public List<ActivityDetailPlanVo> findByCodes(Collection<String> detailPlanCodes) {
        return null;
    }

    @Override
    public List<ActivityDetailPlanVo> findActivityDetailPlanByCodes(List<String> codes) {
        return null;
    }

    @Override
    public String findPlanCodeByPlanName(String planName) {
        return null;
    }

    @Override
    public List<ActivityDetailPlanDto> buildActivityDetailPlanParams(List<String> detailPlanCodeList) {
        return null;
    }

    @Override
    public List<RedPacketQueryScheme2Vo> redPacketQueryScheme(RedPacketQueryScheme2Dto dto2) {
        return null;
    }

    @Override
    public List<ActivityDetailPlanVo> findByPlanCodes(Set<String> codeSet) {
        return null;
    }

    @Override
    public List<ActivityDetailPlanVo> getCanAutoAuditDto(Page<ActivityDetailPlanVo> page, String autoDate) {
        return null;
    }

    @Override
    public List<ActivityDetailPlanVo> findCanAutoAudit(Page<ActivityDetailPlanVo> page, AutoAuditParamsDto autoAuditParams) {
        return null;
    }

    @Override
    public List<ActivityDetailPlanItemVo> findCanAutoAuditItem(AutoAuditParamsDto autoAuditParams) {
        return null;
    }

    @Override
    public int getActivityDetailNum(String autoDate, String businessUnitCode) {
        return 0;
    }

    @Override
    public int getActivityTotalNumber(AutoAuditParamsDto autoAuditParams) {
        return 0;
    }

    @Override
    public void updateAutoAudit(String detailPlanCode) {

    }

    @Override
    public void updateAutoAuditFlag(List<String> codes, String autoAudit) {

    }

    @Override
    public List<ActivityDetailPlanBudgetVo> findByPlanItemCode(Set<String> itemCodeSet) {
        return null;
    }

    @Override
    public ActivityDetailPlanVo findById(String id) {
        Result<ActivityDetailPlanVo> result = activityDetailPlanFeign.findById(id);
        if (!result.isSuccess()) {
            throw new UnsupportedOperationException("查询活动细案详情失败：" + result.getMessage());
        } else if (result.getResult() != null && DelFlagStatusEnum.DELETE.getCode().equals(result.getResult().getDelFlag())) {
            throw new UnsupportedOperationException("该活动细案已删除");
        }
        return result.getResult();
    }

    @Override
    public ActivityDetailPlanOutDto createOrUpdateForOut(ActivityDetailPlanOutDto dto) {
        Result<ActivityDetailPlanOutDto> result = activityDetailPlanFeign.createOrUpdate(dto);
        if (!result.isSuccess()) {
            if (StringUtils.isEmpty(dto.getId())) {
                throw new UnsupportedOperationException("活动细案创建失败：" + result.getMessage());
            } else {
                throw new UnsupportedOperationException("活动细案更新失败：" + result.getMessage());
            }
        }
        return result.getResult();
    }

    @Override
    public void delete(List<String> ids) {
        Result<?> result = activityDetailPlanFeign.delete(ids);
        if (!result.isSuccess()) {
            throw new UnsupportedOperationException("活动细案删除失败：" + result.getMessage());
        }
    }

    @Override
    public ActivityDetailPlanVo findByPlanCode(String planCode) {
        return null;
    }

    @Override
    public ActivityDetailPlanOutDto atomicCreateForOut(ActivityDetailPlanOutDto dto) {
        Result<ActivityDetailPlanOutDto> result = activityDetailPlanFeign.atomicCreateForOut(dto);
        if (!result.isSuccess()) {
            throw new UnsupportedOperationException("原子活动细案创建失败：" + result.getMessage());
        }
        return result.getResult();
    }

    @Override
    public Page<ActivityDetailPlanVo> findPageForOut(Pageable pageable, ActivityDetailPlanDto dto) {
        Result<Page<ActivityDetailPlanVo>> result = activityDetailPlanFeign.findPageForOut(pageable, dto);
        if (!result.isSuccess()) {
            throw new UnsupportedOperationException("活动细案列表查询失败：" + result.getMessage());
        }
        return result.getResult();
    }

    @Override
    public Page<String> findByDtoForPrediction(Pageable pageable, ActivityDetailPlanDto detailPlanDto) {
        return null;
    }

    @Override
    public Page<ActivityDetailPlanItemVo> findPlanItemByConditions(Pageable pageable, ActivityDetailPlanItemDto dto){
        Result<Page<ActivityDetailPlanItemVo>> result = activityDetailPlanFeign.findPlanItemByConditions(
            pageable, dto);
        if (!result.isSuccess()) {
            throw new UnsupportedOperationException("活动细案列表查询失败：" + result.getMessage());
        }
        return result.getResult();
    }

}
