package com.biz.crm.tpm.business.activity.detail.plan.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.activity.detail.plan.feign.ForeignActivityDetailPlanApiFeign;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ForeignActivityDetailPlanApiService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 外部系统调用处理活动细案接口
 * @author wanghaojia
 * @date 2023/11/24 10:52
 */
@Service
public class ForeignActivityDetailPlanApiServiceImpl implements ForeignActivityDetailPlanApiService {

    @Autowired(required = false)
    private ForeignActivityDetailPlanApiFeign foreignActivityDetailPlanApiFeign;

    /**
     * 活动细案创建接口
     * @param object
     * @return
     */
    @Override
    public Result create(JSONObject object) {
        Result<Page<Object>> result = foreignActivityDetailPlanApiFeign.create(object);
        if (!result.isSuccess()) {
            throw new UnsupportedOperationException("活动细案创建失败：" + result.getMessage());
        }
        return result;
    }

}
