package com.biz.crm.tpm.business.activity.detail.plan.local.consumer;

import com.alibaba.fastjson.JSON;
import com.biz.crm.mn.common.rocketmq.service.AbstractRocketMqConsumer;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.constant.ActivityDetailPlanConstant;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.constant.ActivityDetailPlanPassMqTagConstant;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.ActivityDetailPlanPassMqTagEnum;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.PushActivityToThirdSystemService;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.spring.annotation.ConsumeMode;
import org.apache.rocketmq.spring.annotation.MessageModel;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Objects;

/**
 * @Description:
 * @Author qiancheng
 * @Date 2023/1/17
 */
@Slf4j
@Component
@RocketMQMessageListener(topic = ActivityDetailPlanConstant.TPM_ACTIVITY_DETAIL_PLAN_PROCESS_PASS_TOPIC + "${rocketmq.environment}",
        /**
         * tag
         * 可用 || 监听多个tag： "tag1 || tag2 || tag3"
         * 请把tag  定义在 *** 内 需要统一维护
        */
        selectorExpression = ActivityDetailPlanPassMqTagConstant.PASS_COW_MANAGER,
        /**
         * 相同分组下 consumer 可自动负载均衡
         * 请把consumerGroup  定义在 *** 内 需要统一维护
        */
        consumerGroup = ActivityDetailPlanPassMqTagConstant.PASS_COW_MANAGER + "${rocketmq.environment}",
        /**
         * 默认集群消费MqConstant
         * 可以设置 ConsumeMode.ORDERLY 使用广播消费
         * 也可使用集群模式模拟广播模式：
         * 启动多个不同 consumerGroup 的consumer实例
        */
        consumeMode = ConsumeMode.CONCURRENTLY,
        /**
         * 集群消费or广播消费;默认是集群消费
        */
        messageModel = MessageModel.CLUSTERING)
public class ActivityDetailPlanPassPushCowManagerConsumer extends AbstractRocketMqConsumer {

    @Autowired(required = false)
    private PushActivityToThirdSystemService pushActivityToThirdSystemService;

    @Override
    protected Object handleMessage(MqMessageVo message) {
        log.info("活动细案审批通过推送牛人管家 cowManager mq message received  : {}", message);
        if (Objects.isNull(message)
                || StringUtils.isEmpty(message.getMsgBody())) {
            return "消息为空!";
        }

        try {
            //查询需要推送的方案明细数据
            List<String> businessNoList = JSON.parseArray(message.getMsgBody(), String.class);
            pushActivityToThirdSystemService.activityCreateOrUpdatePushCowManager(businessNoList);
        }catch (Exception e){
            log.error(ActivityDetailPlanPassMqTagEnum.PASS_COW_MANAGER.getName()+"处理失败"+e.getMessage(),e);
            return "消费失败."+e.getMessage();
        }

        return "消费成功.";
    }
}
