package com.biz.crm.tpm.business.activity.detail.plan.local.consumer;

import com.alibaba.fastjson.JSON;
import com.biz.crm.mn.common.rocketmq.service.AbstractRocketMqConsumer;
import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.mn.common.rocketmq.util.RocketMqUtil;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.activity.detail.plan.local.listener.ActivityDetailPlanProcessCompleteListener;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.ActivityDetailPlanService;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.PushActivityDetailPlanService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.constant.ActivityDetailPlanConstant;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.ActivityDetailPlanPassMqTagEnum;
import com.biz.crm.tpm.business.activity.plan.sdk.constant.ActivityPlanConstant;
import com.biz.crm.tpm.business.activity.plan.sdk.constant.ActivityPlanPassMqTagConstant;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanListDto;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.ActivityPlanPassMqTagEnum;
import com.biz.crm.tpm.business.activity.plan.sdk.service.ActivityPlanSdkService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.spring.annotation.ConsumeMode;
import org.apache.rocketmq.spring.annotation.MessageModel;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Objects;
import java.util.UUID;

/**
 * @author wanghaojia
 * @date 2023/1/16 19:59
 */
@Slf4j
@Component
@RocketMQMessageListener(topic = ActivityPlanConstant.TPM_ACTIVITY_PLAN_PROCESS_PASS_TOPIC + "${rocketmq.environment}",
        /**
         * tag
         * 可用 || 监听多个tag： "tag1 || tag2 || tag3"
         * 请把tag  定义在 *** 内 需要统一维护
        */
        selectorExpression = ActivityPlanPassMqTagConstant.PASS_CREATE_DETAIL_PLAN,
        /**
         * 相同分组下 consumer 可自动负载均衡
         * 请把consumerGroup  定义在 *** 内 需要统一维护
        */
        consumerGroup = ActivityPlanPassMqTagConstant.PASS_CREATE_DETAIL_PLAN + "${rocketmq.environment}",
        /**
         * 默认集群消费MqConstant
         * 可以设置 ConsumeMode.ORDERLY 使用广播消费
         * 也可使用集群模式模拟广播模式：
         * 启动多个不同 consumerGroup 的consumer实例
        */
        consumeMode = ConsumeMode.CONCURRENTLY,
        /**
         * 集群消费or广播消费;默认是集群消费
        */
        messageModel = MessageModel.CLUSTERING)
public class ActivityPlanPassCreateDetailPlanConsumer extends AbstractRocketMqConsumer {

    @Autowired(required = false)
    private ActivityPlanSdkService activityPlanSdkService;

    @Autowired(required = false)
    private ActivityDetailPlanService activityDetailPlanService;

    @Autowired(required = false)
    private PushActivityDetailPlanService pushActivityDetailPlanService;

    @Autowired(required = false)
    private ActivityDetailPlanProcessCompleteListener activityDetailPlanProcessCompleteListener;

    @Override
    protected Object handleMessage(MqMessageVo message) {
        log.info("活动方案审批通过生成活动细案 order mq message received  : {}", message);
        if (Objects.isNull(message)
                || StringUtils.isEmpty(message.getMsgBody())) {
            return "消息为空!";
        }
        try {
            List<String> businessNoList = JSON.parseArray(message.getMsgBody(), String.class);

            List<ActivityPlanDto> dtoList = activityPlanSdkService.buildActivityPlanParms(businessNoList);
            ActivityPlanListDto dto = new ActivityPlanListDto();
            dto.setList(dtoList);

            log.info("开始自动生成细案");
            List<String> detailPlanCodeList = activityDetailPlanService.autoBatchCreate(dto);
            log.info("自动生成细案结束");
            pushActivityDetailPlanService.passPushMqDirect(null,detailPlanCodeList);
        }catch (Exception e){
            log.error(ActivityPlanPassMqTagEnum.PASS_CREATE_DETAIL_PLAN.getName()+"处理失败"+e.getMessage(),e);
            return "消费失败."+e.getMessage();
        }
        return "消费成功.";
    }

}
