package com.biz.crm.tpm.business.activity.detail.plan.local.consumer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.biz.crm.mn.common.rocketmq.service.AbstractRocketMqConsumer;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.ActivityDetailPlanService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.constant.AuditPassChangeAuditAmountMqTagConstant;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.spring.annotation.ConsumeMode;
import org.apache.rocketmq.spring.annotation.MessageModel;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.Map;

/**
 * @Author : dengwei
 * @Date :2023/12/19  19:44
 * @Description: 核销审批通过更新方案明细已结案金额
 */
@Slf4j
@Component
@RocketMQMessageListener(topic = AuditPassChangeAuditAmountMqTagConstant.AUDIT_PASS_CHANGE_AUDIT_AMOUNT_TOPIC + "${rocketmq.environment}",
        /**
         * tag
         * 可用 || 监听多个tag： "tag1 || tag2 || tag3"
         * 请把tag  定义在 *** 内 需要统一维护
        */
        selectorExpression = AuditPassChangeAuditAmountMqTagConstant.AUDIT_PASS_CHANGE_AUDIT_AMOUNT_TAG,
        /**
         * 相同分组下 consumer 可自动负载均衡
         * 请把consumerGroup  定义在 *** 内 需要统一维护
        */
        consumerGroup = AuditPassChangeAuditAmountMqTagConstant.AUDIT_PASS_CHANGE_AUDIT_AMOUNT_TAG + "${rocketmq.environment}",
        /**
         * 默认集群消费MqConstant
         * 可以设置 ConsumeMode.ORDERLY 使用广播消费
         * 也可使用集群模式模拟广播模式：
         * 启动多个不同 consumerGroup 的consumer实例
        */
        consumeMode = ConsumeMode.CONCURRENTLY,
        /**
         * 集群消费or广播消费;默认是集群消费
        */
        messageModel = MessageModel.CLUSTERING)
public class AuditPassChangePlanItemAuditAmountConsumer extends AbstractRocketMqConsumer {

    @Autowired(required = false)
    private ActivityDetailPlanService activityDetailPlanService;

    @Override
    protected Object handleMessage(MqMessageVo message) {
        log.info("=====>    核销审批通过修改方案明细已核销金额数据[{}]    <=====", JSON.toJSONString(message));
        if (StringUtils.isEmpty(message.getMsgBody())) {
            return "消息为空!";
        }
        Map<String, BigDecimal> detailItemAlreadyAuditAmountMap = JSON.parseObject(message.getMsgBody(), new TypeReference<Map<String, BigDecimal>>() {
        });
        if(!CollectionUtils.isEmpty(detailItemAlreadyAuditAmountMap)) {
            activityDetailPlanService.updatePlanAlreadyAmount(detailItemAlreadyAuditAmountMap);
        }
        return "消费成功";
    }
}
