package com.biz.crm.tpm.business.activity.detail.plan.local.controller;


import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DataTooLongGenerateRespUtil;
import com.biz.crm.tpm.business.activity.detail.plan.local.entity.ActivityDetailPlan;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.ActivityDetailPlanBudgetService;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.ActivityDetailPlanItemService;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.ActivityDetailPlanService;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.PushActivityDetailPlanService;
import com.biz.crm.tpm.business.activity.detail.plan.local.vo.ActivityDetailPlanApproveSubmitDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.constant.ActivityDetailPlanConstant;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanBudgetDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanReportDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.sfa.SfaFeeDetailDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanReportVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanVo;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanListDto;
import com.biz.crm.tpm.business.activity.plan.sdk.service.ActivityPlanSdkService;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanVo;
import com.biz.crm.tpm.business.month.budget.sdk.dto.MonthBudgetDto;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * 活动细案(ActivityDetailPlan)表相关的http接口
 *
 * @author wanghaojia
 * @since 2022-11-04 16:52:04
 */
@RestController
@RequestMapping("/v1/activityDetailPlan")
@Slf4j
@Api(tags = "活动细案")
public class ActivityDetailPlanController {

    @Autowired(required = false)
    private ActivityDetailPlanService activityDetailPlanService;

    @Autowired(required = false)
    private ActivityDetailPlanBudgetService activityDetailPlanBudgetService;

    @Autowired(required = false)
    private ActivityDetailPlanSdkService activityDetailPlanSdkService;

    @Autowired(required = false)
    private ActivityPlanSdkService activityPlanSdkService;

    @Autowired(required = false)
    private RedisLockService redisLockService;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    @Autowired(required = false)
    private PushActivityDetailPlanService pushActivityDetailPlanService;

    @Autowired(required = false)
    private ActivityDetailPlanItemService activityDetailPlanItemService;

    /**
     * 分页查询所有数据
     *
     * @param pageable 分页对象
     * @param activityDetailPlanDto 查询实体
     * @return 所有数据
     */
    @ApiOperation(value = "分页查询所有数据")
    @GetMapping("findByConditions")
    public Result<Page<ActivityDetailPlanVo>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                              @ApiParam(name = "activityDetailPlanDto", value = "查询实体") ActivityDetailPlanDto activityDetailPlanDto) {
        try {
            Page<ActivityDetailPlanVo> page =  this.activityDetailPlanService.findByConditions(pageable,activityDetailPlanDto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 分页查询所有数据
     *
     * @param pageable 分页对象
     * @param activityDetailPlanDto 查询实体
     * @return 所有数据
     */
    @ApiOperation(value = "分页查询所有数据")
    @GetMapping("findPageForOut")
    public Result<Page<ActivityDetailPlanVo>> findPageForOut(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                               @ApiParam(name = "activityDetailPlanDto", value = "查询实体") ActivityDetailPlanDto activityDetailPlanDto) {
        try {
            Page<ActivityDetailPlanVo> page =  this.activityDetailPlanService.findPageForOut(pageable,activityDetailPlanDto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @GetMapping("activityDetailPlanItem/findPage")
    @ApiOperation("活动细案列表查询API")
    public Result<Page<ActivityDetailPlanItemVo>> findPage(@ApiParam(name = "pageable") @PageableDefault(10) Pageable pageable,
        @ApiParam(name = "dto") ActivityDetailPlanItemDto dto){
        try {
        Page<ActivityDetailPlanItemVo> page = activityDetailPlanItemService.findByConditions(
            pageable, dto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 分页查询所有明细（查询条件里面有头表信息就放这儿了）
     *
     * @param pageable 分页对象
     * @param dto 查询实体
     * @return 所有数据
     */
    @ApiOperation(value = "分页查询所有明细")
    @GetMapping("findDetailByConditions")
    public Result<Page<ActivityDetailPlanReportVo>> findDetailByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                                           @ApiParam(name = "ActivityDetailPlanReportDto", value = "查询实体") ActivityDetailPlanReportDto dto) {
        try {
            Page<ActivityDetailPlanReportVo> page =  this.activityDetailPlanService.findDetailByConditions(pageable,dto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 分页查询所有明细（查询条件里面有头表信息就放这儿了）
     *
     * @param pageable 分页对象
     * @param dto 查询实体
     * @return 所有数据
     */
    @ApiOperation(value = "分页查询所有明细")
    @GetMapping("findDetailByConditionsFotExport")
    public Result<Page<ActivityDetailPlanReportVo>> findDetailByConditionsFotExport(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                                           @ApiParam(name = "ActivityDetailPlanReportDto", value = "查询实体") ActivityDetailPlanReportDto dto) {
        try {
            Page<ActivityDetailPlanReportVo> page =  this.activityDetailPlanService.findDetailByConditionsFotExport(pageable,dto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 通过id获取活动方案数据
     */
    @ApiOperation(value = "通过id获取活动方案数据")
    @GetMapping("findById")
    public Result<ActivityDetailPlanVo> findById(@ApiParam(value = "id")@RequestParam String id){
        try {
            ActivityDetailPlanVo vo = this.activityDetailPlanService.findById(id);
            return Result.ok(vo);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 活动细案新增编辑
     * @return
     */
    @ApiOperation(value = "活动细案新增编辑-能力中心")
    @PostMapping(value = "saveActivityPlanNoCache")
    public Result<ActivityDetailPlanDto> saveActivityPlanNoCache(@ApiParam(name = "ActivityPlanDetailDto", value = "活动细案表头")@RequestBody ActivityDetailPlanDto dto){
        try {
            loginUserService.refreshAuthentication(null);
            return Result.ok(this.activityDetailPlanService.saveActivityDetailPlanNoCache(dto));
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(DataTooLongGenerateRespUtil.generateRespStr(e, ActivityDetailPlan.class));
        }
    }

    /**
     * 活动细案新增编辑
     * @param cacheKey 明细缓存key
     * @return
     */
    @ApiOperation(value = "活动细案新增编辑")
    @PostMapping(value = "saveActivityPlan")
    public Result saveActivityPlan(@ApiParam(name = "cacheKey", value = "缓存键")@RequestParam String cacheKey,
                                   @ApiParam(name = "ActivityPlanDetailDto", value = "活动细案表头")@RequestBody ActivityDetailPlanDto dto){
        boolean lockSuccess = false;
        String lockKey = ActivityDetailPlanConstant.LOCK_ACTIVITY_DETAIL_PLAN_SAVE+cacheKey;
        try {
            lockSuccess = redisLockService.tryLock(lockKey, TimeUnit.HOURS, 2);
            if (!lockSuccess){
                throw new RuntimeException("数据已提交，请勿重复操作！");
            }
            this.activityDetailPlanService.saveActivityDetailPlan(dto,cacheKey);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        } finally {
            if (lockSuccess){
                redisLockService.unlock(lockKey);
            }
        }
    }

    /**
     * 查询可以选择的月度预算
     * @param pageable 分页对象
     * @param dto      查询实体
     * @return 所有数据
     */
    @ApiOperation(value = "查询可以选择的月度预算")
    @GetMapping("findMonthBudgetByConditions")
    public Result<Page<MonthBudgetVo>> findMonthBudgetByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                                   @ApiParam(name = "MonthBudgetDto", value = "月度预算信息") ActivityDetailPlanBudgetDto planBudgetDto,
                                                                   @ApiParam(name = "MonthBudgetDto", value = "月度预算信息") MonthBudgetDto dto) {
        try {
            Page<MonthBudgetVo> page = this.activityDetailPlanService.findMonthBudgetByConditions(pageable,planBudgetDto, dto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 细案客户汇总暴露操作预算接口
     *
     * @return 所有数据
     */
    @ApiOperation(value = "细案客户汇总暴露操作预算接口")
    @GetMapping("operateCustomerMonthBudgetByPlanCodeList")
    public Result<?> operateCustomerMonthBudgetByPlanCodeList(@RequestParam("detailPlanCodeList") @ApiParam(name = "detailPlanCodeList", value = "细案编码集合") List<String> detailPlanCodeList,
                                                              @RequestParam("operationType") @ApiParam(name = "operationType", value = "操作月度预算类型") String operationType) {
        try {
            this.activityDetailPlanService.operateCustomerMonthBudgetByPlanCodeList(detailPlanCodeList, operationType);
            return Result.ok("操作成功！");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 细案暴露操作预算接口
     * @return 操作结果
     */
    @ApiOperation(value = "细案暴露操作预算接口")
    @GetMapping("useMonthBudgetByDetailPlanCodeList")
    public Result<?> useMonthBudgetByDetailPlanCodeList(@RequestBody @ApiParam(name = "detailPlanCodeList", value = "细案编码集合") List<String> detailPlanCodeList) {
        try {
            this.activityDetailPlanBudgetService.useMonthBudgetByPlanCodeList(detailPlanCodeList);
            return Result.ok("操作成功！");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 提交流程,多选批量提交
     */
    @ApiOperation(value = "提交流程,多选批量提交")
    @PostMapping(value = "submitApproval")
    public Result submitApproval(@ApiParam(value = "提交流程，按业态，业务单元、归属部门、策略类型、策略年度提交")@RequestBody ActivityDetailPlanApproveSubmitDto dto){
        List<String> ids = dto.getIds();
        boolean lockSuccess = false;
        try {
            if (CollectionUtils.isEmpty(ids)){
                throw new RuntimeException("请选择数据！");
            }
            //提交审批前加锁一个小时
            lockSuccess = redisLockService.batchLock(ActivityDetailPlanConstant.LOCK_ACTIVITY_DETAIL_PLAN_APPROVE,ids, TimeUnit.HOURS, 1);
            if (!lockSuccess) {
                throw new RuntimeException("数据处理中，请勿重复操作！");
            }

            this.activityDetailPlanService.submitApproval(dto.getIds(),dto);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        } finally {
            if (!CollectionUtils.isEmpty(ids) && lockSuccess){
                redisLockService.batchUnLock(ActivityDetailPlanConstant.LOCK_ACTIVITY_DETAIL_PLAN_APPROVE,ids);
            }
        }
    }

    /**
     * 删除活动方案
     * @param ids 策略ids
     */
    @ApiOperation(value = "删除活动方案")
    @DeleteMapping(value = "delete")
    public Result delete(@ApiParam(value = "活动方案id集合")@RequestParam List<String> ids){
        try {
            this.activityDetailPlanService.delete(ids);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 删除活动方案
     * @param ids 策略ids
     */
    @ApiOperation(value = "删除活动方案")
    @PostMapping(value = "deletePos")
    public Result deletePos(@ApiParam(value = "活动方案id集合")@RequestParam List<String> ids){
        try {
            this.activityDetailPlanService.delete(ids);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 活动细案申请可以选择的活动方案
     * @param pageable 分页对象
     * @param dto      查询实体
     * @return 所有数据ø
     */
    @ApiOperation(value = "活动细案申请可以选择的活动方案")
    @GetMapping("findRelateActivityPlanListByConditions")
    public Result<Page<ActivityPlanVo>> findRelateActivityPlanListByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                                               @ApiParam(name = "MarketingStrategyDto", value = "策略查询实体") ActivityPlanDto dto) {
        try {
            dto.setProcessStatus(ProcessStatusEnum.PASS.getDictCode());
            Page<ActivityPlanVo> page = this.activityPlanSdkService.findByConditions(pageable, dto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    @ApiOperation("查询活动细案明细")
    @GetMapping("findActivityDetailPlanList")
    public Result<Page<ActivityDetailPlanItemVo>> findActivityDetailPlanList(@PageableDefault(50) Pageable pageable,
                                                                             @ApiParam(name = "dto") ActivityDetailPlanItemDto dto) {
        try {
            dto.setProcessStatus(ProcessStatusEnum.PASS.getKey());
            return Result.ok(activityDetailPlanSdkService.queryActivityDetailPlan(pageable, dto));
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation("查询活动细案明细")
    @PostMapping("queryActivityDetailPlan")
    public Result<Page<ActivityDetailPlanItemVo>> queryActivityDetailPlan(@PageableDefault(50) Pageable pageable, @RequestBody ActivityDetailPlanItemDto activityDetailPlanItemDto){
        try {
            return Result.ok(activityDetailPlanSdkService.queryActivityDetailPlan(pageable,activityDetailPlanItemDto));
        }catch (Exception e){
            log.error(e.getMessage(),e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 推送SFA费用明细
     * @param dtoList 费用明细集合
     */
    @ApiOperation(value = "推送SFA费用明细")
    @PostMapping(value = "pushSfaFeeDetailList")
    public Result pushSfaFeeDetailList(@RequestBody List<SfaFeeDetailDto> dtoList){
        try {
            log.info(JSONObject.toJSONString(dtoList));
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 推送SFA费用明细
     */
    @PostMapping(value = "autoBatchCreateByCode")
    public Result autoBatchCreateByCode(@RequestBody List<String> businessNoList){
        try {
            Assert.notEmpty(businessNoList, "请选择活动方案!");
            List<ActivityPlanDto> dtoList = activityPlanSdkService.buildActivityPlanParms(businessNoList);
            Assert.notEmpty(dtoList, "活动方案" + JSON.toJSONString(businessNoList) + "不存在!");
            dtoList.forEach(vo -> {
                Assert.isTrue(ProcessStatusEnum.PASS.getDictCode().equals(vo.getProcessStatus()),
                        "活动方案[" + vo.getPlanCode() + "]未审批通过!");
            });
            ActivityPlanListDto dto = new ActivityPlanListDto();
            dto.setList(dtoList);

            List<String> detailPlanCodeList = activityDetailPlanService.autoBatchCreate(dto);
            pushActivityDetailPlanService.passPushMqDirect(null,detailPlanCodeList);
            return Result.ok(detailPlanCodeList);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 推送SFA费用明细
     */
    @PostMapping(value = "autoBatchCreate")
    public Result autoBatchCreate(@RequestBody ActivityPlanListDto listDto){
        try {
            List<String> detailPlanCodeList = activityDetailPlanService.autoBatchCreate(listDto);
            return Result.ok(detailPlanCodeList);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    /**
     * 测试定时任务
     */
    @PostMapping(value = "textXxjob")
    public Result<?> textXxjob() {
        try {
            this.activityDetailPlanService.syncBudgetRollbackVertical();
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
    /**
     * 测试定时任务
     */
    @PostMapping(value = "buildActivityDetailPlanParams")
    public Result<?> buildActivityDetailPlanParams(@RequestBody List<String> detailPlanCodeList) {
        try {
            List<ActivityDetailPlanDto> activityDetailPlanDtos = this.activityDetailPlanService.buildActivityDetailPlanParams(detailPlanCodeList);
            return Result.ok(activityDetailPlanDtos);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * （主体）根据汇总维度进行汇总
     *
     * @param activityDetailPlanDto 查询
     */
    @ApiOperation(value = "（主体）根据汇总维度进行汇总")
    @GetMapping("summary")
    public Result<?> summary(@ApiParam(name = "activityDetailPlanDto", value = "查询实体") ActivityDetailPlanDto activityDetailPlanDto) {
        try {
            this.activityDetailPlanService.summary(activityDetailPlanDto);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "活动细案创建原子接口-能力中心")
    @PostMapping("atomicCreateForOut")
    public Result<ActivityDetailPlanDto> atomicCreateForOut(@RequestBody ActivityDetailPlanDto dto){
        try {
            ActivityDetailPlanDto result = this.activityDetailPlanService.atomicCreateForOut(dto);
            return Result.ok(result);
        } catch (Exception e) {
            log.error(e.getMessage());
            return Result.error(DataTooLongGenerateRespUtil.generateRespStr(e, ActivityDetailPlan.class));
        }
    }

}
