package com.biz.crm.tpm.business.activity.detail.plan.local.controller;


import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.sfa.display.SfaActivityDetailPlanCreateResult;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.sfa.display.SfaActivityDetailPlanDisplayCreateDto;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 活动方案表(ActivityPlan)表相关的http接口
 *
 * @author wanghaojia
 * @since 2022-10-31 15:55:41
 */
@RestController
@RequestMapping("/v1/activityDetailPlan")
@Slf4j
@Api(tags = "活动细案-渠道平台对接")
public class ActivityDetailPlanDockingSfaController {

    @PostMapping(value = "sfaActivityDetailPlanCreateDisplay")
    public Result<List<SfaActivityDetailPlanCreateResult>> sfaActivityDetailPlanCreateDisplay(@RequestBody List<SfaActivityDetailPlanDisplayCreateDto> list){
        try {
            log.info(JSONObject.toJSONString(list));
//            this.activityPlanService.proportionByTerminal(dto, cacheKey);
            return Result.ok(Lists.newArrayList());
        }catch (Exception e){
            log.error(e.getMessage(),e);
            return Result.error(e.getMessage());
        }
    }

}
