package com.biz.crm.tpm.business.activity.detail.plan.local.controller;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.dto.CommonSelectDto;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.vo.CommonSelectVo;
import com.biz.crm.mn.common.page.cache.controller.MnPageCacheController;
import com.biz.crm.tpm.business.activities.template.config.sdk.dto.ActivitiesTemplateConfigDto;
import com.biz.crm.tpm.business.activities.template.config.sdk.enums.ActivitiesTemplateConfigTypeEnum;
import com.biz.crm.tpm.business.activities.template.config.sdk.service.ActivitiesTemplateSdkService;
import com.biz.crm.tpm.business.activities.template.config.sdk.vo.ActivitiesTemplateConfigVo;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.ActivityDetailPlanItemAsyncService;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.ActivityDetailPlanItemService;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.ActivityDetailPlanItemTerminalService;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.ActivityDetailPlanService;
import com.biz.crm.tpm.business.activity.detail.plan.local.vo.ActivityDetailPlanBudgetSumVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.constant.ActivityDetailPlanConstant;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemTerminalVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanReportVo;
import com.biz.crm.tpm.business.activity.form.sdk.dto.ActivityFormSelectDto;
import com.biz.crm.tpm.business.activity.type.sdk.dto.ActivityTypeSelectDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * 活动细案明细(ActivityDetailPlanItem)表相关的http接口
 *
 * @author wanghaojia
 * @since 2022-11-03 18:22:08
 */
@RestController
@RequestMapping("/v1/activityDetailPlanItem")
@Slf4j
@Api(tags = "活动细案明细")
public class ActivityDetailPlanItemController extends MnPageCacheController<ActivityDetailPlanItemVo,ActivityDetailPlanItemDto> {
    /**
     * 服务对象
     */
    @Autowired(required = false)
    private ActivityDetailPlanItemService activityDetailPlanItemService;
    @Autowired(required = false)
    private ActivityDetailPlanService activityDetailPlanService;

    /**
     * 活动配置模板服务
     */
    @Autowired(required = false)
    private ActivitiesTemplateSdkService activitiesTemplateSdkService;

    @Autowired(required = false)
    private ActivityDetailPlanItemAsyncService activityDetailPlanItemAsyncService;

    @Autowired(required = false)
    private ActivityDetailPlanItemTerminalService activityDetailPlanItemTerminalService;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    @Autowired(required = false)
    private RedisLockService redisLockService;

    /**
     * 分页查询所有数据
     *
     * @param pageable 分页对象
     * @param activityDetailPlanItemDto 查询实体
     * @return 所有数据
     */
    @ApiOperation(value = "分页查询所有数据")
    @GetMapping("findByConditions")
    public Result<Page<ActivityDetailPlanItemVo>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                               @ApiParam(name = "activityDetailPlanItemDto", value = "查询实体") ActivityDetailPlanItemDto activityDetailPlanItemDto) {
        try {
            Page<ActivityDetailPlanItemVo> page =  this.activityDetailPlanItemService.findByConditions(pageable,activityDetailPlanItemDto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 获取活动方案可以选择的模板
     */
    @ApiOperation(value = "获取活动方案可以选择的模板")
    @PostMapping("findItemColumnConfigSelect")
    public Result<List<CommonSelectVo>> findItemColumnConfigSelect(@ApiParam(value = "模板编码") ActivitiesTemplateConfigDto configDto,
                                                                   @ApiParam(value = "活动类型dto")@RequestBody CommonSelectDto dto) {
        try {
            Validate.notBlank(configDto.getBusinessFormatCode(),"业态不能为空");
            Validate.notBlank(configDto.getBusinessUnitCode(),"业务单元不能为空");
            configDto.setType(ActivitiesTemplateConfigTypeEnum.SCHEME_DETAIL.getCode());
            //如果是小业务单元的话就查主体的模板
            if (BusinessUnitEnum.isDefaultBusinessUnit(configDto.getBusinessUnitCode())){
                configDto.setBusinessUnitCode(BusinessUnitEnum.HEADQUARTERS.getCode());
            }
            List<CommonSelectVo> list = activitiesTemplateSdkService.findActivitiesTemplateConfigSelectList(dto, configDto);
            return Result.ok(list);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 获取单策略新增明细模板
     */
    @ApiOperation(value = "获取活动细案明细模板配置")
    @GetMapping("getItemColumnConfig")
    public Result<ActivitiesTemplateConfigVo> getItemColumnConfig(@ApiParam(value = "模板编码") @RequestParam(required = true) String configCode) {
        try {
            ActivitiesTemplateConfigVo configVo = activitiesTemplateSdkService.findByCode(configCode);
            return Result.ok(configVo);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 活动类型下拉
     *
     * @param dto 活动类型查询参数
     */
    @ApiOperation(value = "活动类型下拉")
    @PostMapping("findActivityTypeSelectList")
    public Result<List<CommonSelectVo>> findActivityTypeSelectList(@ApiParam(value = "活动类型dto") @RequestBody ActivityTypeSelectDto dto) {
        try {
            List<CommonSelectVo> list = activityDetailPlanItemService.findActivityTypeSelectList(dto);
            return Result.ok(list);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 活动形式下拉
     *
     * @param dto 活动形式查询参数
     */
    @ApiOperation(value = "活动形式下拉")
    @PostMapping("findActivityFormSelectList")
    public Result<List<CommonSelectVo>> findActivityFormSelectList(@ApiParam(value = "活动形式dto") @RequestBody ActivityFormSelectDto dto) {
        try {
            List<CommonSelectVo> list = activityDetailPlanItemService.findActivityFormSelectList(dto);
            return Result.ok(list);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 获取预算汇总信息
     *
     * @param cacheKey 缓存key
     * @return
     */
    @ApiOperation(value = "获取预算汇总信息")
    @PostMapping("findBudgetCacheSumList")
    public Result<List<ActivityDetailPlanBudgetSumVo>> findActivityDetailPlanItemBudgetCacheSumList(
            @ApiParam(name = "businessUnitCode", value = "业务单元") @RequestParam String businessUnitCode,
            @ApiParam(name = "cacheKey", value = "缓存键") @RequestParam String cacheKey) {
        try {
            List<ActivityDetailPlanBudgetSumVo> list = this.activityDetailPlanItemService.findBudgetCacheSumList(businessUnitCode,cacheKey);
            return Result.ok(list);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    /**
     * 根据关联方案编码关闭活动细案
     * @param businessNoList 关联方案编码
     */
    @ApiOperation(value = "根据关联方案编码关闭活动细案")
    @PostMapping("closeByPlanCodeItemList")
    public Result<?> closeByPlanCodeItemList(@ApiParam(name = "ids", value = "要关闭的方案编码") @RequestBody List<String> businessNoList) {
        try {
            this.activityDetailPlanItemService.closeByPlanCodeItemList(businessNoList);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 关闭活动细案明细
     * @param ids 活动细案明细id集合
     */
    @ApiOperation(value = "关闭活动细案明细")
    @PostMapping("closeItem")
    public Result<?> closeItem(@ApiParam(name = "ids", value = "要删除的数据") @RequestBody List<String> ids) {
        boolean lockSuccess = false;
        try {
            //锁1小时
            lockSuccess = redisLockService.batchLock(ActivityDetailPlanConstant.LOCK_ACTIVITY_DETAIL_PLAN_ITEM_CLOSE, ids, TimeUnit.HOURS, 1);
            Assert.isTrue(lockSuccess, "其他人正在操作数据,加锁失败,请稍后重试!");
            this.activityDetailPlanItemService.closeItem(ids);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        } finally {
            if (lockSuccess){
                redisLockService.batchUnLock(ActivityDetailPlanConstant.LOCK_ACTIVITY_DETAIL_PLAN_ITEM_CLOSE, ids);
            }
        }
    }

    /**
     * 关闭活动细案明细推送sd
     * @param itemCodeList 活动细案明细id集合
     */
    @ApiOperation(value = "关闭活动细案明细推送sd")
    @PostMapping("closeSdActivityItem")
    public Result<?> closeSdActivityItem(@RequestBody List<String> itemCodeList) {
        try {
            //关闭活动细案之后要推送SAP，异步推送
            this.activityDetailPlanItemAsyncService.closeSdActivityItem(itemCodeList,loginUserService.getAbstractLoginUser());
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    /**
     * 垂直活动方案细案明细关闭后推预算定时任务手动执行
     */
    @ApiOperation(value = "垂直活动方案细案明细关闭后推预算定时任务手动执行")
    @PostMapping("syncBudgetRollbackVertical")
    public Result<?> syncBudgetRollbackVertical() {
        try {
            this.activityDetailPlanService.syncBudgetRollbackVertical();
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 查看明细
     *
     * @param detailPlanItemCode detailPlanItemCode
     */
    @ApiOperation(value = "关闭活动细案明细推送sd")
    @PostMapping("findTerminalListByDetailPlanCode")
    public Result<List<ActivityDetailPlanReportVo>> findTerminalListByDetailPlanCode(@RequestParam String detailPlanItemCode) {
        try {
            List<ActivityDetailPlanReportVo> list = this.activityDetailPlanItemTerminalService.findTerminalListByDetailPlanItemCode(detailPlanItemCode);
            return Result.ok(list);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
    /**
     * 根据细案明细编码查询门店详情
     */
    @ApiOperation(value = "根据细案明细编码查询门店详情")
    @GetMapping("findTerminalByDetailPlanItemCode")
    public Result<Page<ActivityDetailPlanItemTerminalVo>> findTerminalByDetailPlanItemCode(@PageableDefault(50) Pageable pageable,@RequestParam String detailPlanItemCode) {
        try {
            Page<ActivityDetailPlanItemTerminalVo> page = this.activityDetailPlanItemTerminalService.findTerminalByDetailPlanItemCode(pageable,detailPlanItemCode);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 细案明细编查询（物料采购单用）
     */
    @ApiOperation(value = "细案明细编查询（物料采购单用）")
    @GetMapping("findItemForMaterialPurchasing")
    public Result<Page<ActivityDetailPlanItemVo>> findItemForMaterialPurchasing(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                                                        @ApiParam(name = "activityDetailPlanItemDto", value = "查询实体") ActivityDetailPlanItemDto activityDetailPlanItemDto) {
        try {
            Page<ActivityDetailPlanItemVo> page = this.activityDetailPlanItemService.findItemForMaterialPurchasing(pageable,activityDetailPlanItemDto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    /**
     * 重复活动细案查看
     *
     * @param pageable 分页对象
     * @param dto 查询实体
     * @return 所有数据
     */
    @ApiOperation(value = "重复活动细案查看")
    @GetMapping("repeatActivityDetailPlanItemPage")
    public Result<Page<ActivityDetailPlanItemVo>> repeatActivityDetailPlanItemPage(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                                   @ApiParam(name = "dto", value = "查询实体") ActivityDetailPlanItemDto dto) {
        try {
            Page<ActivityDetailPlanItemVo> page =  this.activityDetailPlanItemService.repeatActivityDetailPlanItemPage(pageable,dto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
}
