package com.biz.crm.tpm.business.activity.detail.plan.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.ActivityDetailPlanVoService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.Api;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 活动细案查询
 * @author wanghaojia
 * @date 2023/12/20 14:50
 */
@RestController
@RequestMapping("/v1/activityDetailPlan")
@Slf4j
@Api(tags = "活动细案表")
public class ActivityDetailPlanVoController {

    /**
     * 服务对象
     */
    @Autowired(required = false)
    private ActivityDetailPlanVoService activityDetailPlanVoService;

//    年月	区域	活动分类	活动形式	费用合计（元）	总部承担金额（元）	大区承担金额(元)	预估销售额（元）	预估费率
//    以申请的活动方案明细的活动开始时间、活动结束时间、区域、活动分类、活动形式维度进行统计								费用合计/预估销售额

    /**
     * 活动方案移动审批关键指标-预算汇总信息
     * @param processNo 流程编码
     */
    @GetMapping("findActivityDetailPlanItemSumInfoByProcessNo")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public Result<List<ActivityDetailPlanItemVo>> findActivityDetailPlanItemSumInfoByProcessNo(@RequestParam String processNo){
        try {
//            预算项目	年月	本月累计可用金额（元）	管控累计可用金额（元）	本次使用金额（元）
            List<ActivityDetailPlanItemVo> list = activityDetailPlanVoService.findActivityDetailPlanItemSumInfoByProcessNo(processNo);
            return Result.ok(list);
        }catch (Exception e){
            log.error(e.getMessage(),e);
            return Result.error("预算汇总信息查询失败:"+e.getMessage());
        }
    }

}
