package com.biz.crm.tpm.business.activity.detail.plan.local.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.log.sdk.constant.ForeignLogGlobalConstants;
import com.biz.crm.mn.common.log.sdk.dto.ForeignLogDetailDto;
import com.biz.crm.mn.common.log.sdk.service.ForeignLogVoService;
import com.biz.crm.mn.common.log.sdk.util.ForeignLogUtil;
import com.biz.crm.mn.third.system.cow.manager.sdk.constant.CowManagerConstant;
import com.biz.crm.tpm.business.activity.detail.plan.local.event.FXiaoKeForeignActivityDetailPlanEvent;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.ForeignActivityDetailPlanApiAsyncService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.foreign.ForeignActivityDetailPlanEventDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ForeignActivityDetailPlanEvent;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Optional;


/**
 * 外部系统调用处理活动细案接口
 * @author wanghaojia
 * @date 2023/11/26 12:20
 */
@RestController
@RequestMapping("/v1/foreign/api/activityDetailPlan")
@Slf4j
@Api(tags = "外部系统调用处理活动细案接口")
public class ForeignActivityDetailPlanApiController {

    @Autowired(required = false)
    private ForeignActivityDetailPlanApiAsyncService foreignActivityDetailPlanApiAsyncService;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    @Autowired(required = false)
    private ForeignLogVoService foreignLogVoService;

    @Autowired(required = false)
    private NebulaNetEventClient nebulaNetEventClient;

    @Autowired(required = false)
    private FXiaoKeForeignActivityDetailPlanEvent fXiaoKeForeignActivityDetailPlanEvent;

    /**
     * 活动细案创建接口
     * @param object 活动对象
     * @return
     */
    @PostMapping(value = "create")
    public Result create(@RequestBody JSONObject object){
        ForeignLogDetailDto detailDto = ForeignLogUtil.buildLogSaveInfo(object);
        detailDto.setMethod("ForeignActivityDetailPlanApiController.create");
        detailDto.setMethodMsg("外部系统创建活动细案");
        detailDto.setInvokeType(ForeignLogGlobalConstants.EXTERNAL_INTERFACE);
        foreignLogVoService.addOrUpdateLog(detailDto, true);
        foreignActivityDetailPlanApiAsyncService.create(object,loginUserService.getAbstractLoginUser());
        Result<?> result = Result.ok();
        ForeignLogUtil.buildLogResult(detailDto, result);
        foreignLogVoService.addOrUpdateLog(detailDto, false);
        return result;
    }

    /**
     * 活动细案创建回调接口
     */
    @PostMapping(value = "createFinish")
    public Result createFinish(@RequestBody Result<ActivityDetailPlanDto> result){
        ForeignActivityDetailPlanEventDto eventDto = new ForeignActivityDetailPlanEventDto();
        eventDto.setResult(result);
        SerializableBiConsumer<ForeignActivityDetailPlanEvent, ForeignActivityDetailPlanEventDto> createFinish =
                ForeignActivityDetailPlanEvent::createFinish;
        this.nebulaNetEventClient.publish(eventDto,ForeignActivityDetailPlanEvent.class, createFinish);
        return Result.ok();
    }

    /**
     * 活动细案创建回调接口
     */
    @PostMapping(value = "createFinish/fxiaoke")
    public Result createFinishFXiaoKe(@RequestBody Result<ActivityDetailPlanDto> result){
        ForeignActivityDetailPlanEventDto eventDto = new ForeignActivityDetailPlanEventDto();
        eventDto.setResult(result);
        fXiaoKeForeignActivityDetailPlanEvent.createFinish(eventDto);
        return Result.ok();
    }

}
