package com.biz.crm.tpm.business.activity.detail.plan.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mn.third.system.cow.manager.sdk.dto.CowManagerExecutionDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.PushActivityToThirdSystemService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @Description: 活动细案-促销活动 推送 第三方系统 控制层
 * @Author qiancheng
 * @Date 2023/1/17
 */
@RestController
@Slf4j
@Api(tags = "活动细案推送第三方系统")
@RequestMapping("/v1/activityDetailPlan/third")
public class PushActivityToThirdSystemController {

    @Autowired(required = false)
    private PushActivityToThirdSystemService pushActivityToThirdSystemService;

    /**
     * =========================== 牛人管家 ====================================
     */

    @ApiOperation(value = "牛人管家——促销活动创建、变更")
    @PostMapping(value = {"/cowManager/activity"})
    public Result createActivityPushOrderShare(@ApiParam(name = "codes", value = "细案编码集合")
                                               @RequestBody List<String> codes){
        try {
            pushActivityToThirdSystemService.activityCreateOrUpdatePushCowManager(codes);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "牛人管家——促销活动关闭")
    @PostMapping(value = {"/cowManager/activity/close"})
    public Result activityClosePushCowManager(@ApiParam(name = "codes", value = "明细编码集合")
                                               @RequestBody List<String> codes){
        try {
            pushActivityToThirdSystemService.activityClosePushCowManager(codes);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "牛人管家——活动执行查询")
    @PostMapping(value = {"/cowManager/query"})
    public Result<List<CowManagerExecutionDto>> createActivityPushOrderShare(@RequestParam("type") String type,@RequestParam(value = "activeNumber",required = false) String activeNumber){
        try {
            List<CowManagerExecutionDto> dtoList = pushActivityToThirdSystemService.queryActivityExecution(type, activeNumber);
            return Result.ok(dtoList);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * =========================== SAP ====================================
     */

    @ApiOperation(value = "SAP-促销活动创建推送-按细案编码")
    @PostMapping(value = {"/sap/create/byPlanCodes"})
    public Result createActivityPushSapByPlanCodes(@ApiParam(name = "codes", value = "细案编码集合")
                                                    @RequestBody List<String> codes){
        try {
            pushActivityToThirdSystemService.createActivityPushSapByPlanCodes(codes);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "SAP-促销活动创建推送-按明细编码")
    @PostMapping(value = {"/sap/create/byItemCodes"})
    public Result createActivityPushSapByItemCodes(@ApiParam(name = "codes", value = "明细编码集合")
                                                    @RequestBody List<String> codes){
        try {
            pushActivityToThirdSystemService.createActivityPushSapByItemCodes(codes);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "SAP-促销活动变更——按细案编码")
    @PostMapping(value = {"/sap/update/byPlanCodes"})
    public Result updateActivityPushSapByPlanCodes(@ApiParam(name = "codes", value = "明细编码集合")
                                                @RequestBody List<String> codes){
        try {
            pushActivityToThirdSystemService.updateActivityPushSapByPlanCodes(codes,false);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "SAP-促销活动变更——按明细编码")
    @PostMapping(value = {"/sap/update/byItemCodes"})
    public Result updateActivityPushSapByItemCodes(@ApiParam(name = "codes", value = "明细编码集合")
                                                @RequestBody List<String> codes){
        try {
            pushActivityToThirdSystemService.updateActivityPushSapByItemCodes(codes,false);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    @ApiOperation(value = "SAP-促销活动关闭-按明细编码")
    @PostMapping(value = {"/sap/close/byItemCodes"})
    public Result closeActivityPushSapByItemCodes(@ApiParam(name = "codes", value = "明细编码集合")
                                               @RequestBody List<String> codes){
        try {
            pushActivityToThirdSystemService.updateActivityPushSapByItemCodes(codes,true);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "SAP-促销活动关闭-按细案编码")
    @PostMapping(value = {"/sap/close/byPlanCodes"})
    public Result closeActivityPusSapByPlanCodes(@ApiParam(name = "codes", value = "细案编码集合")
                                               @RequestBody List<String> codes){
        try {
            pushActivityToThirdSystemService.updateActivityPushSapByPlanCodes(codes,true);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

}

