package com.biz.crm.tpm.business.activity.detail.plan.local.entity;

/**
 * 活动方案占用预算汇总表
 * @author wanghaojia
 * @date 2022/11/26 11:17
 */

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

@ApiModel(value = "ActivityDetailPlanBudgetSum", description = "活动细案占用预算汇总表")
@TableName("tpm_activity_detail_plan_budget_sum")
@Getter
@Setter
@Entity(name = "tpm_activity_detail_plan_budget_sum")
@org.hibernate.annotations.Table(appliesTo = "tpm_activity_detail_plan_budget_sum", comment = "活动细案占用预算汇总表")
@Table(
        name = "tpm_activity_detail_plan_budget_sum",
        indexes = {
                @Index(name = "tpm_dp_budget_sum_inx1", columnList = "detail_plan_code"),
        }
)
public class ActivityDetailPlanBudgetSum extends TenantFlagOpEntity {

    /**
     * 活动细案编码
     */
    @ApiModelProperty("活动细案编码")
    @Column(name = "detail_plan_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '活动细案编码'")
    private String detailPlanCode;

    /**
     * 预算编码
     */
    @ApiModelProperty(value = "预算编码", notes = "")
    @Column(name = "month_budget_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '预算项目编码'")
    private String monthBudgetCode;

    /**
     * 预算项目编码
     */
    @ApiModelProperty(value = "预算项目编码", notes = "")
    @Column(name = "budget_item_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '预算项目编码'")
    private String budgetItemCode;

    /**
     * 预算项目名称
     */
    @ApiModelProperty(value = "预算项目名称", notes = "")
    @Column(name = "budget_item_name", nullable = true, length = 255, columnDefinition = "varchar(255) COMMENT '预算项目名称'")
    private String budgetItemName;

    /**
     * 归口
     */
    @ApiModelProperty("归口")
    @Column(name = "fee_belong_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '归口'")
    private String feeBelongCode;

    /**
     * 年月
     */
    @ApiModelProperty(value = "年月", notes = "")
    @Column(name = "year_month_ly", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '年月 '")
    private String yearMonthLy;

    /**
     * 组织编码
     */
    @ApiModelProperty(value = "组织编码", notes = "")
    @Column(name = "org_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '组织编码 '")
    private String orgCode;

    /**
     * 组织名称
     */
    @ApiModelProperty(value = "组织名称", notes = "")
    @Column(name = "org_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '组织名称 '")
    private String orgName;

    /**
     * 本月累计可用金额
     */
    @Column(name = "accumulated_available_balance", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '累计可用余额 '")
    private BigDecimal accumulatedAvailableBalance;
    /**
     * 预算管控可用余额
     */
    @ApiModelProperty(value = "预算管控可用余额", notes = "")
    @Column(name = "control_balance_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '预算管控可用余额 '")
    private BigDecimal controlBalanceAmount;

    /**
     * 本次使用金额
     */
    @ApiModelProperty(value = "本次使用金额", notes = "")
    @Column(name = "use_amount", nullable = true, length = 24, columnDefinition = "decimal(24,6) COMMENT '本次使用金额'")
    private BigDecimal useAmount;

}
