package com.biz.crm.tpm.business.activity.detail.plan.local.entity;


import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.*;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 活动细案明细表(ActivityDetailPlanItem)
 *
 * @author wanghaojia
 * @since 2022-11-12 15:14:12
 */
@ApiModel(value = "ActivityDetailPlanItem", description = "活动细案明细表")
@TableName("tpm_activity_detail_plan_item")
@ToString
@Getter
@Setter
@Entity(name = "tpm_activity_detail_plan_item")
@org.hibernate.annotations.Table(appliesTo = "tpm_activity_detail_plan_item", comment = "活动细案明细表")
@Table(
    name = "tpm_activity_detail_plan_item",
    indexes = {
        @Index(name = "activity_detail_plan_item_inx1", columnList = "detail_plan_item_code", unique = true),
        @Index(name = "activity_detail_plan_item_inx2", columnList = "detail_plan_code"),
        @Index(name = "activity_detail_plan_item_inx3", columnList = "audit_form"),
        @Index(name = "activity_detail_plan_item_inx4", columnList = "relate_plan_code"),
        @Index(name = "activity_detail_plan_item_inx5", columnList = "relate_plan_item_code"),
        @Index(name = "activity_detail_plan_item_inx6", columnList = "product_code"),
        @Index(name = "activity_detail_plan_item_inx7", columnList = "terminal_code"),
        @Index(name = "activity_detail_plan_item_inx8", columnList = "activity_end_date,activity_begin_date"),
        @Index(name = "activity_detail_plan_item_inx9", columnList = "fee_year_month"),
        @Index(name = "activity_detail_plan_item_inx10", columnList = "activity_begin_date"),
        @Index(name = "activity_detail_plan_item_inx11", columnList = "activity_type_code"),
        @Index(name = "activity_detail_plan_item_inx12", columnList = "activity_org_code"),
        @Index(name = "activity_detail_plan_item_inx13", columnList = "sales_org_code"),
    }
)
public class ActivityDetailPlanItem extends TenantFlagOpEntity {

    @ApiModelProperty("活动号")
    @Column(name = "activity_number", length = 64, columnDefinition = "VARCHAR(64) COMMENT '活动号'")
    private String  activityNumber;

    /**
     * 本品生产日期
     */
    @ApiModelProperty("本品生产日期")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "this_product_production_date", length = 20, columnDefinition = "datetime COMMENT '本品生产日期 '")
    private Date thisProductProductionDate;
    /**
     * 赠品生产日期
     */
    @ApiModelProperty("赠品生产日期")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    @DateTimeFormat(pattern = "yyyy-MM")
    @Column(name = "gift_production_date", length = 20, columnDefinition = "datetime COMMENT '赠品生产日期 '")
    private Date giftProductionDate;
    /**
     * 电话
     */
    @ApiModelProperty("电话")
    @Column(name = "telephone", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '电话 '")
    private String telephone;

    @ApiModelProperty(name = "identityCard", notes = "身份证号")
    @Column(name = "identity_card", columnDefinition = "varchar(20) COMMENT '身份证号'")
    private String identityCard;
    /**
     * 员工ID
     */
    @ApiModelProperty("员工ID")
    @Column(name = "employee_id", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '员工ID '")
    private String employeeId;
    /**
     * 导购员姓名
     */
    @ApiModelProperty("导购员姓名")
    @Column(name = "name_of_shopping_guide", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '导购员姓名 '")
    private String nameOfShoppingGuide;
    /**
     * 责任督导
     */
    @ApiModelProperty("责任督导")
    @Column(name = "responsible_supervision", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '责任督导 '")
    private String responsibleSupervision;
    /**
     * 责任业务
     */
    @ApiModelProperty("责任业务")
    @Column(name = "responsible_business", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '责任业务 '")
    private String responsibleBusiness;
    /**
     * 城市级别
     */
    @ApiModelProperty("城市级别")
    @Column(name = "city_level", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '城市级别 '")
    private String cityLevel;
    /**
     * 城市名称
     */
    @ApiModelProperty("城市名称")
    @Column(name = "city_name", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '城市名称 '")
    private String cityName;

    /**
     * 档期时间
     */
    @ApiModelProperty("档期时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    @DateTimeFormat(pattern = "yyyy-MM")
    @Column(name = "schedule_time", length = 20, columnDefinition = "datetime COMMENT '档期时间 '")
    private Date scheduleTime;
    /**
     * 是否档期
     */
    @ApiModelProperty("是否档期")
    @Column(name = "on_schedule_or_not", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '是否档期'")
    private String onScheduleOrNot;
    /**
     * 投产比
     */
    @ApiModelProperty("投产比")
    @Column(name = "production_ratio", length = 32, columnDefinition = "decimal(24,6) COMMENT '投产比'")
    private BigDecimal productionRatio;
    /**
     * 月度计划量
     */
    @ApiModelProperty("月度计划量")
    @Column(name = "monthly_planned_quantity", length = 32, columnDefinition = "int(11) COMMENT '月度计划量'")
    private BigDecimal monthlyPlannedQuantity;
    /**
     * AC门店类型
     */
    @ApiModelProperty("AC门店类型")
    @Column(name = "ac_store_type", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT 'AC门店类型'")
    private String acStoreType;
    /**
     * AC分仓编码
     */
    @ApiModelProperty("AC分仓编码")
    @Column(name = "ac_warehouse_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT 'AC分仓编码 '")
    private String acWarehouseCode;
    /**
     * AC分仓
     */
    @ApiModelProperty("AC分仓")
    @Column(name = "ac_warehouse", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT 'AC分仓'")
    private String acWarehouse;
    /**
     * 核销方式
     */
    @ApiModelProperty("核销方式")
    @Column(name = "write_off_method", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '核销方式'")
    private String writeOffMethod;
    /**
     * 原供价（本品）
     */
    @ApiModelProperty("原供价（本品）")
    @Column(name = "original_supply_price", length = 24, columnDefinition = "decimal(24,6) COMMENT '原供价（本品）'")
    private BigDecimal originalSupplyPrice;
    /**
     * 税率
     */
    @ApiModelProperty("税率")
    @Column(name = "tax_Rate", length = 24, columnDefinition = "decimal(24,6) COMMENT '税率'")
    private BigDecimal taxRate;
    /**
     * 原未税价格（本品）
     */
    @ApiModelProperty("原未税价格（本品）")
    @Column(name = "original_price_product", length = 24, columnDefinition = "decimal(24,6) COMMENT '原未税价格（本品）'")
    private BigDecimal originalPriceProduct;
    /**
     * 原供价（赠品）
     */
    @ApiModelProperty( "原供价（赠品）")
    @Column(name = "original_price_gift", length = 24, columnDefinition = "decimal(24,6) COMMENT '原供价（赠品）'")
    private BigDecimal originalPriceGift;
    /**
     * 原未税价格（赠品）
     */
    @ApiModelProperty("原未税价格（赠品）")
    @Column(name = "original_tax_price_gift", length = 24, columnDefinition = "decimal(24,6) COMMENT '原未税价格（赠品）'")
    private BigDecimal originalTaxPriceGift;
    /**
     * 促销含税供价
     */
    @ApiModelProperty("促销含税供价")
    @Column(name = "promotion_price_tax", length = 24, columnDefinition = "decimal(24,6) COMMENT '促销含税供价'")
    private BigDecimal promotionPriceTax;
    /**
     * 促销未税供价
     */
    @ApiModelProperty("促销未税供价")
    @Column(name = "promotion_non_tax_price", length = 24, columnDefinition = "decimal(24,6) COMMENT '促销未税供价'")
    private BigDecimal promotionNonTaxPrice;
    /**
     * 零售价
     */
    @ApiModelProperty("零售价")
    @Column(name = "retail_price", length = 24, columnDefinition = "decimal(24,6) COMMENT '零售价'")
    private BigDecimal retailPrice;
    /**
     * 促销售价
     */
    @ApiModelProperty("促销售价")
    @Column(name = "promotional_price", length = 24, columnDefinition = "decimal(24,6) COMMENT '促销售价'")
    private BigDecimal promotionalPrice;
    /**
     * 原毛利率
     */
    @ApiModelProperty("原毛利率")
    @Column(name = "original_gross_rate", length = 24, columnDefinition = "decimal(24,6) COMMENT '原毛利率'")
    private BigDecimal originalGrossRate;
    /**
     * 促销毛利率
     */
    @ApiModelProperty("促销毛利率")
    @Column(name = "promotional_gross_rate", length = 24, columnDefinition = "decimal(24,6) COMMENT '促销毛利率'")
    private BigDecimal promotionalGrossRate;
    /**
     * 单件申请费用
     */
    @ApiModelProperty("单件申请费用")
    @Column(name = "single_application_fee", length = 24, columnDefinition = "decimal(24,6) COMMENT '单件申请费用'")
    private BigDecimal singleApplicationFee;

    /**
     * 期间促销件数
     */
    @ApiModelProperty("期间促销件数")
    @Column(name = "period_promotional_number", length = 11, columnDefinition = "int(11) COMMENT '期间促销件数'")
    private Integer periodPromotionalNumber;

    /**
     * 商超期间促销件数已用
     */
    @ApiModelProperty("商超期间促销件数已用")
    @Column(name = "period_promotional_number_use", length = 11, columnDefinition = "int(11) COMMENT '商超期间促销件数已用'")
    private Integer periodPromotionalNumberUse;
    /**
     * 期间促销金额
     */
    @ApiModelProperty("期间促销金额")
    @Column(name = "period_promotional_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '期间促销金额'")
    private BigDecimal periodPromotionalAmount;
    /**
     * 系统承担金额
     */
    @ApiModelProperty("系统承担金额")
    @Column(name = "system_borne_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '系统承担金额'")
    private BigDecimal systemBorneAmount;
    /**
     * 单品计划量
     */
    @ApiModelProperty("单品计划量")
    @Column(name = "planned_quantity_single", length = 11, columnDefinition = "int(11) COMMENT '单品计划量'")
    private Integer plannedQuantitySingle;
    /**
     * 单品投产比
     */
    @ApiModelProperty("单品投产比")
    @Column(name = "single_production_ratio", length = 32, columnDefinition = "decimal(24,6) COMMENT '单品投产比'")
    private BigDecimal singleProductionRatio;
    /**
     * 系统门店计划量
     */
    @ApiModelProperty("系统门店计划量")
    @Column(name = "system_stores_quantity", length = 11, columnDefinition = "int(11) COMMENT '系统门店计划量'")
    private Integer systemStoresQuantity;
    /**
     * 单店投产比
     */
    @ApiModelProperty("单店投产比")
    @Column(name = "stores_production_ratio", length = 32, columnDefinition = "decimal(24,6) COMMENT '单店投产比'")
    private BigDecimal storesProductionRatio;
    /**
     * 系统月计划量
     */
    @ApiModelProperty("系统月计划量")
    @Column(name = "system_monthly_quantity", length = 11, columnDefinition = "int(11) COMMENT '系统月计划量'")
    private Integer systemMonthlyQuantity;
    /**
     * 是否公用
     */
    @ApiModelProperty("是否公用")
    @Column(name = "public_or_not", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '是否公用'")
    private String publicOrNot;
    /**
     * 门店公用量
     */
    @ApiModelProperty("门店公用量")
    @Column(name = "store_utility", length = 11, columnDefinition = "int(11) COMMENT '门店公用量'")
    private Integer storeUtility;
    /**
     * 门店公用金额
     */
    @ApiModelProperty("门店公用金额")
    @Column(name = "store_public_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '门店公用金额'")
    private BigDecimal storePublicAmount;
    /**
     * 浮动率
     */
    @ApiModelProperty("浮动率")
    @Column(name = "floating_rate", length = 24, columnDefinition = "decimal(24,6) COMMENT '浮动率'")
    private BigDecimal floatingRate;
    /**
     * 浮动量
     */
    @ApiModelProperty("浮动量")
    @Column(name = "floating_number", length = 11, columnDefinition = "decimal(24,6) COMMENT '浮动量'")
    private BigDecimal floatingNumber;
    /**
     * 浮动金额
     */
    @ApiModelProperty("浮动金额")
    @Column(name = "floating_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '浮动金额'")
    private BigDecimal floatingAmount;
    /**
     * 区域
     */
    @ApiModelProperty("区域")
    @Column(name = "region", length = 32, columnDefinition = "varchar(32) COMMENT '区域'")
    private String region;
    /**
     * 城市经理
     */
    @ApiModelProperty("城市经理")
    @Column(name = "city_manager", length = 255, columnDefinition = "varchar(255) COMMENT '城市经理'")
    private String cityManager;
    /**
     * 未含税单价
     */
    @ApiModelProperty("未含税单价")
    @Column(name = "price_excluding_tax", length = 24, columnDefinition = "decimal(24,6) COMMENT '未含税单价'")
    private BigDecimal priceExcludingTax;
    /**
     * 含税单价
     */
    @ApiModelProperty("含税单价")
    @Column(name = "price_including_tax", length = 24, columnDefinition = "decimal(24,6) COMMENT '含税单价'")
    private BigDecimal priceIncludingTax;
    /**
     * 未含税金额
     */
    @ApiModelProperty("未含税金额")
    @Column(name = "amount_excluding_tax", length = 24, columnDefinition = "decimal(24,6) COMMENT '未含税金额'")
    private BigDecimal amountExcludingTax;
    /**
     * 含税金额
     */
    @ApiModelProperty("含税金额")
    @Column(name = "amount_including_tax", length = 24, columnDefinition = "decimal(24,6) COMMENT '含税金额'")
    private BigDecimal amountIncludingTax;
    /**
     * 扣费细项
     */
    @ApiModelProperty("扣费细项")
    @Column(name = "deduction_details", length = 255, columnDefinition = "varchar(255) COMMENT '扣费细项'")
    private String deductionDetails;
    /**
     * 扣费类型
     */
    @ApiModelProperty("扣费类型")
    @Column(name = "deduction_type", length = 32, columnDefinition = "varchar(32) COMMENT '扣费类型'")
    private String deductionType;
    /**
     * 扣费标准
     */
    @ApiModelProperty("扣费标准")
    @Column(name = "deduction_standard", length = 255, columnDefinition = "varchar(255) COMMENT '扣费标准'")
    private String deductionStandard;
    /**
     * 费率
     */
    @ApiModelProperty("费率")
    @Column(name = "rate", length = 24, columnDefinition = "decimal(24,6) COMMENT '费率'")
    private BigDecimal rate;
    /**
     * 平台
     */
    @ApiModelProperty("平台")
    @Column(name = "platform", length = 255, columnDefinition = "varchar(255) COMMENT '平台'")
    private String platform;

    /**
     * 数量
     */
    @ApiModelProperty("数量")
    @Column(name = "quantity", length = 11, columnDefinition = "int(11) COMMENT '数量'")
    private Integer quantity;

    /**
     * POS已使用数量
     */
    @ApiModelProperty("POS已使用数量")
    @Column(name = "quantity_pos_used", length = 11, columnDefinition = "int(11) COMMENT 'POS已使用数量'")
    private Integer quantityPosUsed;

    /**
     * 区域编码
     */
    @ApiModelProperty("区域编码")
    @Column(name = "activity_org_code", length = 32, columnDefinition = "varchar(32) COMMENT '区域编码'")
    private String activityOrgCode;
    /**
     * 区域名称
     */
    @ApiModelProperty("区域名称")
    @Column(name = "activity_org_name", length = 255, columnDefinition = "varchar(255) COMMENT '区域名称'")
    private String activityOrgName;
    /**
     * 总部承担金额
     */
    @ApiModelProperty("总部承担金额")
    @Column(name = "head_fee_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '总部承担金额'")
    private BigDecimal headFeeAmount;
    /**
     * 总部预算项目编码
     */
    @ApiModelProperty("总部预算项目编码")
    @Column(name = "head_budget_item_code", length = 32, columnDefinition = "varchar(32) COMMENT '总部预算项目编码'")
    private String headBudgetItemCode;
    /**
     * 总部预算项目名称
     */
    @ApiModelProperty("总部预算项目名称")
    @Column(name = "head_budget_item_name", length = 255, columnDefinition = "varchar(255) COMMENT '总部预算项目名称'")
    private String headBudgetItemName;
    /**
     * 上级方案明细编码
     */
    @ApiModelProperty("上级方案明细编码")
    @Column(name = "relate_plan_item_code", length = 32, columnDefinition = "varchar(32) COMMENT '上级方案明细编码'")
    private String relatePlanItemCode;
    /**
     * 订单开始时间
     */
    @ApiModelProperty("订单开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "order_begin_date",  columnDefinition = "datetime COMMENT '活动结束时间'")
    private Date orderBeginDate;
    /**
     * 订单结束时间
     */
    @ApiModelProperty("订单结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "order_end_date",  columnDefinition = "datetime COMMENT '活动结束时间'")
    private Date orderEndDate;

    @ApiModelProperty("流程状态")
    @Column(name = "process_status", length = 32, columnDefinition = "varchar(32) COMMENT '流程状态'")
    private String processStatus;

    /**
     * 活动细案编码
     */
    @ApiModelProperty("活动细案编码")
    @Column(name = "detail_plan_code", length = 32, columnDefinition = "varchar(32) COMMENT '活动细案编码'")
    private String detailPlanCode;
    /**
     * 活动细案名称
     */
    @ApiModelProperty("活动细案明细编码")
    @Column(name = "detail_plan_item_code", length = 255, columnDefinition = "varchar(255) COMMENT '活动细案明细编码'")
    private String detailPlanItemCode;
    /**
     * 业态编码
     */
    @ApiModelProperty(value = "业态编码", notes = "")
    @Column(name = "business_format_code", length = 32, columnDefinition = "varchar(32) COMMENT '业态编码'")
    private String businessFormatCode;
    /**
     * 业务单元编码
     */
    @ApiModelProperty(value = "业务单元编码", notes = "")
    @Column(name = "business_unit_code", length = 32, columnDefinition = "varchar(32) COMMENT '业务单元编码'")
    private String businessUnitCode;

    /**
     * 细案模板编码
     */
    @ApiModelProperty("细案模板编码")
    @Column(name = "template_config_code", length = 32, columnDefinition = "varchar(32) COMMENT '细案模板编码'")
    private String templateConfigCode;
    /**
     * 活动类型编码
     */
    @ApiModelProperty("活动类型编码")
    @Column(name = "activity_type_code", length = 255, columnDefinition = "varchar(255) COMMENT '活动类型编码'")
    private String activityTypeCode;
    /**
     * 活动类型名称
     */
    @ApiModelProperty("活动类型名称")
    @Column(name = "activity_type_name", length = 255, columnDefinition = "varchar(255) COMMENT '活动类型名称'")
    private String activityTypeName;
    /**
     * 活动形式编码
     */
    @ApiModelProperty("活动形式编码")
    @Column(name = "activity_form_code", length = 255, columnDefinition = "varchar(255) COMMENT '活动形式编码'")
    private String activityFormCode;
    /**
     * 活动形式名称
     */
    @ApiModelProperty("活动形式名称")
    @Column(name = "activity_form_name", length = 255, columnDefinition = "varchar(255) COMMENT '活动形式名称'")
    private String activityFormName;
    /**
     * 活动开始时间
     */
    @ApiModelProperty("活动开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "activity_begin_date", columnDefinition = "datetime COMMENT '活动开始时间'")
    private Date activityBeginDate;
    /**
     * 活动结束时间
     */
    @ApiModelProperty("活动结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "activity_end_date",  columnDefinition = "datetime COMMENT '活动结束时间'")
    private Date activityEndDate;



    /**
     * 客户编码
     */
    @ApiModelProperty("客户编码")
    @Column(name = "customer_code", length = 32, columnDefinition = "varchar(32) COMMENT '客户编码'")
    private String customerCode;

    /**
     * 客户编码
     */
    @ApiModelProperty("客户ERP编码")
    @Column(name = "customer_erp_code", length = 32, columnDefinition = "varchar(32) COMMENT '客户ERP编码'")
    private String customerErpCode;

    /**
     * 客户名称
     */
    @ApiModelProperty("客户名称")
    @Column(name = "customer_name", length = 255, columnDefinition = "varchar(255) COMMENT '客户名称'")
    private String customerName;

    @CrmExcelColumn(value = "客户组编码")
    @Column(name = "customer_group_code", length = 32, columnDefinition = "varchar(32) COMMENT '客户组编码'")
    private String customerGroupCode;

    @CrmExcelColumn(value = "客户组名称")
    @Column(name = "customer_group_name", length = 255, columnDefinition = "varchar(255) COMMENT '客户名称'")
    private String customerGroupName;
    /**
     * 一级管理渠道编码
     */
    @ApiModelProperty("一级管理渠道编码")
    @Column(name = "first_channel_code", length = 128, columnDefinition = "varchar(128) COMMENT '一级管理渠道编码'")
    private String firstChannelCode;
    /**
     * 一级管理渠道名称
     */
    @ApiModelProperty("一级管理渠道名称")
    @Column(name = "first_channel_name", length = 256, columnDefinition = "varchar(256) COMMENT '一级管理渠道名称'")
    private String firstChannelName;
    /**
     * 二级管理渠道编码
     */
    @ApiModelProperty("二级管理渠道编码")
    @Column(name = "second_channel_code", length = 128, columnDefinition = "varchar(128) COMMENT '二级管理渠道编码'")
    private String secondChannelCode;
    /**
     * 二级管理渠道名称
     */
    @ApiModelProperty("二级管理渠道名称")
    @Column(name = "second_channel_name", length = 256, columnDefinition = "varchar(256) COMMENT '二级管理渠道名称'")
    private String secondChannelName;
    /**
     * 总部预算编码
     */
    @ApiModelProperty("总部预算编码")
    @Column(name = "head_month_budget_code", length = 32, columnDefinition = "varchar(32) COMMENT '总部预算编码'")
    private String headMonthBudgetCode;

    /**
     * 大区预算编码
     */
    @ApiModelProperty("预算编码/大区预算编码")
    @Column(name = "month_budget_code", length = 32, columnDefinition = "varchar(32) COMMENT '大区预算编码'")
    private String monthBudgetCode;
    /**
     * 大区预算项目编码
     */
    @ApiModelProperty("大区预算项目编码")
    @Column(name = "budget_item_code", length = 32, columnDefinition = "varchar(32) COMMENT '大区预算项目编码'")
    private String budgetItemCode;
    /**
     * 大区预算项目名称
     */
    @ApiModelProperty("大区预算项目名称")
    @Column(name = "budget_item_name", length = 255, columnDefinition = "varchar(255) COMMENT '大区预算项目名称'")
    private String budgetItemName;


    /**
     * 大区公投预算编码
     */
    @ApiModelProperty(value = "大区公投预算编码", notes = "")
    @Column(name = "region_referendum_month_budget_code", nullable = true, length = 512, columnDefinition = "varchar(512) COMMENT '大区公投预算编码'")
    private String regionReferendumMonthBudgetCode;

    /**
     * 大区公投项目编码
     */
    @ApiModelProperty(value = "大区公投预算项目编码", notes = "")
    @Column(name = "region_referendum_budget_item_code", nullable = true, length = 512, columnDefinition = "varchar(512) COMMENT '大区公投预算项目编码'")
    private String regionReferendumBudgetItemCode;

    /**
     * 大区公投预算项目名称
     */
    @ApiModelProperty(value = "大区公投预算项目名称", notes = "")
    @Column(name = "region_referendum_budget_item_name", nullable = true, length = 1024, columnDefinition = "varchar(255) COMMENT '大区公投预算项目名称'")
    private String regionReferendumBudgetItemName;

    /**
     * 大区公投预算编码
     */
    @ApiModelProperty(value = "大区自投预算编码", notes = "")
    @Column(name = "region_automatic_month_budget_code", nullable = true, length = 512, columnDefinition = "varchar(512) COMMENT '大区自投预算编码'")
    private String regionAutomaticMonthBudgetCode;

    /**
     * 大区公投项目编码
     */
    @ApiModelProperty(value = "大区自投预算项目编码", notes = "")
    @Column(name = "region_automatic_budget_item_code", nullable = true, length = 512, columnDefinition = "varchar(512) COMMENT '大区自投预算项目编码'")
    private String regionAutomaticBudgetItemCode;

    /**
     * 大区公投预算项目名称
     */
    @ApiModelProperty(value = "大区自投预算项目名称", notes = "")
    @Column(name = "region_automatic_budget_item_name", nullable = true, length = 1024, columnDefinition = "varchar(255) COMMENT '大区自投预算项目名称'")
    private String regionAutomaticBudgetItemName;



    /**
     * 上级方案编码
     */
    @ApiModelProperty("上级方案编码")
    @Column(name = "relate_plan_code", length = 32, columnDefinition = "varchar(32) COMMENT '上级方案编码'")
    private String relatePlanCode;

    /**
     * 门店编码
     */
    @ApiModelProperty("门店编码")
    @Column(name = "terminal_code", length = 32, columnDefinition = "varchar(32) COMMENT '门店编码'")
    private String terminalCode;
    /**
     * 门店名称
     */
    @ApiModelProperty("门店名称")
    @Column(name = "terminal_name", length = 255, columnDefinition = "varchar(255) COMMENT '门店名称'")
    private String terminalName;
    /**
     * 门店类型
     */
    @ApiModelProperty(name = "门店类型", notes = "门店类型")
    @Column(name = "terminal_type", length = 32, columnDefinition = "VARCHAR(32) COMMENT '门店类型'")
    private String terminalType;
    /**
     * 门店数量
     */
    @ApiModelProperty("门店数量")
    @Column(name = "terminal_quantity", length = 11, columnDefinition = "int(11) COMMENT '门店数量'")
    private Integer terminalQuantity;
    /**
     * 系统
     */
    @ApiModelProperty("零售商编码")
    @Column(name = "system_code", length = 32, columnDefinition = "varchar(32) COMMENT '零售商编码'")
    private String systemCode;
    /**
     * 系统
     */
    @ApiModelProperty("零售商名称")
    @Column(name = "system_name", length = 200, columnDefinition = "varchar(200) COMMENT '零售商名称'")
    private String systemName;
    /**
     * 供应商编码
     */
    @ApiModelProperty("供应商编码")
    @Column(name = "supplier_code", length = 32, columnDefinition = "varchar(32) COMMENT '供应商编码'")
    private String supplierCode;
    /**
     * 供应商名称
     */
    @ApiModelProperty("供应商名称")
    @Column(name = "supplier_name", length = 255, columnDefinition = "varchar(255) COMMENT '供应商名称'")
    private String supplierName;
    /**
     * 品牌编码
     */
    @ApiModelProperty("品牌编码")
    @Column(name = "product_brand_code", length = 32, columnDefinition = "varchar(32) COMMENT '品牌编码'")
    private String productBrandCode;
    /**
     * 品牌名称
     */
    @ApiModelProperty("品牌名称")
    @Column(name = "product_brand_name", length = 255, columnDefinition = "varchar(255) COMMENT '品牌名称'")
    private String productBrandName;
    /**
     * 品类编码
     */
    @ApiModelProperty("品类编码")
    @Column(name = "product_category_code", length = 32, columnDefinition = "varchar(32) COMMENT '品类编码'")
    private String productCategoryCode;
    /**
     * 品类名称
     */
    @ApiModelProperty("品类名称")
    @Column(name = "product_category_name", length = 255, columnDefinition = "varchar(255) COMMENT '品类名称'")
    private String productCategoryName;
    /**
     * 品项编码
     */
    @ApiModelProperty("品项编码")
    @Column(name = "product_item_code", length = 32, columnDefinition = "varchar(32) COMMENT '品项编码'")
    private String productItemCode;
    /**
     * 品项名称
     */
    @ApiModelProperty("品项名称")
    @Column(name = "product_item_name", length = 255, columnDefinition = "varchar(255) COMMENT '品项名称'")
    private String productItemName;
    /**
     * 产品编码
     */
    @ApiModelProperty("产品编码")
    @Column(name = "product_code", length = 32, columnDefinition = "varchar(32) COMMENT '产品编码'")
    private String productCode;
    /**
     * 产品名称
     */
    @ApiModelProperty("产品名称")
    @Column(name = "product_name", length = 255, columnDefinition = "varchar(255) COMMENT '产品名称'")
    private String productName;
    /**
     * 单位编码
     */
    @ApiModelProperty("单位编码")
    @Column(name = "product_unit", length = 32, columnDefinition = "varchar(32) COMMENT '单位编码'")
    private String productUnit;
    /**
     * 原品价格
     */
    @ApiModelProperty("原品价格")
    @Column(name = "product_price", length = 32, columnDefinition = "decimal(24,6) COMMENT '原品价格'")
    private BigDecimal productPrice;
    /**
     * 原品数量
     */
    @ApiModelProperty("原品数量")
    @Column(name = "product_quantity", length = 32, columnDefinition = "int(11) COMMENT '原品数量'")
    private Integer productQuantity;
    /**
     * 赠品编码
     */
    @ApiModelProperty("赠品编码")
    @Column(name = "gift_code", length = 32, columnDefinition = "varchar(32) COMMENT '单位编码'")
    private String giftCode;
    /**
     * 赠品名称
     */
    @ApiModelProperty("赠品名称")
    @Column(name = "gift_name", length = 255, columnDefinition = "varchar(255) COMMENT '赠品名称'")
    private String giftName;
    /**
     * 赠品价格
     */
    @ApiModelProperty("赠品价格")
    @Column(name = "gift_price", length = 32, columnDefinition = "decimal(24,6) COMMENT '赠品价格'")
    private BigDecimal giftPrice;
    /**
     * 赠品数量
     */
    @ApiModelProperty("赠品数量")
    @Column(name = "gift_quantity", length = 32, columnDefinition = "int(11) COMMENT '赠品数量'")
    private Integer giftQuantity;
    /**
     * 赠品总量
     */
    @ApiModelProperty("赠品总量")
    @Column(name = "gift_weight", length = 32, columnDefinition = "int(11) COMMENT '赠品总量'")
    private Integer giftWeight;
    /**
     * 促销政策编码
     */
    @ApiModelProperty("促销政策编码")
    @Column(name = "promotion_code", length = 32, columnDefinition = "varchar(32) COMMENT '促销政策编码'")
    private String promotionCode;
    /**
     * 促销政策名称
     */
    @ApiModelProperty("促销政策名称")
    @Column(name = "promotion_name", length = 255, columnDefinition = "varchar(255) COMMENT '促销政策名称'")
    private String promotionName;
    /**
     * 促销对象
     */
    @ApiModelProperty("促销对象")
    @Column(name = "promotion_object", length = 32, columnDefinition = "varchar(32) COMMENT '促销对象'")
    private String promotionObject;
    /**
     * 陈列类型
     */
    @ApiModelProperty("陈列类型")
    @Column(name = "display_type", length = 32, columnDefinition = "varchar(32) COMMENT '陈列类型'")
    private String displayType;
    /**
     * 单价
     */
    @ApiModelProperty("单价")
    @Column(name = "price", length = 32, columnDefinition = "varchar(32) COMMENT '陈列类型'")
    private BigDecimal price;


    @ApiModelProperty("陈列批次")
    @Column(name = "display_lot", columnDefinition = "VARCHAR(1) COMMENT '陈列批次'")
    private String displayLot;

    @ApiModelProperty("是否客户上账")
    @Column(name = "is_customer_account", columnDefinition = "VARCHAR(1) COMMENT '是否客户上账'")
    private String isCustomerAccount;

    /**
     * 费用金额
     */
    @ApiModelProperty("费用金额")
    @Column(name = "fee_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '费用金额'")
    private BigDecimal feeAmount;

    /**
     * 大区承担金额
     */
    @ApiModelProperty("大区承担金额")
    @Column(name = "department_fee_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '大区承担金额'")
    private BigDecimal departmentFeeAmount;
    /**
     * 客户承担金额
     */
    @ApiModelProperty("客户承担金额")
    @Column(name = "customer_fee_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '客户承担金额'")
    private BigDecimal customerFeeAmount;
    /**
     * 费用合计
     */
    @ApiModelProperty("费用合计")
    @Column(name = "total_fee_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '费用合计'")
    private BigDecimal totalFeeAmount;
    /**
     * 大区公投预算金额
     */
    @ApiModelProperty("大区公投预算金额（元）")
    @Column(name = "region_referendum_fee_amount", nullable = true, length = 24, columnDefinition = "decimal(24,6) COMMENT '大区公投预算金额（元）'")
    private BigDecimal regionReferendumFeeAmount;

    /**
     * 大区自投预算金额
     */
    @ApiModelProperty("大区自投预算金额（元）")
    @Column(name = "region_automatic_fee_amount", nullable = true, length = 24, columnDefinition = "decimal(24,6) COMMENT '大区自投预算金额（元）'")
    private BigDecimal regionAutomaticFeeAmount;

    /**
     * 门店预计月销售额
     */
    @ApiModelProperty("门店预计月销售额")
    @Column(name = "terminal_month_sales_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '门店预计月销售额'")
    private BigDecimal terminalMonthSalesAmount;
    /**
     * 上月门店实际月销售额
     */
    @ApiModelProperty("上月门店实际月销售额")
    @Column(name = "terminal_last_month_sales_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '上月门店实际月销售额'")
    private BigDecimal terminalLastMonthSalesAmount;
    /**
     * 扣款方式
     */
    @ApiModelProperty("扣款方式/是否扣款，   Y是N否")
    @Column(name = "deduct_type", length = 32, columnDefinition = "varchar(32) COMMENT '扣款方式'")
    private String deductType;
    /**
     * 结案形式
     */
    @ApiModelProperty("结案形式")
    @Column(name = "audit_form", length = 32, columnDefinition = "varchar(32) COMMENT '结案形式'")
    private String auditForm;
    /**
     * 付款方式
     */
    @ApiModelProperty("付款方式")
    @Column(name = "payment_method", length = 32, columnDefinition = "varchar(32) COMMENT '付款方式'")
    private String paymentMethod;
    /**
     * 竞品情况
     */
    @ApiModelProperty("竞品情况")
    @Column(name = "compatible_product_situation", length = 255, columnDefinition = "varchar(255) COMMENT '竞品情况'")
    private String compatibleProductSituation;
    /**
     * 是否和价格有关
     */
    @ApiModelProperty("是否和价格有关")
    @Column(name = "relate_to_price", length = 10, columnDefinition = "varchar(10) COMMENT '是否和价格有关'")
    private String relateToPrice;
    /**
     * 核销条件编码
     */
    @ApiModelProperty("核销条件编码")
    @Column(name = "audit_condition_code", length = 32, columnDefinition = "varchar(32) COMMENT '核销条件编码'")
    private String auditConditionCode;
    /**
     * 核销条件名称
     */
    @ApiModelProperty("核销条件名称")
    @Column(name = "audit_condition_name", length = 255, columnDefinition = "varchar(255) COMMENT '核销条件名称'")
    private String auditConditionName;
    /**
     * 活动描述
     */
    @ApiModelProperty("活动描述")
    @Column(name = "activity_desc", length = 255, columnDefinition = "varchar(1024) COMMENT '活动描述'")
    private String activityDesc;
    /**
     * 共用组
     */
    @ApiModelProperty("共用组")
    @Column(name = "common_group", length = 32, columnDefinition = "varchar(32) COMMENT '共用组'")
    private String commonGroup;
    /**
     * 物料编码
     */
    @ApiModelProperty("物料编码")
    @Column(name = "material_code", length = 32, columnDefinition = "varchar(32) COMMENT '物料编码'")
    private String materialCode;
    /**
     * 物料名称
     */
    @ApiModelProperty("物料名称")
    @Column(name = "material_name", length = 255, columnDefinition = "varchar(255) COMMENT '物料名称'")
    private String materialName;
    /**
     * 物料单位
     */
    @ApiModelProperty("物料单位")
    @Column(name = "material_unit", length = 32, columnDefinition = "varchar(32) COMMENT '物料单位'")
    private String materialUnit;
    /**
     * 物料单价
     */
    @ApiModelProperty("物料单价")
    @Column(name = "material_price", length = 24, columnDefinition = "decimal(24,6) COMMENT '物料单价'")
    private BigDecimal materialPrice;
    /**
     * 物料数量
     */
    @ApiModelProperty("物料数量")
    @Column(name = "material_quantity", length = 11, columnDefinition = "int(11) COMMENT '物料数量'")
    private BigDecimal materialQuantity;

    /**
     * 采购类型
     */
    @ApiModelProperty("采购类型")
    @Column(name = "procurement_type", length = 32, columnDefinition = "varchar(32) COMMENT '采购类型'")
    private String procurementType;
    /**
     * 合同编码
     */
    @ApiModelProperty("合同编码")
    @Column(name = "contract_code", length = 32, columnDefinition = "varchar(32) COMMENT '合同编码'")
    private String contractCode;
    /**
     * 账期
     */
    @ApiModelProperty("账期")
    @Column(name = "payment_days", length = 32, columnDefinition = "varchar(32) COMMENT '账期'")
    private String paymentDays;
    /**
     * 推广场次
     */
    @ApiModelProperty("推广场次")
    @Column(name = "promote_number", length = 11, columnDefinition = "int(11) COMMENT '推广场次'")
    private Integer promoteNumber;
    /**
     * 单场费用
     */
    @ApiModelProperty("单场费用")
    @Column(name = "single_fee_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '单场费用'")
    private BigDecimal singleFeeAmount;
    /**
     * 考核产品编码
     */
    @ApiModelProperty("考核产品编码")
    @Column(name = "assess_product_code", length = 32, columnDefinition = "varchar(32) COMMENT '考核产品编码'")
    private String assessProductCode;
    /**
     * 考核产品名称
     */
    @ApiModelProperty("考核产品名称")
    @Column(name = "assess_product_name", length = 255, columnDefinition = "varchar(255) COMMENT '考核产品名称'")
    private String assessProductName;
    /**
     * 购买方式
     */
    @ApiModelProperty("购买方式")
    @Column(name = "buy_way", length = 32, columnDefinition = "varchar(32) COMMENT '购买方式'")
    private String buyWay;

    /**
     * 结案周期
     */
    @ApiModelProperty("结案周期")
    @Column(name = "audit_cycle", length = 32, columnDefinition = "varchar(32) COMMENT '结案周期'")
    private String auditCycle;
    /**
     * 月销售任务
     */
    @ApiModelProperty("月销售任务")
    @Column(name = "month_sales_target", length = 24, columnDefinition = "decimal(24,6) COMMENT '月销售任务'")
    private BigDecimal monthSalesTarget;
    /**
     * 目前铺市率
     */
    @ApiModelProperty("目前铺市率")
    @Column(name = "current_market_rate", length = 24, columnDefinition = "decimal(24,6) COMMENT '目前铺市率'")
    private BigDecimal currentMarketRate;
    /**
     * 月目标铺市率
     */
    @ApiModelProperty("月目标铺市率")
    @Column(name = "month_target_market_rate", length = 24, columnDefinition = "decimal(24,6) COMMENT '月目标铺市率'")
    private BigDecimal monthTargetMarketRate;
    /**
     * 是否发起巡查需求
     */
    @ApiModelProperty("是否发起巡查需求")
    @Column(name = "is_start_patrol", length = 32, columnDefinition = "varchar(32) COMMENT '是否发起巡查需求'")
    private String isStartPatrol;
    /**
     * 期间促销量（件）
     */
    @ApiModelProperty("期间促销量（件）")
    @Column(name = "period_promote_quantity", length = 24, columnDefinition = "decimal(24,6) COMMENT '期间促销量（件）'")
    private BigDecimal periodPromoteQuantity;
    /**
     * 期间促销额（元）
     */
    @ApiModelProperty("期间促销额（元）")
    @Column(name = "period_promote_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '期间促销额（元）'")
    private BigDecimal periodPromoteAmount;
    /**
     * 期间渠道促销量（件）
     */
    @ApiModelProperty("期间渠道促销量（件）")
    @Column(name = "period_ch_promote_quantity", length = 24, columnDefinition = "decimal(24,6) COMMENT '期间渠道促销量（件）'")
    private BigDecimal periodChPromoteQuantity;
    /**
     * 期间渠道促销额（元）
     */
    @ApiModelProperty("期间渠道促销额（元）")
    @Column(name = "period_ch_promote_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '期间渠道促销额（元）'")
    private BigDecimal periodChPromoteAmount;
    /**
     * 全月回复量（件）
     */
    @ApiModelProperty("全月回复量（件）")
    @Column(name = "month_return_quantity", length = 24, columnDefinition = "decimal(24,6) COMMENT '全月回复量（件）'")
    private BigDecimal monthReturnQuantity;
    /**
     * 全月回复额（元）
     */
    @ApiModelProperty("全月回复额（元）")
    @Column(name = "month_return_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '全月回复额（元）'")
    private BigDecimal monthReturnAmount;
    /**
     * 本月投入产出比
     */
    @ApiModelProperty("本月投入产出比")
    @Column(name = "month_put_output_ratio", length = 24, columnDefinition = "decimal(24,6) COMMENT '本月投入产出比'")
    private BigDecimal monthPutOutputRatio;

    /**
     * 是否关闭，   Y是N否
     */
    @ApiModelProperty(name = "isClose", notes = "是否关闭", value = "是否关闭，   Y是N否")
    @Column(name = "is_close", length = 10, columnDefinition = "VARCHAR(10) COMMENT '是否关闭，   Y是N否'")
    private String isClose;
    /**
     * 已向下规划金额（分子公司活动规划用）
     */
    @ApiModelProperty(value = "已向下规划金额（分子公司活动规划用）", notes = "")
    @Column(name = "down_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '已向下规划金额（分子公司活动规划用） '")
    private BigDecimal downAmount;
    /**
     * 是否完全向下规划（分子公司活动规划用）
     */
    @ApiModelProperty("是否完全向下规划（分子公司活动规划用）")
    @Column(name = "is_all_down", length = 8, columnDefinition = "varchar(8) COMMENT '是否完全向下规划（分子公司活动规划用）'")
    private String isAllDown;

    @ApiModelProperty("完全结案日期")
    @Column(name = "whole_audit_date", length = 20, columnDefinition = "varchar(20) COMMENT '完全结案日期'")
    private String wholeAuditDate;
    /**
     * 是否完全结案
     */
    @ApiModelProperty("是否完全结案")
    @Column(name = "whole_audit", length = 10, columnDefinition = "VARCHAR(10) COMMENT '是否完全结案'")
    private String wholeAudit;
    /**
     * 已结案金额
     */
    @ApiModelProperty("已结案金额")
    @Column(name = "already_audit_amount", columnDefinition = "DECIMAL(24,6) COMMENT '已结案金额'")
    private BigDecimal alreadyAuditAmount;

    /**
     * 是否完全上账
     */
    @ApiModelProperty("是否完全上账")
    @Column(name = "whole_up_account", length = 1, columnDefinition = "CHAR(1) COMMENT '是否完全上账'")
    private String wholeUpAccount;

    /**
     * 已上账金额
     */
    @ApiModelProperty("已上账金额")
    @Column(name = "already_up_account_amount", columnDefinition = "DECIMAL(24,6) COMMENT '已上账金额'")
    private BigDecimal alreadyUpAccountAmount;

    /**
     * 分子公司点内金额
     */
    @ApiModelProperty("分子公司点内金额")
    @Column(name = "intra_company_amount", columnDefinition = "DECIMAL(24,6) COMMENT '分子公司点内金额'")
    private BigDecimal intraCompanyAmount;

    /**
     * 分子公司点外金额
     */
    @ApiModelProperty("分子公司点外金额")
    @Column(name = "off_point_amount", columnDefinition = "DECIMAL(24,6) COMMENT '分子公司点外金额'")
    private BigDecimal offPointAmount;

    /**
     * 费用所属年月
     */
    @ApiModelProperty("费用所属年月")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    @DateTimeFormat(pattern = "yyyy-MM")
    @Column(name = "fee_year_month", length = 20, columnDefinition = "datetime COMMENT '费用所属年月 '")
    private Date feeYearMonth;

    @ApiModelProperty("推送牛人管家状态标记")
    @Column(name = "cow_manager_state", length = 2, columnDefinition = "VARCHAR(2) COMMENT '推送牛人管家标记'")
    private String cowManagerState;

    @ApiModelProperty("推送Sap状态标记")
    @Column(name = "sap_interface_state", length = 2, columnDefinition = "VARCHAR(2) COMMENT '推送Sap状态标记'")
    private String sapInterfaceState;


    @ApiModelProperty("系统承担比例")
    @Column(name = "system_assume_ratio", columnDefinition = "DECIMAL(24,6) COMMENT '系统承担比例'")
    private BigDecimal systemAssumeRatio;

    @ApiModelProperty("我方承担比例")
    @Column(name = "our_assume_ratio", columnDefinition = "DECIMAL(24,6) COMMENT '我方承担比例'")
    private BigDecimal ourAssumeRatio;

    @ApiModelProperty("门店月计划量")
    @Column(name = "terminal_month_plan_quantity", columnDefinition = "DECIMAL(24,6) COMMENT '门店月计划量'")
    private BigDecimal terminalMonthPlanQuantity;

    @ApiModelProperty("门店共用量")
    @Column(name = "terminal_total_quantity", columnDefinition = "DECIMAL(24,6) COMMENT '门店共用量'")
    private BigDecimal terminalTotalQuantity;

    @ApiModelProperty("门店共用金额")
    @Column(name = "terminal_total_amount", columnDefinition = "DECIMAL(24,6) COMMENT '门店共用金额'")
    private BigDecimal terminalTotalAmount;

    @ApiModelProperty("陈列数量")
    @Column(name = "display_quantity", columnDefinition = "DECIMAL(24,6) COMMENT '陈列数量'")
    private BigDecimal displayQuantity;
    /**
     * 身份证号码
     */
    @ApiModelProperty("身份证号码")
    @Column(name = "person_id_card", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '身份证号码 '")
    private String personIdCard;
    /**
     * 人员类型
     */
    @ApiModelProperty("人员类型")
    @Column(name = "person_type", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '人员类型 '")
    private String personType;
    /**
     * 人员名称
     */
    @ApiModelProperty("人员名称")
    @Column(name = "person_name", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '人员名称 '")
    private String personName;
    /**
     * 人员编码
     */
    @ApiModelProperty("人员编码")
    @Column(name = "person_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '人员编码 '")
    private String personCode;

    /**
     * 促销类型
     */
    @ApiModelProperty("促销类型")
    @Column(name = "promotion_type", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '促销类型'")
    private String promotionType;

    @ApiModelProperty("分销渠道编码")
    @Column(name = "distribution_channel_code", length = 32, columnDefinition = "varchar(32) COMMENT '分销渠道编码'")
    private String distributionChannelCode;

    @ApiModelProperty("分销渠道名称")
    @Column(name = "distribution_channel_name", length = 32, columnDefinition = "varchar(32) COMMENT '分销渠道名称'")
    private String distributionChannelName;

    /**
     * 预估销售额
     */
    @ApiModelProperty("预估销售额")
    @Column(name = "sales_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '预估销售额'")
    private BigDecimal salesAmount;

    /**
     * 形式说明
     */
    @ApiModelProperty("形式说明")
    @CrmExcelColumn(value = "形式说明")
    @Column(name = "form_description", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '形式说明'")
    private String formDescription;

    /**
     * 是否涨价政策
     */
    @ApiModelProperty("是否涨价政策")
    @CrmExcelColumn(value = "是否涨价政策")
    @Column(name = "increase_price_promotion", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '是否涨价政策'")
    private String increasePricePromotion;

    /**
     * 是否责任利润调整
     */
    @ApiModelProperty("是否责任利润调整")
    @Column(name = "duty_profit_adjust", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '是否责任利润调整'")
    private String dutyProfitAdjust;

    /**
     * 新品归类
     */
    @ApiModelProperty("新品归类")
    @Column(name = "new_product_type", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '新品归类'")
    private String newProductType;

    /**
     * 是否占用划拨预算
     */
    @ApiModelProperty("是否占用划拨预算")
    @Column(name = "occupy_transfer_budget", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '是否占用划拨预算'")
    private String occupyTransferBudget;

    @ApiModelProperty("是否扣减费用池")
    @Column(name = "is_deduction_fee_pool", length = 255, columnDefinition = "varchar(16) COMMENT '是否扣减费用池'")
    private String isDeductionFeePool;

    /**
     * 核销类型
     */
    @ApiModelProperty("核销类型")
    @Column(name = "audit_type", length = 30, columnDefinition = "varchar(30) COMMENT '核销类型'")
    private String auditType;


    /**
     * 所属销售机构编码
     */
    @ApiModelProperty("所属销售机构编码")
    @Column(name = "sales_institution_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '所属销售机构编码'")
    private String salesInstitutionCode;

    /**
     * 所属销售机构编码
     */
    @ApiModelProperty("所属销售机构编码")
    @Column(name = "sales_institution_erp_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '所属销售机构编码'")
    private String salesInstitutionErpCode;

    /**
     * 所属销售机构
     */
    @ApiModelProperty("所属销售机构")
    @Column(name = "sales_institution_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '所属销售机构'")
    private String salesInstitutionName;

    @ApiModelProperty("所属销售大区编码")
    @Column(name = "sales_region_erp_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT ' 所属销售大区编码 '")
    private String salesRegionErpCode;

    @ApiModelProperty("所属销售大区编码")
    @Column(name = "sales_region_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT ' 所属销售大区编码 '")
    private String salesRegionCode;

    @ApiModelProperty("所属销售大区编码")
    @Column(name = "sales_region_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 所属销售大区编码 '")
    private String salesRegionName;

    @ApiModelProperty("所属销售组织(组)编码")
    @Column(name = "sales_org_erp_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '所属销售组织(组)编码'")
    private String salesOrgErpCode;

    @ApiModelProperty("所属销售组织(组)编码")
    @Column(name = "sales_org_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '所属销售组织(组)编码'")
    private String salesOrgCode;


    @ApiModelProperty("所属销售组织(组)名称")
    @Column(name = "sales_org_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '所属销售组织(组)名称'")
    private String salesOrgName;


    @ApiModelProperty("采购类型")
    @Column(name = "is_type_of_purchase_no", length = 40, columnDefinition = "varchar(40) COMMENT '采购类型'")
    private String isTypeOfPurchaseNo;

    @ApiModelProperty("申请金额")
    @Column(name = "apply_amount", precision = 24, scale = 6, columnDefinition = "decimal(24,6) COMMENT '申请金额(陈列方案用)'")
    private BigDecimal applyAmount;

    @ApiModelProperty("手续费点数")
    @Column(name = "commission_point", precision = 24, scale = 6, columnDefinition = "decimal(24,6) COMMENT '手续费点数(陈列方案用)'")
    private BigDecimal commissionPoint;

    @ApiModelProperty("手续费金额")
    @Column(name = "commission_amount", precision = 24, scale = 6, columnDefinition = "decimal(24,6) COMMENT '手续费金额(陈列方案用)'")
    private BigDecimal commissionAmount;

    /**
     * 档期开始日期
     */
    @ApiModelProperty("档期开始日期")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @Column(name = "schedule_begin_date", columnDefinition = "datetime COMMENT '档期开始日期'")
    private Date scheduleBeginDate;
    /**
     * 档期结束日期
     */
    @ApiModelProperty("档期结束日期")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @Column(name = "schedule_end_date", columnDefinition = "datetime COMMENT '档期结束日期'")
    private Date scheduleEndDate;
    @ApiModelProperty("活动场次")
    @Column(name = "activity_event_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '活动场次(行销方案模板用)'")
    private String activityEventCode;

    @ApiModelProperty("场次名称")
    @Column(name = "activity_event_name", length = 100, columnDefinition = "VARCHAR(100) COMMENT '场次名称(行销方案模板用)'")
    private String activityEventName;

    @ApiModelProperty("合同未税金额")
    @Column(name = "contract_excluding_tax", precision = 24, scale = 6, columnDefinition = "DECIMAL(24,6) COMMENT '合同未税金额'")
    private BigDecimal contractExcludingTax;

    @ApiModelProperty("合同含税金额")
    @Column(name = "contract_including_tax", precision = 24, scale = 6, columnDefinition = "DECIMAL(24,6) COMMENT '合同含税金额'")
    private BigDecimal contractIncludingTax;


    @ApiModelProperty(value = "* 随车搭赠组合")
    @Column(name = "car_gift_group", length = 32, columnDefinition = "VARCHAR(32) COMMENT '随车搭赠组合'")
    private String carGiftGroup;

    @Column(name = "face_value", length = 24, scale = 6, columnDefinition = "DECIMAL(24,6) COMMENT '面值'")
    private BigDecimal faceValue;

    @Column(name = "personal_income_tax", precision = 24, scale = 6, columnDefinition = "DECIMAL(24,6) COMMENT '个税金额（元）'")
    private BigDecimal personalIncomeTax;
    /**
     * 活动力度
     */
    @ApiModelProperty("活动力度")
    @Column(name = "activity_intensity", nullable = true, length = 255, columnDefinition = "varchar(255) COMMENT '活动力度'")
    private String activityIntensity;

    /**
     * 预估费率
     */
    @ApiModelProperty("预估费率")
    @Column(name = "fee_rate", length = 24, columnDefinition = "decimal(24,6) COMMENT '预估费率'")
    private BigDecimal feeRate;

    @ApiModelProperty("已结案总部承担金额")
    @Column(name = "already_end_case_head_fee_amount", columnDefinition = "decimal(24,6) COMMENT '已结案总部承担金额'")
    private BigDecimal alreadyEndCaseHeadFeeAmount;

    @ApiModelProperty("已结案大区承担金额")
    @Column(name = "already_end_case_department_fee_amount",  columnDefinition = "decimal(24,6) COMMENT '已结案大区承担金额'")
    private BigDecimal alreadyEndCaseDepartmentFeeAmount;

    @ApiModelProperty("已结案分子公司点内金额")
    @Column(name = "already_end_case_intra_company_amount", columnDefinition = "DECIMAL(24,6) COMMENT '已结案分子公司点内金额'")
    private BigDecimal alreadyEndCaseIntraCompanyAmount;

    @ApiModelProperty("已结案分子公司点外金额")
    @Column(name = "already_end_case_off_point_amount", columnDefinition = "DECIMAL(24,6) COMMENT '已结案分子公司点外金额'")
    private BigDecimal alreadyEndCaseOffPointAmount;
    /**
     * 关闭时间（预算回退定时任务执行时使用）
     */
    @ApiModelProperty("关闭时间（预算回退定时任务执行时使用）")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Column(name = "close_date", length = 20, columnDefinition = "datetime COMMENT '关闭时间（预算回退定时任务执行时使用） '")
    private Date closeDate;
    /**
     * 回退预算状态：1未回退预算，2未完全回退预算，3已完全回退预算
     */
    @ApiModelProperty(name = "rollbackBudgetTag", notes = "是否已回退预算", value = "回退预算状态：1未回退预算，2未完全回退预算，3已完全回退预算")
    @Column(name = "rollback_budget_tag", length = 10, columnDefinition = "VARCHAR(10) default '1' COMMENT '回退预算状态：1未回退预算，2未完全回退预算，3已完全回退预算'")
    private String rollbackBudgetTag;

    @ApiModelProperty("预算回退金额")
    @Column(name = "rollback_amount", columnDefinition = "DECIMAL(24,6) COMMENT '预算回退金额'")
    private BigDecimal rollbackAmount;

    /**
     * 承接类型编码 字典编码 accept_type
     */
    @ApiModelProperty("活动承接形式")
    @Column(name = "undertaking_mode", length = 32, columnDefinition = "VARCHAR(32) COMMENT '活动承接形式'")
    private String undertakingMode;

    @ApiModelProperty("搭赠类型")
    @Column(name = "bonus_type", nullable = true, length = 1, columnDefinition = "varchar(1) COMMENT '搭赠类型'")
    private String bonusType;

    /**
     * 调整前版本号
     */
    @ApiModelProperty("调整前变更编码")
    @Column(name = "curr_modify_business_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '调整前版本号'")
    private String currModifyBusinessCode;

    /**
     * 政策支持
     */
    @ApiModelProperty("政策支持")
    @Transient
    @TableField(exist = false)
    private String promotionSupport;
    /**
     * 活动方案明细编码
     */
    @ApiModelProperty("组合品编码")
    @Transient
    @TableField(exist = false)
    private String productCode2;
    /**
     * 组合品名称
     */
    @ApiModelProperty("组合品名称")
    @Transient
    @TableField(exist = false)
    private String productName2;

    /**
     * 备注
     */
    @Transient
    @TableField(exist = false)
    private String activityRemark;

    /**
     * 员工号
     */
    @ApiModelProperty(name = "employeeCode", notes = "员工号")
    @Transient
    @TableField(exist = false)
    private String employeeCode;

    @ApiModelProperty("关联上级方案，是否完全承接 前端使用")
    @Transient
    @TableField(exist = false)
    private String headMonthBudgetFullAccept;

    @ApiModelProperty("关联上级大区方案，是否完全承接 前端使用")
    @Transient
    @TableField(exist = false)
    private String monthBudgetFullAccept;

    @ApiModelProperty("是否自动核销")
    @Column(name = "auto_audit", length = 2, columnDefinition = "VARCHAR(2) COMMENT '是否自动核销 Y-是,N-否'")
    private String autoAudit;

    /**
     * 销售组织erp编码
     */
    @ApiModelProperty(name = "activityOrgErpCode", notes = "销售组织erp编码")
    @Transient
    @TableField(exist = false)
    private String activityOrgErpCode;

    @ApiModelProperty("核销审批状态")
    @Column(name = "audit_process_status", length = 10, columnDefinition = "VARCHAR(10) COMMENT '核销审批状态'")
    private String auditProcessStatus;

    /**
     * 外部系统活动细案编码
     */
    @ApiModelProperty("外部系统活动细案编码")
    @Transient
    @TableField(exist = false)
    private String foreignPlanCode;
    /**
     * 外部系统活动细案明细编码
     */
    @ApiModelProperty("外部系统活动细案明细编码")
    @Transient
    @TableField(exist = false)
    private String foreignPlanItemCode;

    /**
     * 集群/职能
     * */
    @ApiModelProperty("集群/职能")
    @Transient
    @TableField(exist = false)
    private String functioned;

    /**
     * 系统主管
     * */
    @ApiModelProperty("系统主管")
    @Transient
    @TableField(exist = false)
    private String systemSupervisor;

    /**
     * 省份
     * */
    @ApiModelProperty("省份")
    @Transient
    @TableField(exist = false)
    private String province;

    /**
     * 联系方式
     * */
    @ApiModelProperty("联系方式")
    @Transient
    @TableField(exist = false)
    private String contactInformation;

    /**
     * 卡片类型
     * */
    @ApiModelProperty("卡片类型")
    @Transient
    @TableField(exist = false)
    private String cardType;

    /**
     * 卡内提数
     * */
    @ApiModelProperty("卡内提数")
    @Transient
    @TableField(exist = false)
    private Integer carnegieNumber;

    /**
     * 姓名
     * */
    @ApiModelProperty("姓名")
    @Transient
    @TableField(exist = false)
    private String milkName;

    /**
     * 职位
     * */
    @ApiModelProperty("职位")
    @Transient
    @TableField(exist = false)
    private String position;


    /**
     * GMV（元）
     */
    @ApiModelProperty("GMV（元）")
    @Transient
    @TableField(exist = false)
    private BigDecimal gmv;

    @ApiModelProperty("区域细分编码")
    @Transient
    @TableField(exist = false)
    private String activityOrgSubdivisionCode;

    /**
     * 档期名称
     */
    @ApiModelProperty("档期名称")
    @Transient
    @TableField(exist = false)
    private String scheduleName;

    /**
     * 零售商渠道
     */
    @ApiModelProperty("零售商渠道")
    @Transient
    @TableField(exist = false)
    private String retailerChannel;

    /**
     * 是否大日期
     */
    @ApiModelProperty("是否大日期")
    @Transient
    @TableField(exist = false)
    private String isBigDate;

    /**
     * 大日期盘点数量
     */
    @ApiModelProperty("大日期盘点数量")
    @Transient
    @TableField(exist = false)
    private BigDecimal bigDateQty;

    /**
     * 大日期来源
     */
    @ApiModelProperty("大日期来源")
    @Transient
    @TableField(exist = false)
    private String bigDateSource;

    @ApiModelProperty("关联采购单")
    @Transient
    @TableField(exist = false)
    private String relatePurchaseOrder;

    @ApiModelProperty("是否关联物料采购单")
    @Transient
    @TableField(exist = false)
    private String isRelatePurchaseOrder;

    /**
     * 收货地址
     */
    @ApiModelProperty(name = "收货地址", notes = "收货地址")
    @Transient
    @TableField(exist = false)
    private String recipientAddress;

    /**
     * 收货联系人
     */
    @ApiModelProperty(name = "收货联系人", notes = "收货联系人")
    @Transient
    @TableField(exist = false)
    private String recipientContacts;

    /**
     * 收货联系电话
     */
    @ApiModelProperty(name = "收货联系电话", notes = "收货联系电话")
    @Transient
    @TableField(exist = false)
    private String recipientPhone;

}

