package com.biz.crm.tpm.business.activity.detail.plan.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * 活动细案明细扩展类
 * @author wanghaojia
 * @date 2023/3/5 23:52
 */
@ApiModel(value = "ActivityDetailPlanItemExtend", description = "活动细案明细扩展表")
@TableName("tpm_activity_detail_plan_item_extend")
@Getter
@Setter
@Entity(name = "tpm_activity_detail_plan_item_extend")
@org.hibernate.annotations.Table(appliesTo = "tpm_activity_detail_plan_item_extend", comment = "活动细案明细扩展表")
@Table(
        name = "tpm_activity_detail_plan_item_extend",
        indexes = {
                @Index(name = "activity_detail_plan_item_extend_inx1", columnList = "detail_plan_item_code,", unique = false),
                @Index(name = "activity_detail_plan_item_extend_inx2", columnList = "detail_plan_code,", unique = false)
        }
)
public class ActivityDetailPlanItemExtend extends TenantEntity {

    /**
     * 活动方案编码
     */
    @ApiModelProperty("活动细案编码")
    @Column(name = "detail_plan_code", length = 32, columnDefinition = "varchar(32) COMMENT '活动方案编码'")
    private String detailPlanCode;
    /**
     * 活动方案明细编码
     */
    @ApiModelProperty("活动细案明细编码")
    @Column(name = "detail_plan_item_code", length = 32, columnDefinition = "varchar(32) COMMENT '活动方案明细编码'")
    private String detailPlanItemCode;

    /**
     * 外部系统活动细案编码
     */
    @ApiModelProperty("外部系统活动细案编码")
    @Column(name = "foreign_plan_code", length = 32, columnDefinition = "varchar(32) COMMENT '外部系统活动细案编码'")
    private String foreignPlanCode;
    /**
     * 外部系统活动细案明细编码
     */
    @ApiModelProperty("外部系统活动细案明细编码")
    @Column(name = "foreign_plan_item_code", length = 32, columnDefinition = "varchar(32) COMMENT '外部系统活动细案明细编码'")
    private String foreignPlanItemCode;

    /**
     * 政策支持
     */
    @ApiModelProperty("政策支持")
    @Column(name = "promotion_support", length = 128, columnDefinition = "varchar(128) COMMENT '政策支持'")
    private String promotionSupport;
    /**
     * 活动方案明细编码
     */
    @ApiModelProperty("组合品编码")
    @Column(name = "product_code2", length = 32, columnDefinition = "varchar(32) COMMENT '活动方案明细编码'")
    private String productCode2;
    /**
     * 组合品名称
     */
    @ApiModelProperty("组合品名称")
    @Column(name = "product_name2", length = 255, columnDefinition = "varchar(255) COMMENT '活动方案明细编码'")
    private String productName2;

    /**
     * 备注
     */
    @Column(name = "activity_remark", length = 2000, columnDefinition = "varchar(2000) COMMENT '备注'")
    private String activityRemark;

    @ApiModelProperty(name = "employeeCode", notes = "员工号")
    @Column(name = "employee_code", columnDefinition = "varchar(64) COMMENT '员工号'")
    private String employeeCode;

    /**
     * 销售组织erp编码
     */
    @ApiModelProperty(name = "activityOrgErpCode", notes = "销售组织erp编码")
    @Column(name = "activity_org_erp_code", length = 32, columnDefinition = "varchar(32) COMMENT '销售组织erp编码'")
    private String activityOrgErpCode;

    /**
     * 集群/职能
     * */
    @ApiModelProperty("集群/职能")
    @Column(name = "functioned", length = 32,columnDefinition = "varchar(32) COMMENT '集群/职能'")
    private String functioned;

    /**
     * 系统主管
     * */
    @ApiModelProperty("系统主管")
    @Column(name = "system_supervisor", length = 32,columnDefinition = "varchar(32) COMMENT '系统主管'")
    private String systemSupervisor;

    /**
     * 省份
     * */
    @ApiModelProperty("省份")
    @Column(name = "province", length = 64,columnDefinition = "varchar(64) COMMENT '省份'")
    private String province;

    /**
     * 联系方式
     * */
    @ApiModelProperty("联系方式")
    @Column(name = "contact_information", length = 64,columnDefinition = "varchar(64) COMMENT '联系方式'")
    private String contactInformation;

    /**
     * 卡片类型
     * */
    @ApiModelProperty("卡片类型")
    @Column(name = "card_type", length = 32,columnDefinition = "varchar(32) COMMENT '卡片类型'")
    private String cardType;

    /**
     * 卡内提数
     * */
    @ApiModelProperty("卡内提数")
    @Column(name = "carnegie_number", length = 12,columnDefinition = "int(12) COMMENT '卡内提数'")
    private Integer carnegieNumber;

    /**
     * 姓名
     * */
    @ApiModelProperty("姓名")
    @Column(name = "milk_name", length = 32,columnDefinition = "varchar(32) COMMENT '姓名'")
    private String milkName;

    /**
     * 职位
     * */
    @ApiModelProperty("职位")
    @Column(name = "position", length = 32,columnDefinition = "varchar(32) COMMENT '职位'")
    private String position;

    /**
     * GMV（元）
     */
    @ApiModelProperty("GMV（元）")
    @Column(name = "gmv", length = 24, columnDefinition = "decimal(24,6) COMMENT 'GMV（元）'")
    private BigDecimal gmv;

    /**
     * 区域细分编码
     */
    @ApiModelProperty("区域细分编码")
    @Column(name = "activity_org_subdivision_code", length = 32, columnDefinition = "varchar(32) COMMENT '区域细分编码'")
    private String activityOrgSubdivisionCode;

    /**
     * 档期名称
     */
    @ApiModelProperty("档期名称")
    @Column(name = "schedule_name", length = 128, columnDefinition = "varchar(128) COMMENT 'schedule_name'")
    private String scheduleName;

    /**
     * 零售商渠道
     */
    @ApiModelProperty("零售商渠道")
    @Column(name = "retailer_channel", length = 64, columnDefinition = "varchar(64) COMMENT 'retailer_channel'")
    private String retailerChannel;

    /**
     * 是否大日期
     */
    @ApiModelProperty("是否大日期")
    @Column(name = "is_big_date", columnDefinition = "varchar(1) COMMENT '是否大日期'")
    private String isBigDate;

    /**
     * 大日期盘点数量
     */
    @ApiModelProperty("大日期盘点数量")
    @Column(name = "big_date_qty", length = 24, columnDefinition = "decimal(24,6) COMMENT '大日期盘点数量'")
    private BigDecimal bigDateQty;

    /**
     * 大日期来源
     */
    @ApiModelProperty("大日期来源")
    @Column(name = "big_date_source", length = 32,columnDefinition = "varchar(32) COMMENT '大日期来源'")
    private String bigDateSource;

    @ApiModelProperty("采购单审批状态")
    @Column(name = "purchase_order_process_status", length = 32,columnDefinition = "varchar(32) COMMENT '采购单审批状态'")
    private String purchaseOrderProcessStatus;

    @ApiModelProperty("关联采购单")
    @Column(name = "relate_purchase_order", length = 32,columnDefinition = "varchar(32) COMMENT '关联采购单'")
    private String relatePurchaseOrder;

    /**
     * 收货地址
     */
    @ApiModelProperty(name = "收货地址", notes = "收货地址")
    @Column(name = "recipient_address", length = 256, columnDefinition = "VARCHAR(256) COMMENT '收货地址'")
    private String recipientAddress;

    /**
     * 收货联系人
     */
    @ApiModelProperty(name = "收货联系人", notes = "收货联系人")
    @Column(name = "recipient_contacts", length = 64, columnDefinition = "VARCHAR(64) COMMENT '收货联系人'")
    private String recipientContacts;

    /**
     * 收货联系电话
     */
    @ApiModelProperty(name = "收货联系电话", notes = "收货联系电话")
    @Column(name = "recipient_phone", length = 32, columnDefinition = "VARCHAR(32) COMMENT '收货联系电话'")
    private String recipientPhone;
}
