package com.biz.crm.tpm.business.activity.detail.plan.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.mn.common.extend.field.entity.ExtendFieldEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 活动细案明细扩展字段
 * @author wanghaojia
 * @date 2023/3/5 23:52
 */
@ApiModel(value = "ActivityPlanItemExtendField", description = "活动细案明细扩展字段")
@TableName("tpm_activity_detail_plan_item_extend_field")
@Getter
@Setter
@Entity(name = "tpm_activity_detail_plan_item_extend_field")
@org.hibernate.annotations.Table(appliesTo = "tpm_activity_detail_plan_item_extend_field", comment = "活动细案明细扩展字段")
@Table(
        name = "tpm_activity_detail_plan_item_extend_field",
        indexes = {
                @Index(name = "activity_detail_plan_item_extend_field_inx1", columnList = "detail_plan_item_code,", unique = false),
                @Index(name = "activity_detail_plan_item_extend_field_inx2", columnList = "detail_plan_code,", unique = false)
        }
)
public class ActivityDetailPlanItemExtendField extends ExtendFieldEntity {

    /**
     * 活动方案编码
     */
    @ApiModelProperty("活动方案编码")
    @Column(name = "detail_plan_code", length = 255, columnDefinition = "varchar(255) COMMENT '活动方案编码'")
    private String detailPlanCode;
    /**
     * 活动方案明细编码
     */
    @ApiModelProperty("活动方案明细编码")
    @Column(name = "detail_plan_item_code", length = 255, columnDefinition = "varchar(255) COMMENT '活动方案明细编码'")
    private String detailPlanItemCode;

}
