package com.biz.crm.tpm.business.activity.detail.plan.local.entity;


import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * 活动细案明细表(ActivityDetailPlanItemTerminal)
 *
 * @author wanghaojia
 * @since 2022-11-12 15:14:12
 */
@ApiModel(value = "ActivityDetailPlanItemTerminal", description = "活动细案明细终端表")
@TableName("tpm_activity_detail_plan_item_terminal")
@Getter
@Setter
@Entity(name = "tpm_activity_detail_plan_item_terminal")
@org.hibernate.annotations.Table(appliesTo = "tpm_activity_detail_plan_item_terminal", comment = "活动细案明细终端表")
@Table(
    name = "tpm_activity_detail_plan_item_terminal",
    indexes = {
        @Index(name = "activity_detail_plan_item_terminal_inx0", columnList = "detail_plan_code", unique = false),
        @Index(name = "activity_detail_plan_item_terminal_inx1", columnList = "detail_plan_item_code,terminal_code", unique = false),
        @Index(name = "activity_detail_plan_item_terminal_inx2", columnList = "detail_plan_item_code", unique = false),
    }
)
public class ActivityDetailPlanItemTerminal extends TenantFlagOpEntity {

    /**
     * 活动细案名称
     */
    @ApiModelProperty("活动明细编码")
    @Column(name = "detail_plan_code", length = 32, columnDefinition = "varchar(32) COMMENT '活动明细编码'")
    private String detailPlanCode;

    /**
     * 活动细案名称
     */
    @ApiModelProperty("活动细案明细编码")
    @Column(name = "detail_plan_item_code", length = 32, columnDefinition = "varchar(32) COMMENT '活动细案明细编码'")
    private String detailPlanItemCode;

    /**
     * 门店编码
     */
    @ApiModelProperty("门店编码")
    @Column(name = "terminal_code", length = 32, columnDefinition = "varchar(32) COMMENT '门店编码'")
    private String terminalCode;

    /**
     * 门店名称
     */
    @ApiModelProperty("门店名称")
    @Column(name = "terminal_name", length = 255, columnDefinition = "varchar(255) COMMENT '门店名称'")
    private String terminalName;

    /**
     * 门店类型
     */
    @ApiModelProperty(name = "门店类型", notes = "门店类型")
    @Column(name = "terminal_type", length = 32, columnDefinition = "VARCHAR(32) COMMENT '门店类型'")
    private String terminalType;

    @ApiModelProperty("陈列数量")
    @Column(name = "display_quantity_str", length = 32, columnDefinition = "VARCHAR(32) COMMENT '陈列数量'")
    private String displayQuantityStr;

    @ApiModelProperty("陈列单价")
    @Column(name = "display_price_str", length = 32, columnDefinition = "VARCHAR(32) COMMENT '陈列单价'")
    private String displayPriceStr;

    /**
     * 门店预计月销售额
     */
    @ApiModelProperty("门店预计月销售额")
    @Column(name = "terminal_month_sales_amount_str", length = 32, columnDefinition = "VARCHAR(32) COMMENT '门店预计月销售额'")
    private String terminalMonthSalesAmountStr;

    /**
     * 身份证号码
     */
    @ApiModelProperty("身份证号码")
    @Column(name = "person_id_card", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '身份证号码 '")
    private String personIdCard;

    /**
     * 人员类型
     */
    @ApiModelProperty("人员类型")
    @Column(name = "person_type", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '人员类型 '")
    private String personType;

    /**
     * 人员名称
     */
    @ApiModelProperty("人员名称")
    @Column(name = "person_name", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '人员名称 '")
    private String personName;

    /**
     * 人员编码
     */
    @ApiModelProperty("人员编码")
    @Column(name = "person_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '人员编码 '")
    private String personCode;

    /**
     * 费用合计
     */
    @ApiModelProperty("费用合计")
    @Column(name = "total_fee_amount_str", length = 32, columnDefinition = "VARCHAR(32) COMMENT '费用合计'")
    private String totalFeeAmountStr;

    /**
     * 总部承担金额
     */
    @ApiModelProperty("总部承担金额")
    @Column(name = "head_fee_amount_str", length = 32, columnDefinition = "VARCHAR(32) COMMENT '总部承担金额'")
    private String headFeeAmountStr;

    /**
     * 大区承担金额
     */
    @ApiModelProperty("大区承担金额")
    @Column(name = "department_fee_amount_str", length = 32, columnDefinition = "VARCHAR(32) COMMENT '大区承担金额'")
    private String departmentFeeAmountStr;

    /**
     * 分子公司点内金额
     */
    @ApiModelProperty("分子公司点内金额")
    @Column(name = "intra_company_amount_str",length = 32,  columnDefinition = "VARCHAR(32) COMMENT '分子公司点内金额'")
    private String intraCompanyAmountStr;

    /**
     * 分子公司点外金额
     */
    @ApiModelProperty("分子公司点外金额")
    @Column(name = "off_point_amount_str",length = 32,  columnDefinition = "VARCHAR(32) COMMENT '分子公司点外金额'")
    private String offPointAmountStr;

    /**
     * 客户承担金额
     */
    @ApiModelProperty("客户承担金额")
    @Column(name = "customer_fee_amount_str", length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户承担金额'")
    private String customerFeeAmountStr;


    /**
     * 大区
     */
    @ApiModelProperty("大区")
    @Column(name = "sales_region_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '大区'")
    private String salesRegionCode;

    /**
     * 区域名称
     */
    @ApiModelProperty("省区")
    @Column(name = "sales_org_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '省区'")
    private String salesOrgCode;

    /**
     * 核销方式
     */
    @ApiModelProperty("核销方式")
    @Column(name = "audit_type", length = 30, columnDefinition = "VARCHAR(30) COMMENT '核销方式'")
    private String auditType;

    @ApiModelProperty("活动力度")
    @Column(name = "activity_intensity", length = 255, columnDefinition = "VARCHAR(255) COMMENT '活动力度'")
    private String activityIntensity;

}

