package com.biz.crm.tpm.business.activity.detail.plan.local.entity;


import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * 活动细案-关联活动方案表(ActivityDetailPlanPlan)
 *
 * @author wanghaojia
 * @since 2022-11-12 17:52:10
 */
@ApiModel(value = "ActivityDetailPlanPlan", description = "活动细案-关联活动方案表")
@TableName("tpm_activity_detail_plan_plan")
@Getter
@Setter
@Entity(name = "tpm_activity_detail_plan_plan")
@org.hibernate.annotations.Table(appliesTo = "tpm_activity_detail_plan_plan", comment = "活动细案-关联活动方案表")
@Table(
    name = "tpm_activity_detail_plan_plan",
    indexes = {
        @Index(name = "activity_dp_plan_inx1", columnList = "detail_plan_code,", unique = false)
    }
)
public class ActivityDetailPlanPlan extends TenantFlagOpEntity {

    /**
     * 活动细案编码
     */
    @ApiModelProperty("活动细案编码")
    @Column(name = "detail_plan_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '活动细案编码'")
    private String detailPlanCode;
    /**
     * 活动方案编码
     */
    @ApiModelProperty("活动方案编码")
    @Column(name = "plan_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '活动方案编码'")
    private String planCode;
    /**
     * 已申请金额
     */
    @ApiModelProperty("已申请金额")
    @Column(name = "used_amount", nullable = true, length = 24, columnDefinition = "decimal(24,6) COMMENT '已申请金额'")
    private BigDecimal usedAmount;
    /**
     * 本次使用方案金额
     */
    @ApiModelProperty("本次使用方案金额")
    @Column(name = "use_plan_amount", nullable = true, length = 24, columnDefinition = "decimal(24,6) COMMENT '本次使用方案金额'")
    private BigDecimal usePlanAmount;


}

