package com.biz.crm.tpm.business.activity.detail.plan.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * @author huojia
 * @date 2022年11月26日 10:16
 */
@ApiModel(value = "ActivityDetailPlanProductEntity", description = "TPM-活动细案产品分摊")
@TableName("tpm_activity_detail_plan_product")
@Getter
@Setter
@Entity(name = "tpm_activity_detail_plan_product")
@Table(name = "tpm_activity_detail_plan_product",
        indexes = {
                @Index(name = "activity_detail_plan_item_product_inx1", columnList = "detail_plan_item_code,", unique = false),
                @Index(name = "activity_detail_plan_item_product_inx2", columnList = "detail_plan_code,", unique = false)
        })
@org.hibernate.annotations.Table(appliesTo = "tpm_activity_detail_plan_product", comment = "TPM-活动细案产品分摊")
public class ActivityDetailPlanProduct extends TenantFlagOpEntity {

    /**
     * 活动细案编码
     */
    @ApiModelProperty("活动细案编码")
    @Column(name = "detail_plan_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '活动细案编码'")
    private String detailPlanCode;
    /**
     * 活动细案名称
     */
    @ApiModelProperty("活动细案明细编码")
    @Column(name = "detail_plan_item_code", nullable = true, length = 255, columnDefinition = "varchar(255) COMMENT '活动细案明细编码'")
    private String detailPlanItemCode;
    /**
     * 产品编码
     */
    @ApiModelProperty(value = "产品编码", notes = "")
    @Column(name = "product_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '产品编码 '")
    private String productCode;

    /**
     * 产品名称
     */
    @ApiModelProperty(value = "产品名称", notes = "")
    @Column(name = "product_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '产品名称 '")
    private String productName;

    /**
     * 产品比例
     */
    @ApiModelProperty(value = "产品比例", notes = "")
    @Column(name = "product_ratio", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '产品比例 '")
    private BigDecimal productRatio;

    /**
     * 单价优惠金额
     */
    @ApiModelProperty(value = "单价优惠金额", notes = "")
    @Column(name = "discount_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '单价优惠金额 '")
    private BigDecimal discountAmount;

    /**
     * 点外金额
     */
    @ApiModelProperty(value = "点外金额", notes = "")
    @Column(name = "off_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '点外金额 '")
    private BigDecimal offAmount;

    /**
     * 点内金额
     */
    @ApiModelProperty(value = "点内金额", notes = "")
    @Column(name = "internal_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '点内金额 '")
    private BigDecimal internalAmount;

    /**
     * 自投金额
     */
    @ApiModelProperty(value = "自投金额", notes = "")
    @Column(name = "auto_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '自投金额 '")
    private BigDecimal autoAmount;

    /**
     * 总金额
     */
    @ApiModelProperty(value = "总金额", notes = "")
    @Column(name = "total_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '总金额 '")
    private BigDecimal totalAmount;
}

