package com.biz.crm.tpm.business.activity.detail.plan.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * @CLASS_DESCRIBE: 业务单元套表-跑帆软
 * @AUTHOR: create by zkey on 2023-11-10
 */
@ApiModel(value = "BusinessUnitSetTable", description = "业务单元套表-跑帆软")
@TableName("tpm_business_unit_set_table")
@Getter
@Setter
@Entity(name = "tpm_business_unit_set_table")
@org.hibernate.annotations.Table(appliesTo = "tpm_business_unit_set_table", comment = "业务单元套表-跑帆软")
@Table(
        name = "tpm_business_unit_set_table",
        indexes = {
                @Index(name = "tpm_business_unit_set_table_inx1", columnList = "year_month_str"),
                @Index(name = "tpm_business_unit_set_table_inx2", columnList = "system_code"),
        }
)
public class BusinessUnitSetTable extends TenantOpEntity {

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(name = "业态[数据字典:mdm_business_format]", notes = "")
    @Column(name = "business_format_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '业态[数据字典:mdm_business_format]'")
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty(name = "业务单元[数据字典:mdm_business_unit]", notes = "")
    @Column(name = "business_unit_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '业务单元[数据字典:mdm_business_unit]'")
    private String businessUnitCode;
    @ApiModelProperty(value = "year_month_str", name = "年月", notes = "年月")
    @Column(name = "year_month_str", length = 10, columnDefinition = "VARCHAR(10) COMMENT '年月'")
    private String yearMonthStr;

    @ApiModelProperty(value = "last_year", name = "去年同期", notes = "上月")
    @Column(name = "last_year", length = 10, columnDefinition = "VARCHAR(10) COMMENT '去年同期'")
    private String lastYear;

    @ApiModelProperty("系统编码")
    @Column(name = "system_code", length = 32, columnDefinition = "varchar(32) COMMENT '系统编码'")
    private String systemCode;

    @ApiModelProperty("系统名称")
    @Column(name = "system_name", length = 200, columnDefinition = "varchar(200) COMMENT '系统名称'")
    private String systemName;

    @ApiModelProperty("当期-产品促销")
    @Column(name = "dqcpcx", columnDefinition = "decimal(30,6) COMMENT '当期-产品促销'")
    private BigDecimal dqcpcx;

    @ApiModelProperty("当期-陈列费")
    @Column(name = "dqclf", columnDefinition = "decimal(30,6) COMMENT '当期-陈列费'")
    private BigDecimal dqclf;

    @ApiModelProperty("当期-促销员费用")
    @Column(name = "dqcxyfy", columnDefinition = "decimal(30,6) COMMENT '当期-促销员费用'")
    private BigDecimal dqcxyfy;

    @ApiModelProperty("当期-合同内费用")
    @Column(name = "dqhtnfy", columnDefinition = "decimal(30,6) COMMENT '当期-合同内费用'")
    private BigDecimal dqhtnfy;

    @ApiModelProperty("当期-其他费用")
    @Column(name = "dqqtfy", columnDefinition = "decimal(30,6) COMMENT '当期-其他费用'")
    private BigDecimal dqqtfy;

    @ApiModelProperty("当期-行销费用")
    @Column(name = "dqxxfy", columnDefinition = "decimal(30,6) COMMENT '当期-行销费用'")
    private BigDecimal dqxxfy;

    @ApiModelProperty("当期-专项费用小计")
    @Column(name = "dqzxfyxj", columnDefinition = "decimal(30,6) COMMENT '当期-专项费用小计'")
    private BigDecimal dqzxfyxj;

    @ApiModelProperty("当期-专项费用率折后")
    @Column(name = "dqzxfylzh", columnDefinition = "decimal(30,6) COMMENT '当期-专项费用率折后'")
    private BigDecimal dqzxfylzh;

    @ApiModelProperty("当期-专项费用率pos")
    @Column(name = "dqzxfylpos", columnDefinition = "decimal(30,6) COMMENT '当期-专项费用率pos'")
    private BigDecimal dqzxfylpos;

    @ApiModelProperty("同期-产品促销")
    @Column(name = "tqcpcx", columnDefinition = "decimal(30,6) COMMENT '同期-产品促销'")
    private BigDecimal tqcpcx;

    @ApiModelProperty("同期-陈列费")
    @Column(name = "tqclf", columnDefinition = "decimal(30,6) COMMENT '同期-陈列费'")
    private BigDecimal tqclf;

    @ApiModelProperty("同期-促销员费用")
    @Column(name = "tqcxyfy", columnDefinition = "decimal(30,6) COMMENT '同期-促销员费用'")
    private BigDecimal tqcxyfy;

    @ApiModelProperty("同期-合同内费用")
    @Column(name = "tqhtnfy", columnDefinition = "decimal(30,6) COMMENT '同期-合同内费用'")
    private BigDecimal tqhtnfy;

    @ApiModelProperty("同期-其他费用")
    @Column(name = "tqqtfy", columnDefinition = "decimal(30,6) COMMENT '同期-其他费用'")
    private BigDecimal tqqtfy;

    @ApiModelProperty("同期-行销费用")
    @Column(name = "tqxxfy", columnDefinition = "decimal(30,6) COMMENT '同期-行销费用'")
    private BigDecimal tqxxfy;

    @ApiModelProperty("同期-专项费用小计")
    @Column(name = "tqzxfyxj", columnDefinition = "decimal(30,6) COMMENT '同期-专项费用小计'")
    private BigDecimal tqzxfyxj;

    @ApiModelProperty("同期-专项费用率折后")
    @Column(name = "tqzxfylzh", columnDefinition = "decimal(30,6) COMMENT '同期-专项费用率折后'")
    private BigDecimal tqzxfylzh;

    @ApiModelProperty("同期-专项费用率pos")
    @Column(name = "tqzxfylpos", columnDefinition = "decimal(30,6) COMMENT '同期-专项费用率pos'")
    private BigDecimal tqzxfylpos;
}
