package com.biz.crm.tpm.business.activity.detail.plan.local.entity;

import com.biz.crm.business.common.local.entity.UuidEntity;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;

/**
 * 免费货物接口回调
 * @author wanghaojia
 * @date 2023/3/2 20:18
 */
//@TableName("tpm_free_goods_mapping")
@Getter
@Setter
//@Entity(name = "tpm_free_goods_mapping")
//@Table(name = "tpm_free_goods_mapping",
//        indexes = {
//                @Index(name = "free_goods_mapping_inx0", columnList = "detail_plan_code", unique = false),
//                @Index(name = "free_goods_mapping_inx1", columnList = "detail_plan_item_code,", unique = false),
//                @Index(name = "free_goods_mapping_inx2", columnList = "message_id,", unique = false)
//        })
//@org.hibernate.annotations.Table(appliesTo = "tpm_free_goods_mapping", comment = "TPM-活动细案产品分摊")
public class FreeGoodsMapping extends UuidEntity {

    /**
     * 细案明细编码
     */
    @Column(name = "detail_plan_code", nullable = false, length = 32, columnDefinition = "varchar(32) COMMENT '细案明细编码'")
    private String detailPlanCode;
    /**
     * 细案明细编码
     */
    @Column(name = "detail_plan_item_code", nullable = false, length = 32, columnDefinition = "varchar(32) COMMENT '细案明细编码'")
    private String detailPlanItemCode;

    /**
     * 传给SAP的消息id
     */
    @Column(name = "message_id", nullable = false, length = 32, columnDefinition = "varchar(32) COMMENT '传给SAP的消息id'")
    private String messageId;

    /**
     * 传给SAP的流水号
     */
    @Column(name = "cond_no", nullable = false, length = 32, columnDefinition = "varchar(32) COMMENT '传给SAP的流水号'")
    private String condNo;

    /**
     * SAP返回的记录号
     */
    @Column(name = "cond_no_new", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT 'SAP返回的记录号'")
    private String condNoNew;

}
