package com.biz.crm.tpm.business.activity.detail.plan.local.event;

import com.biz.crm.tpm.business.activity.detail.plan.local.repository.ActivityDetailPlanBudgetRepository;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.ActivityDetailPlanService;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanQueryActivityDetailPlanDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanQueryActivityDetailPlanResponse;
import com.biz.crm.tpm.business.activity.plan.sdk.listener.ActivityPlanQueryActivityDetailPlanListener;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityDetailPlanPlanVo;
import com.bizunited.nebula.mars.sdk.context.MarsAuthorityContextHolder;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * x
 *
 * @author wanghaojia
 * @date 2023/8/2 14:43
 */
@Slf4j
@Component
public class ActivityPlanQueryActivityDetailPlanListenerImpl implements ActivityPlanQueryActivityDetailPlanListener {

    @Autowired(required = false)
    private ActivityDetailPlanBudgetRepository activityDetailPlanBudgetRepository;

    @Autowired(required = false)
    private ActivityDetailPlanService activityDetailPlanService;

    /**
     * 根据细案编码查询关联的方案编码
     */
    @Override
    public ActivityPlanQueryActivityDetailPlanResponse detailPlanRelatePlanCodeList(ActivityPlanQueryActivityDetailPlanDto eventDto) {
        ActivityPlanQueryActivityDetailPlanResponse response = new ActivityPlanQueryActivityDetailPlanResponse();
        if (CollectionUtils.isEmpty(eventDto.getDetailPlanCodeList())) {
            return response;
        }
        MarsAuthorityContextHolder.clearContext();
        List<String> planCodeList = activityDetailPlanBudgetRepository.detailPlanRelatePlanCodeList(Sets.newHashSet(eventDto.getDetailPlanCodeList()));
        response.setPlanCodeList(planCodeList);
        return response;
    }

    @Override
    public ActivityPlanQueryActivityDetailPlanResponse hasRelateDetailPlanCodeList(ActivityPlanQueryActivityDetailPlanDto eventDto) {
        ActivityPlanQueryActivityDetailPlanResponse response = new ActivityPlanQueryActivityDetailPlanResponse();
        if (CollectionUtils.isEmpty(eventDto.getPlanItemCodeList())) {
            return response;
        }
        List<String> planItemCodeList = activityDetailPlanBudgetRepository.hasRelateDetailPlanCodeList(Sets.newHashSet(eventDto.getPlanItemCodeList()));
        response.setPlanItemCodeList(planItemCodeList);
        return response;
    }

    @Override
    public ActivityPlanQueryActivityDetailPlanResponse getDetailPlanInfoByPlanItemCodeList(ActivityPlanQueryActivityDetailPlanDto eventDto) {
        ActivityPlanQueryActivityDetailPlanResponse response = new ActivityPlanQueryActivityDetailPlanResponse();
        if (CollectionUtils.isEmpty(eventDto.getPlanItemCodeList())) {
            return response;
        }
        List<ActivityDetailPlanPlanVo> detailPlanVoList = activityDetailPlanService.getDetailPlanInfoByPlanItemCodeList(eventDto.getPlanItemCodeList());
        response.setPlanPlanVoList(detailPlanVoList);
        return response;
    }
}
