package com.biz.crm.tpm.business.activity.detail.plan.local.event;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mn.third.system.fxiaoke.sdk.dto.FXiaoKeRequestData;
import com.biz.crm.mn.third.system.fxiaoke.sdk.dto.FXiaoKeSearchQueryFilter;
import com.biz.crm.mn.third.system.fxiaoke.sdk.dto.FXiaoKeSearchQueryInfo;
import com.biz.crm.mn.third.system.fxiaoke.sdk.service.FXiaoKeService;
import com.biz.crm.mn.third.system.fxiaoke.sdk.vo.FXiaoKeQueryResult;
import com.biz.crm.mn.third.system.fxiaoke.sdk.vo.FXiaoKeResult;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.foreign.ForeignActivityDetailPlanEventDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ForeignActivityDetailPlanEvent;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 外部系统调用TPM接口生成细案回调-纷享销客
 *
 * @author wanghaojia
 * @date 2024/1/9 17:04
 */
@Slf4j
@Service
public class FXiaoKeForeignActivityDetailPlanEvent implements ForeignActivityDetailPlanEvent {

    @Autowired(required = false)
    private FXiaoKeService fXiaoKeService;

    @Override
    public void createFinish(ForeignActivityDetailPlanEventDto event) {
        try {
            //不要影响其他接口
            callBackFXiaoKe(event);
        } catch (Exception e) {
            log.error("自动创建细案回调失败-纷享销客" + e.getMessage());
        }
    }

    private void callBackFXiaoKe(ForeignActivityDetailPlanEventDto event) {
        Result<ActivityDetailPlanDto> eventResult = event.getResult();
        ActivityDetailPlanDto detailPlanDto = eventResult.getResult();

        //查id
        FXiaoKeSearchQueryInfo fXiaoKeSearchQueryInfo = new FXiaoKeSearchQueryInfo();
        fXiaoKeSearchQueryInfo.setFieldProjection(Lists.newArrayList("_id"));
        fXiaoKeSearchQueryInfo.setOffset(0);
        fXiaoKeSearchQueryInfo.setLimit(1);

        FXiaoKeSearchQueryFilter fXiaoKeSearchQueryFilter = new FXiaoKeSearchQueryFilter();
        fXiaoKeSearchQueryFilter.setOperator("EQ");
        fXiaoKeSearchQueryFilter.setFieldName("name");
        fXiaoKeSearchQueryFilter.setFieldValues(detailPlanDto.getForeignPlanCode());
        fXiaoKeSearchQueryInfo.setFilters(Lists.newArrayList(fXiaoKeSearchQueryFilter));
        Result<FXiaoKeQueryResult> fXiaoKeDetailPlanQueryResult = fXiaoKeService.queryData("object_a682y__c",fXiaoKeSearchQueryInfo);
        if (!fXiaoKeDetailPlanQueryResult.isSuccess()) {
            throw new RuntimeException(fXiaoKeDetailPlanQueryResult.getMessage());
        }
        List<JSONObject> dataList = fXiaoKeDetailPlanQueryResult.getResult().getData().getDataList();
        if (CollectionUtils.isEmpty(dataList)) {
            //不是纷享销客的数据
            return;
//            throw new RuntimeException("纷享销客细案[" + detailPlanDto.getForeignPlanCode() + "]查询失败");
        }
        String fXiaoKeDetailPlanId = dataList.get(0).getString("_id");


        JSONObject objectData = new JSONObject();
        objectData.put("dataObjectApiName", "object_a682y__c");
        objectData.put("_id", fXiaoKeDetailPlanId);
        objectData.put("sync_status__c", eventResult.isSuccess() ? "1" : "2");
        objectData.put("field_2Pye9__c", detailPlanDto.getDetailPlanCode());
        //失败原因
        objectData.put("field_RcfCb__c", eventResult.isSuccess() ? "" : eventResult.getMessage());
        List<JSONObject> detailItems = Lists.newArrayList();
        if (eventResult.isSuccess() && !CollectionUtils.isEmpty(detailPlanDto.getItemList())) {
            //创建成功并且有明细才查明细编码
            List<String> detailPlanItemForeignCodeList = detailPlanDto.getItemList().stream().map(ActivityDetailPlanItemDto::getForeignPlanItemCode).collect(Collectors.toList());

            //查id
            fXiaoKeSearchQueryInfo = new FXiaoKeSearchQueryInfo();
            fXiaoKeSearchQueryInfo.setFieldProjection(Lists.newArrayList("_id", "name"));
            fXiaoKeSearchQueryInfo.setOffset(0);
            fXiaoKeSearchQueryInfo.setLimit(detailPlanItemForeignCodeList.size());

            fXiaoKeSearchQueryFilter = new FXiaoKeSearchQueryFilter();
            fXiaoKeSearchQueryFilter.setOperator("IN");
            fXiaoKeSearchQueryFilter.setFieldName("name");
            fXiaoKeSearchQueryFilter.setFieldValues(detailPlanItemForeignCodeList);
            fXiaoKeSearchQueryInfo.setFilters(Lists.newArrayList(fXiaoKeSearchQueryFilter));
            fXiaoKeDetailPlanQueryResult = fXiaoKeService.queryData("object_DAx8Q__c",fXiaoKeSearchQueryInfo);
            if (!fXiaoKeDetailPlanQueryResult.isSuccess()) {
                throw new RuntimeException(fXiaoKeDetailPlanQueryResult.getMessage());
            }
            dataList = fXiaoKeDetailPlanQueryResult.getResult().getData().getDataList();
            if (CollectionUtils.isEmpty(dataList)) {
                //细案都查到了这里不应该查不到
                throw new RuntimeException("纷享销客细案[" + detailPlanDto.getForeignPlanCode() + "]明细查询失败");
            }
            Map<String, String> fXiaoKeItemCodeMap = dataList.stream().collect(Collectors.toMap(item -> item.getString("name"), item -> item.getString("_id")));
            for (ActivityDetailPlanItemDto activityDetailPlanItemDto : detailPlanDto.getItemList()) {
                String fXiaoKeItemId = fXiaoKeItemCodeMap.get(activityDetailPlanItemDto.getForeignPlanItemCode());
                JSONObject detailItemObject = new JSONObject();
                detailItemObject.put("_id",fXiaoKeItemId);
                detailItemObject.put("field_82dK6__c",activityDetailPlanItemDto.getDetailPlanItemCode());
                detailItems.add(detailItemObject);
            }
        }
        FXiaoKeRequestData fXiaoKeRequestData = new FXiaoKeRequestData();
        fXiaoKeRequestData.setObjectData(objectData);
        if (!CollectionUtils.isEmpty(detailItems)){
            JSONObject details = new JSONObject();
            details.put("object_DAx8Q__c",detailItems);
            fXiaoKeRequestData.setDetails(details);
        }
        Result<FXiaoKeResult> fXiaoKeUpdateResult = fXiaoKeService.updateData(fXiaoKeRequestData);
        if (!fXiaoKeUpdateResult.isSuccess()) {
            throw new RuntimeException(fXiaoKeUpdateResult.getMessage());
        }

    }

}
