package com.biz.crm.tpm.business.activity.detail.plan.local.exports;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.page.cache.constant.MnPageCacheConstant;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.ActivityDetailPlanItemService;
import com.biz.crm.tpm.business.activity.detail.plan.local.vo.ActivityDetailPlanItemExportsVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.constant.ActivityDetailPlanConstant;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.activity.plan.sdk.constant.ActivityPlanConstant;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;

/**
 * @author: chenlong
 * @date: 2023/2/7 16:49
 * @description: 活动细案明细导出
 */
@Slf4j
@Component
public class ActivityDetailPlanItemExportsProcess implements ExportProcess<ActivityDetailPlanItemExportsVo> {
    @Autowired(required = false)
    private ActivityDetailPlanItemService activityDetailPlanItemService;
    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required = false)
    private DictToolkitService dictToolkitService;

    @Override
    public Integer getPageSize(){
        return CommonConstant.IE_EXPORT_PAGE_SIZE;
    }


    @Override
    public Integer getTotal(Map<String, Object> params) {
        Validate.notNull(params.get("cacheKey"), "缓存键，参数未传入");
        Integer total = activityDetailPlanItemService.getTotal((String) params.get("cacheKey"));
        Validate.isTrue(total < CommonConstant.IE_EXPORT_MAX_TOTAL, "导出时，" +
                "单次最大导出[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]条,请输入更多查询条件!!");
        return total;
    }

    @Override
    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        Validate.notNull(params.get("cacheKey"), "缓存键，参数未传入");
        String cacheKey = (String) params.get("cacheKey");
        Pageable pageable = PageRequest.of(vo.getPageNo() + 1, this.getPageSize());
        ActivityDetailPlanItemDto dto = new ActivityDetailPlanItemDto();
        Page<ActivityDetailPlanItemVo> cachePage = activityDetailPlanItemService.findCachePageList(pageable, dto, cacheKey);
        if (cachePage.getTotal() == 0) {
            return new JSONArray();
        }
        Collection<ActivityDetailPlanItemExportsVo> exportsVos = nebulaToolkitService.copyCollectionByWhiteList(
                cachePage.getRecords(), ActivityDetailPlanItemVo.class, ActivityDetailPlanItemExportsVo.class, LinkedHashSet.class, ArrayList.class);
        //调整
        adjustData(exportsVos);
        return JSON.parseArray(JSON.toJSONString(exportsVos));
    }

    @Override
    public String getBusinessCode() {
        return "TPM_ACTIVITY_DETAIL_PLAN_ITEM_EXPORT";
    }

    @Override
    public String getBusinessName() {
        return "活动细案明细导出";
    }

    /**
     * 调整数据
     *
     * @param data
     */
    private void adjustData(Collection<ActivityDetailPlanItemExportsVo> data) {
        Map<String, String> poMap = dictToolkitService.findMapByDictTypeCode(ActivityDetailPlanConstant.DICT_TPM_PROMOTION_OBJECT);
        Map<String, String> atMap = dictToolkitService.findMapByDictTypeCode(ActivityDetailPlanConstant.DICT_TPM_AUDIT_TYPE);
        Map<String, String> ynMap = dictToolkitService.findMapByDictTypeCode(ActivityDetailPlanConstant.DICT_YESORNO);

        for (ActivityDetailPlanItemExportsVo vo : data) {
            if (null != vo.getActivityBeginDate()) {
                vo.setActivityBeginDateStr(DateUtil.dateToStr(DateUtil.date_yyyy_MM_dd, vo.getActivityBeginDate()));
            }
            if (null != vo.getActivityEndDate()) {
                vo.setActivityEndDateStr(DateUtil.dateToStr(DateUtil.date_yyyy_MM_dd, vo.getActivityEndDate()));
            }
            if (null != vo.getOrderBeginDate()) {
                vo.setOrderBeginDateStr(DateUtil.dateToStr(DateUtil.date_yyyy_MM_dd, vo.getOrderBeginDate()));
            }
            if (null != vo.getOrderEndDate()) {
                vo.setOrderEndDateStr(DateUtil.dateToStr(DateUtil.date_yyyy_MM_dd, vo.getOrderEndDate()));
            }
            if (StringUtils.isNotBlank(vo.getPromotionObject())) {
                vo.setPromotionObject(poMap.getOrDefault(vo.getPromotionObject(), vo.getPromotionObject()));
            }
            if (StringUtils.isNotBlank(vo.getAuditType())) {
                vo.setAuditType(atMap.getOrDefault(vo.getAuditType(), vo.getAuditType()));
            }
            if (StringUtils.isNotBlank(vo.getIsStartPatrol())) {
                vo.setIsStartPatrol(ynMap.getOrDefault(vo.getIsStartPatrol(), vo.getIsStartPatrol()));
            }
            if (StringUtils.isNotBlank(vo.getRelateToPrice())) {
                vo.setRelateToPrice(ynMap.getOrDefault(vo.getRelateToPrice(), vo.getRelateToPrice()));
            }
            if (StringUtils.isNotBlank(vo.getIncreasePricePromotion())) {
                vo.setIncreasePricePromotion(ynMap.getOrDefault(vo.getIncreasePricePromotion(), vo.getIncreasePricePromotion()));
            }
            if (StringUtils.isNotBlank(vo.getDeductType())) {
                vo.setDeductType(ynMap.getOrDefault(vo.getDeductType(), vo.getDeductType()));
            }
            if (StringUtils.isNotBlank(vo.getDutyProfitAdjust())) {
                vo.setDutyProfitAdjust(ynMap.getOrDefault(vo.getDutyProfitAdjust(), vo.getDutyProfitAdjust()));
            }
            if (StringUtils.isNotBlank(vo.getOccupyTransferBudget())) {
                vo.setOccupyTransferBudget(ynMap.getOrDefault(vo.getOccupyTransferBudget(), vo.getOccupyTransferBudget()));
            }


        }
    }

    /**
     * 获取对象转换实体
     *
     * @return
     */
    @Override
    public Class<ActivityDetailPlanItemExportsVo> findCrmExcelVoClass() {
        return ActivityDetailPlanItemExportsVo.class;
    }
}
