package com.biz.crm.tpm.business.activity.detail.plan.local.exports;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.excel.util.EuropaParamsTools;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.mn.common.base.eunm.BusinessFormatEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.ActivityDetailPlanItemService;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.ActivityDetailPlanItemTerminalService;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.ActivityDetailPlanService;
import com.biz.crm.tpm.business.activity.detail.plan.local.vo.ActivityDetailPlanItemsExportsVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.constant.ActivityDetailPlanConstant;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.europa.database.sdk.context.execute.DatabaseExecuteExternalRequest;
import com.bizunited.nebula.europa.sdk.context.execute.RequestParameter;
import com.bizunited.nebula.europa.sdk.service.EuropaInfoVoService;
import com.bizunited.nebula.europa.sdk.service.ExecutionService;
import com.bizunited.nebula.europa.sdk.service.strategy.ExecutionStrategy;
import com.bizunited.nebula.europa.sdk.vo.EuropaInfoVo;
import com.bizunited.nebula.europa.sdk.vo.ExecutionInfo;
import com.bizunited.nebula.mars.sdk.context.MarsAuthorityContext;
import com.bizunited.nebula.mars.sdk.context.MarsAuthorityContextHolder;
import com.google.common.collect.Lists;
import jodd.util.StringUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author baokai
 * @date 2023/7/19 11:55
 */
@Component
@Slf4j
public class ActivityDetailPlanItemsExportProcess implements ExportProcess<ActivityDetailPlanItemsExportsVo> {

    @Autowired(required = false)
    private ActivityDetailPlanItemService activityDetailPlanItemService;

    @Autowired(required = false)
    private OrgVoService orgVoService;

    @Autowired(required = false)
    private EuropaInfoVoService europaInfoVoService;

    @Autowired
    private List<ExecutionStrategy> executionStrategies;

    @Autowired(required = false)
    private ExecutionService executionService;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private DictToolkitService dictToolkitService;

    @Autowired(required = false)
    private RedisService redisService;

    private static final String ACTIVITY_PLAN_ITEM_EXPORT_KEY = "activity_plan:item_export:";

    @Override
    public Integer getPageSize(){
        return CommonConstant.IE_EXPORT_PAGE_SIZE;
    }

    @Override
    public Integer getTotal(Map<String, Object> params) {
        // 获取查询数据记录条数
        List<String> detailPlanCodeList = getPlanCodeList( params);
        if (CollectionUtils.isEmpty(detailPlanCodeList)){
            throw new RuntimeException("未查询到数据无需执行导出！");
        }
        //查方案的时候已经做了数据权限了，这里就不做了
        MarsAuthorityContextHolder.clearContext();
        Pageable pageable = PageRequest.of(1, 1);
        Page<ActivityDetailPlanItemsExportsVo> exportsVoPage = this.activityDetailPlanItemService.findExportListByDetailPlanCodes(pageable,detailPlanCodeList);
        long maxCount = exportsVoPage.getTotal();
        Validate.isTrue(maxCount <= CommonConstant.IE_EXPORT_MAX_TOTAL, "执行数据视图导出时，" +
                "单次最大导出[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]条,请输入更多查询条件!!");
        return Long.valueOf(maxCount).intValue();
    }
    
    private List<String> getPlanCodeList(Map<String, Object> params){
        String europaInfoCode = "" + params.get(EuropaParamsTools.EUROPA_CODE_PARAMETER_NAME);
        Validate.notBlank(europaInfoCode, "执行数据视图时，未传入对应的欧罗巴数据视图业务编号!!");
        String tenantCode = TenantUtils.getTenantCode();
        EuropaInfoVo europaInfoVo = this.europaInfoVoService.findByTenantCodeAndCode(tenantCode, europaInfoCode);
        Validate.notNull(europaInfoVo, "执行数据视图时，未找到指定的欧罗巴数据视图基本信息，请检查!!");
        // 获取查询数据记录条数
        // 已正确匹配的执行策略
        ExecutionStrategy matchedExecutionStrategy = this.getMatchedExecution(europaInfoVo);

        PageRequest pageRequest = PageRequest.of(0, 999999);
        RequestParameter requestParameter = this.buildRequestParameter(pageRequest, europaInfoCode, params);
        ExecutionInfo execution = this.executionService.execution(europaInfoVo, pageRequest, requestParameter, matchedExecutionStrategy);
        List<Map<String, Object>> results = execution.getExecuteContent().getResults();
        return  results.stream().map(item -> String.valueOf(item.get("detail_plan_code"))).collect(Collectors.toList());
    }

    @Override
    @Transactional(readOnly = true)
    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        List<String> detailPlanCodes = getPlanCodeList(params);
        //查方案的时候已经做了数据权限了，这里就不做了
        MarsAuthorityContextHolder.clearContext();
        Pageable pageable = PageRequest.of(vo.getPageNo()+1, this.getPageSize());
        Page<ActivityDetailPlanItemsExportsVo> exportsVoListPage = this.activityDetailPlanItemService.findExportListByDetailPlanCodes(pageable,detailPlanCodes);
        //添加归属部门
        List<ActivityDetailPlanItemsExportsVo> exportsVoList = exportsVoListPage.getRecords();
        List<String> orgCodeList = exportsVoList.stream().filter(Objects::nonNull).map(ActivityDetailPlanItemsExportsVo::getDepartmentCode).filter(Objects::nonNull)
                .flatMap(item -> Arrays.stream(item.split(",")))
                .distinct().collect(Collectors.toList());
        setParentOrg:{
            if (org.springframework.util.CollectionUtils.isEmpty(orgCodeList)){
                break setParentOrg;
            }
            List<OrgVo> orgVos = orgVoService.findByOrgCodes(orgCodeList);
            if (org.springframework.util.CollectionUtils.isEmpty(orgVos)){
                break setParentOrg;
            }
            List<String> parentOrgCodeList = orgVos.stream().map(OrgVo::getParentCode).distinct().collect(Collectors.toList());
            if (org.springframework.util.CollectionUtils.isEmpty(parentOrgCodeList)){
                break setParentOrg;
            }
            List<OrgVo> parentOrgVos = orgVoService.findByOrgCodes(parentOrgCodeList);
            if (org.springframework.util.CollectionUtils.isEmpty(parentOrgVos)){
                break setParentOrg;
            }
            Map<String, String> orgParentMap = orgVos.stream().filter(item -> StringUtil.isNotEmpty(item.getParentCode()))
                    .collect(Collectors.toMap(OrgVo::getOrgCode, OrgVo::getParentCode, (o, n) -> n));
            Map<String, String> parentNameMap = parentOrgVos.stream().collect(Collectors.toMap(OrgVo::getOrgCode, OrgVo::getOrgName, (o, n) -> n));
            for (ActivityDetailPlanItemsExportsVo activityDetailPlanItemsExportsVo : exportsVoList) {
                String departmentCode = activityDetailPlanItemsExportsVo.getDepartmentCode();
                String orgCodes = String.valueOf(departmentCode);
                for (String orgCode : orgCodes.split(",")) {
                    String parentOrgCode = orgParentMap.get(orgCode);
                    if (StringUtil.isEmpty(parentOrgCode)) {
                        continue;
                    }
                    if (StringUtil.isEmpty(parentOrgCode)) {
                        continue;
                    }
                    String parentOrgName = parentNameMap.get(parentOrgCode);
                    if (StringUtil.isEmpty(parentOrgName)) {
                        continue;
                    }
                    activityDetailPlanItemsExportsVo.setParentOrgName(parentOrgName);
                }
            }
        }
        Collection<ActivityDetailPlanItemsExportsVo> exportsVos = nebulaToolkitService.copyCollectionByWhiteList(
                exportsVoList, ActivityDetailPlanItemsExportsVo.class, ActivityDetailPlanItemsExportsVo.class, LinkedHashSet.class, ArrayList.class);
        adjustDate(exportsVos);
        return JSON.parseArray(JSON.toJSONString(exportsVos, SerializerFeature.WriteDateUseDateFormat));
    }

    private void adjustDate(Collection<ActivityDetailPlanItemsExportsVo> data) {
        Map<String, String> poMap = dictToolkitService.findMapByDictTypeCode(ActivityDetailPlanConstant.DICT_TPM_PROMOTION_OBJECT);
        Map<String, String> atMap = dictToolkitService.findMapByDictTypeCode(ActivityDetailPlanConstant.DICT_TPM_AUDIT_TYPE);
        Map<String, String> ynMap = dictToolkitService.findMapByDictTypeCode(ActivityDetailPlanConstant.DICT_YESORNO);

        SimpleDateFormat dayFormat = new SimpleDateFormat(DateUtil.DEFAULT_YEAR_MONTH_DAY);
        for (ActivityDetailPlanItemsExportsVo vo : data) {
            if (null != vo.getActivityBeginDate()) {
                vo.setActivityBeginDateStr(dayFormat.format(vo.getActivityBeginDate()));
            }
            if (null != vo.getActivityEndDate()) {
                vo.setActivityEndDateStr(dayFormat.format(vo.getActivityEndDate()));
            }
            if (null != vo.getOrderBeginDate()) {
                vo.setOrderBeginDateStr(dayFormat.format(vo.getOrderBeginDate()));
            }
            if (null != vo.getOrderEndDate()) {
                vo.setOrderEndDateStr(dayFormat.format(vo.getOrderEndDate()));
            }
            if (StringUtils.isNotBlank(vo.getPromotionObject())) {
                vo.setPromotionObject(poMap.getOrDefault(vo.getPromotionObject(), vo.getPromotionObject()));
            }
            if (StringUtils.isNotBlank(vo.getAuditType())) {
                vo.setAuditType(atMap.getOrDefault(vo.getAuditType(), vo.getAuditType()));
            }
            if (StringUtils.isNotBlank(vo.getIsStartPatrol())) {
                vo.setIsStartPatrol(ynMap.getOrDefault(vo.getIsStartPatrol(), vo.getIsStartPatrol()));
            }
            if (StringUtils.isNotBlank(vo.getRelateToPrice())) {
                vo.setRelateToPrice(ynMap.getOrDefault(vo.getRelateToPrice(), vo.getRelateToPrice()));
            }
            if (StringUtils.isNotBlank(vo.getIncreasePricePromotion())) {
                vo.setIncreasePricePromotion(ynMap.getOrDefault(vo.getIncreasePricePromotion(), vo.getIncreasePricePromotion()));
            }
            if (StringUtils.isNotBlank(vo.getDeductType())) {
                vo.setDeductType(ynMap.getOrDefault(vo.getDeductType(), vo.getDeductType()));
            }
            if (StringUtils.isNotBlank(vo.getDutyProfitAdjust())) {
                vo.setDutyProfitAdjust(ynMap.getOrDefault(vo.getDutyProfitAdjust(), vo.getDutyProfitAdjust()));
            }
            if (StringUtils.isNotBlank(vo.getOccupyTransferBudget())) {
                vo.setOccupyTransferBudget(ynMap.getOrDefault(vo.getOccupyTransferBudget(), vo.getOccupyTransferBudget()));
            }
            if (StringUtils.isNotBlank(vo.getBusinessFormatCode())) {
                vo.setBusinessFormatName(BusinessFormatEnum.getDesc(vo.getBusinessFormatCode()));
            }
            if (StringUtils.isNotBlank(vo.getProcessStatus())) {
                vo.setProcessStatus(ProcessStatusEnum.getStatusNameByKey(vo.getProcessStatus()));
            }
            if (StringUtils.isNotBlank(vo.getBusinessUnitCode())) {
                vo.setBusinessUnitName(BusinessUnitEnum.getDesc(vo.getBusinessUnitCode()));
            }
        }
    }

    @Override
    public String getBusinessCode() {
        return "TPM_ACTIVITY_DETAIL_PLAN_ITEMS_EXPORT";
    }

    @Override
    public String getBusinessName() {
        return "活动细案明细导出";
    }

    /**
     * 获取对象转换实体
     *
     * @return
     */
    @Override
    public Class<ActivityDetailPlanItemsExportsVo> findCrmExcelVoClass() {
        return ActivityDetailPlanItemsExportsVo.class;
    }

    /**
     * 已正确匹配的执行策略
     *
     * @param europaInfoVo
     * @return
     */
    private ExecutionStrategy getMatchedExecution(EuropaInfoVo europaInfoVo) {
        // 已正确匹配的执行策略
        ExecutionStrategy matchedExecutionStrategy = null;
        for (ExecutionStrategy executionStrategy : executionStrategies) {
            if (executionStrategy.validate(europaInfoVo)) {
                matchedExecutionStrategy = executionStrategy;
                break;
            }
        }
        Validate.notNull(matchedExecutionStrategy, "执行数据视图时，未找到匹配的执行器，请检查数据视图数据");
        return matchedExecutionStrategy;
    }

    private RequestParameter buildRequestParameter(Pageable pageable, String europaInfoCode, Map<String, Object> params) {
        DatabaseExecuteExternalRequest requestParameter = new DatabaseExecuteExternalRequest();
        /*
         * 参数解析顺序
         * 1、获取传参
         * 2、组装可能的pageable分页信息
         * 3、组装排序条件
         */
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String key = entry.getKey();
            requestParameter.setAttribute(key, entry.getValue());
            if ("sort".equalsIgnoreCase(key)) {
                String sortAtt = "" + entry.getValue();
                String[] split = sortAtt.split(",");
                if (split.length == 1) {
                    requestParameter.setAttribute(StringUtils.join("sort.", split[0]), "ASC");
                } else if (split.length >= 2) {
                    requestParameter.setAttribute(StringUtils.join("sort.", split[0]), split[1]);
                }
            }
        }
        // 2、=====
        requestParameter.setAttribute(EuropaParamsTools.EUROPA_CODE_PARAMETER_NAME, europaInfoCode);
        // 创建一个分页对象
        requestParameter.setPageable(pageable);
        return requestParameter;
    }

    @Override
    public String getTaskFileName(ExportTaskProcessVo task) {
        //哎，我没办法了，加在这里吧

        return ExportProcess.super.getTaskFileName(task);
    }
}
