package com.biz.crm.tpm.business.activity.detail.plan.local.exports;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.tpm.business.activity.detail.plan.local.constant.ApprovalConstant;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.report.service.MarketingApprovalService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.MarketingApprovalDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.MarketingApprovalExportVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.MarketingApprovalVo;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;

/**
 * 行销费用批复表导出
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2023.3.11 14:43
 */
@Component
@Slf4j
public class MarketingApprovalExportProcess implements ExportProcess<MarketingApprovalExportVo> {

    @Autowired(required = false)
    private MarketingApprovalService marketingApprovalService;
    @Autowired(required = false)
    private DictDataVoService dictDataVoService;

    @Override
    public Integer getTotal(Map<String, Object> params) {
        params = this.convertEuropaParam(params);
        Pageable pageable = PageRequest.of(1, 1);
        MarketingApprovalDto dto = convertParams(params);
        Page<MarketingApprovalVo> pageResult = this.marketingApprovalService.findAllConditions(pageable, dto);
        Validate.isTrue(pageResult.getTotal() < CommonConstant.IE_EXPORT_MAX_TOTAL, "导出时，" +
                "单次最大导出[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]条,请输入更多查询条件!!");
        return Long.valueOf(pageResult.getTotal()).intValue();
    }

    @Override
    @Transactional(readOnly = true)
    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        params = this.convertEuropaParam(params);
        log.info("=====>      销售费用批复表导出[{}]    <=====", JSON.toJSONString(vo));
        Pageable pageable = PageRequest.of(vo.getPageNo() + 1, getPageSize());
        MarketingApprovalDto dto = convertParams(params);
        Page<MarketingApprovalVo> pageResult = this.marketingApprovalService.findAllConditions(pageable, dto);
        if (CollectionUtils.isEmpty(pageResult.getRecords())) {
            return new JSONArray();
        }
        List<MarketingApprovalVo> records = pageResult.getRecords();
        adjustData(records);
        //TODO 按照配置导出字段过滤
        return JSON.parseArray(JSON.toJSONString(records, SerializerFeature.WriteDateUseDateFormat));
    }


    @Override
    public Class<MarketingApprovalExportVo> findCrmExcelVoClass() {
        return MarketingApprovalExportVo.class;
    }

    @Override
    public String getBusinessCode() {
        return "TPM_MARKETING_APPROVAL_EXPORT";
    }

    @Override
    public Integer getPageSize() {
        return CommonConstant.IE_EXPORT_PAGE_SIZE;
    }

    /**
     * 获取参数
     *
     * @param params
     * @return
     */
    private MarketingApprovalDto convertParams(Map<String, Object> params) {
        // map 参数转换为对应的dto参数对象，可以手工进行修改设置
        return JSON.parseObject(JSON.toJSONString(params), MarketingApprovalDto.class);
    }

    /**
     * 调整数据
     *
     * @param data
     */
    private void adjustData(Collection<MarketingApprovalVo> data) {
        //  转换数据字典值
        Map<String, List<DictDataVo>> mapDict = this.dictDataVoService.findByDictTypeCodeList(Lists.newArrayList(ApprovalConstant.TPM_BUDGET_DATA_TYPE,
                ApprovalConstant.MDM_BUSINESS_FORMAT,
                ApprovalConstant.TPM_DEPARTMENT_BELONG,
                ApprovalConstant.TPM_PROMOTION_OBJECT,
                ApprovalConstant.YES_OR_NO));
        for (MarketingApprovalVo vo : data) {
            vo.setRegionDataTypeCode(this.findDictValue(mapDict, ApprovalConstant.TPM_BUDGET_DATA_TYPE, String.valueOf(vo.getRegionDataTypeCode())));
            vo.setHeadquartersDataTypeCode(this.findDictValue(mapDict, ApprovalConstant.TPM_BUDGET_DATA_TYPE, String.valueOf(vo.getHeadquartersDataTypeCode())));
            vo.setRegionDepartmentBelongCode(this.findDictValue(mapDict, ApprovalConstant.TPM_DEPARTMENT_BELONG, String.valueOf(vo.getRegionDepartmentBelongCode())));
            vo.setHeadquartersDepartmentBelongCode(this.findDictValue(mapDict, ApprovalConstant.TPM_DEPARTMENT_BELONG, String.valueOf(vo.getHeadquartersDepartmentBelongCode())));
            vo.setBusinessCode(this.findDictValue(mapDict, ApprovalConstant.MDM_BUSINESS_FORMAT, String.valueOf(vo.getBusinessCode())));
            vo.setIsStartPatrol(this.findDictValue(mapDict, ApprovalConstant.YES_OR_NO, String.valueOf(vo.getIsStartPatrol())));
            vo.setWhetherTwentyTerminal(this.findDictValue(mapDict, ApprovalConstant.YES_OR_NO, String.valueOf(vo.getWhetherTwentyTerminal())));
            vo.setIsTemporary(this.findDictValue(mapDict, ApprovalConstant.YES_OR_NO, String.valueOf(vo.getIsTemporary())));
            vo.setPromotionObject(this.findDictValue(mapDict, ApprovalConstant.TPM_PROMOTION_OBJECT, String.valueOf(vo.getPromotionObject())));
        }
    }

    /**
     * 获取字典值
     *
     * @param mapDict
     * @param dictTypeCode
     * @param code
     * @return
     */
    private String findDictValue(Map<String, List<DictDataVo>> mapDict, String dictTypeCode, String code) {
        if (Objects.isNull(mapDict) || StringUtils.isBlank(dictTypeCode) || StringUtils.isBlank(code)) {
            return StringUtils.EMPTY;
        }
        final List<DictDataVo> vos = mapDict.get(dictTypeCode);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(vos)) {
            return StringUtils.EMPTY;
        }
        final Optional<String> first =
                vos.stream()
                        .filter(a -> a.getDictCode().equals(code))
                        .map(DictDataVo::getDictValue)
                        .findFirst();
        return first.orElse(StringUtils.EMPTY);
    }

    @Override
    public String getBusinessName() {
        return "TPM行销费用批复表";
    }

}
