package com.biz.crm.tpm.business.activity.detail.plan.local.exports;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgSubComOrgService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgSubComOrgVo;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.tpm.business.activity.detail.plan.local.vo.SubRelatedDetailPlanItemExportsVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.AcceptTypeEnum;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormVo;
import com.biz.crm.tpm.business.activity.form.sdk.vo.SubRelatedMainActivityFormVo;
import com.biz.crm.tpm.business.activity.type.sdk.service.ActivityTypeService;
import com.biz.crm.tpm.business.activity.type.sdk.vo.ActivityTypeVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @Description: 分子向上关联活动细案 导出
 * @Author qiancheng
 * @Date 2023/3/17
 */
@Slf4j
@Component
public class SubRelatedDetailPlanItemExportsProcess implements ExportProcess<SubRelatedDetailPlanItemExportsVo> {

    @Autowired(required = false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private ActivityTypeService activityTypeService;

    @Autowired(required = false)
    private ActivityFormService activityFormService;

    @Autowired(required = false)
    private CustomerVoService customerVoService;

    @Autowired(required = false)
    private SalesOrgSubComOrgService salesOrgSubComOrgService;

    @Autowired(required = false)
    private DictDataVoService dictDataVoService;

    private final static String mdm_channel_r_sap = "mdm_channel_r_sap";//渠道编码与SAP渠道编码映射

    @Override
    public Integer getPageSize(){
        return CommonConstant.IE_EXPORT_PAGE_SIZE;
    }

    @Override
    public Class<SubRelatedDetailPlanItemExportsVo> findCrmExcelVoClass() {
        return SubRelatedDetailPlanItemExportsVo.class;
    }

    @Override
    public Integer getTotal(Map<String, Object> params) {
        String feeYearMonth = (String) params.get("feeYearMonth");
        String customerCode = (String) params.get("customerCode");
        String customerName = (String) params.get("customerName");
        String channelCode = (String) params.get("channel");
        String typeCode = (String) params.get("activityTypeCode");
        List<String> typeCodes = this.conversionTypeCode(typeCode);
        String formCode = (String) params.get("activityFormCode");
        List<String> formCodes = this.conversionFormCode(formCode);
        ActivityDetailPlanItemDto dto = new ActivityDetailPlanItemDto();
        dto.setFeeYearMonth(DateUtil.parse(feeYearMonth,"yyyy-MM"));
        dto.setCustomerCode(customerCode);
        dto.setCustomerName(customerName);
        dto.setDistributionChannelCode(channelCode);
        dto.setTenantCode(TenantUtils.getTenantCode());
        if (!CollectionUtils.isEmpty(typeCodes)) {
            dto.setTypeCodes(typeCodes);
        }
        if (!CollectionUtils.isEmpty(formCodes)) {
            dto.setFormCodes(formCodes);
        }
        Integer total = activityDetailPlanItemSdkService.getSubRelatedItemTotal(dto);
        Validate.isTrue(total < CommonConstant.IE_EXPORT_MAX_TOTAL, "导出时，" +
                "单次最大导出[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]条,请输入更多查询条件!!");

        return total;
    }

    @Override
    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {

        String feeYearMonth = (String) params.get("feeYearMonth");
        String customerCode = (String) params.get("customerCode");
        String customerName = (String) params.get("customerName");
        String channelCode = (String) params.get("channel");
        String typeCode = (String) params.get("activityTypeCode");
        List<String> typeCodes = this.conversionTypeCode(typeCode);
        String formCode = (String) params.get("activityFormCode");
        List<String> formCodes = this.conversionFormCode(formCode);
        ActivityDetailPlanItemDto dto = new ActivityDetailPlanItemDto();
        dto.setFeeYearMonth(DateUtil.parse(feeYearMonth,"yyyy-MM"));
        dto.setCustomerCode(customerCode);
        dto.setCustomerName(customerName);
        dto.setDistributionChannelCode(channelCode);
        dto.setTenantCode(TenantUtils.getTenantCode());
        if (!CollectionUtils.isEmpty(typeCodes)) {
            dto.setTypeCodes(typeCodes);
        }
        if (!CollectionUtils.isEmpty(formCodes)) {
            dto.setFormCodes(formCodes);
        }
        Integer total = activityDetailPlanItemSdkService.getSubRelatedItemTotal(dto);
        if (Objects.isNull(total) || total <= 0) {
            throw new IllegalArgumentException("未查询到数据，无需执行导出！");
        }
        Integer pageSize = this.getPageSize();
        Integer num = total / pageSize;
        List<ActivityDetailPlanItemVo> planItemList = new ArrayList<>(total+1);
        for (int i = 0 ; i <= num ; i++) {
            List<ActivityDetailPlanItemVo> dataList = activityDetailPlanItemSdkService.findSubRelatedCachePageList(i,pageSize,dto);
            if (!CollectionUtils.isEmpty(dataList)) {
                planItemList.addAll(dataList);
            }
        }

        if (CollectionUtils.isEmpty(planItemList)) {
            return new JSONArray();
        }
        List<SubRelatedDetailPlanItemExportsVo> exportsList = (List<SubRelatedDetailPlanItemExportsVo>) nebulaToolkitService.copyCollectionByWhiteList(planItemList, ActivityDetailPlanItemVo.class, SubRelatedDetailPlanItemExportsVo.class, HashSet.class, ArrayList.class);
        this.convertData(exportsList,typeCode,formCode);
        SubRelatedDetailPlanItemExportsVo top = new SubRelatedDetailPlanItemExportsVo();
        top.setColumn1("*用于导入时格式校验，此行勿删");
        exportsList.add(0,top);
        return JSON.parseArray(JSON.toJSONString(exportsList));
    }

    /**
     * 活动形式、活动分类、销售机构、渠道等 由主体的 转换为对应分子的。
     *
     * @param exportsList
     * @param typeCode
     * @param formCode
     */
    private void convertData(Collection<SubRelatedDetailPlanItemExportsVo> exportsList, String typeCode, String formCode) {
        if (CollectionUtils.isEmpty(exportsList)) {
            return;
        }
        List<DictDataVo> mdmChannelRelatedSap = dictDataVoService.findByDictTypeCode(mdm_channel_r_sap);
        Map<String, DictDataVo> channelCodeMap = mdmChannelRelatedSap.stream().collect(Collectors.toMap(DictDataVo::getDictCode, o -> o));
        List<String> planCustomerCodes = exportsList.stream().map(SubRelatedDetailPlanItemExportsVo::getCustomerCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<CustomerVo> customerVos = customerVoService.findByCustomerCodes(planCustomerCodes);
        List<String> mdgCodes = customerVos.stream().map(CustomerVo::getErpCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        //客户编码对应mdg编码map
        Map<String, String> mdgMap = customerVos.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, CustomerVo::getErpCode, (v1, v2) -> v1));
        List<SalesOrgSubComOrgVo> salesOrgSubComOrgVos = salesOrgSubComOrgService.listBySubComOrgCodeList(mdgCodes);
        //mdg编码对应的销售机构编码
        Map<String, SalesOrgSubComOrgVo> orgCodeMap = salesOrgSubComOrgVos.stream().collect(Collectors.toMap(SalesOrgSubComOrgVo::getSubComOrgCode,each -> each,(v1,v2) -> v1));
//        Map<String, List<SubRelatedMainActivityTypeVo>> typeCodeMap = null;
        Map<String, List<SubRelatedMainActivityFormVo>> formCodeMap = null;
//        if (StringUtils.isBlank(typeCode)) {
//            List<String> mainTypeCodes = exportsList.stream().map(SubRelatedDetailPlanItemExportsVo::getActivityTypeCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
//            List<SubRelatedMainActivityTypeVo> typeVoList = activityTypeService.findSubRelatedMainByCodes(mainTypeCodes);
//            if (!CollectionUtils.isEmpty(typeVoList)) {
//                typeCodeMap = typeVoList.stream().collect(Collectors.groupingBy(SubRelatedMainActivityTypeVo::getMainActivityTypeCode));
//            }
//        }
        if (StringUtils.isBlank(formCode)) {
            List<String> mainFormCodes = exportsList.stream().map(SubRelatedDetailPlanItemExportsVo::getActivityFormCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            List<SubRelatedMainActivityFormVo> formVoList = activityFormService.findSubRelatedMainByCodes(mainFormCodes);
            if (!CollectionUtils.isEmpty(formVoList)) {
                formCodeMap = formVoList.stream().collect(Collectors.groupingBy(SubRelatedMainActivityFormVo::getMainFormCode));
            }
        }
        SimpleDateFormat sif1 = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat sif2 = new SimpleDateFormat("yyyy-MM");
        for (SubRelatedDetailPlanItemExportsVo export : exportsList) {
            //总部支持
            BigDecimal headFeeAmount = Optional.ofNullable(export.getHeadFeeAmount()).orElse(BigDecimal.ZERO);
            //大区承担
            BigDecimal departmentFeeAmount = Optional.ofNullable(export.getDepartmentFeeAmount()).orElse(BigDecimal.ZERO);
            //客户承担
            BigDecimal customerFeeAmount = Optional.ofNullable(export.getCustomerFeeAmount()).orElse(BigDecimal.ZERO);
            export.setTotalCostAmount(headFeeAmount.add(departmentFeeAmount).add(customerFeeAmount));
            export.setHeadInvestmentFeeAmount(headFeeAmount.add(departmentFeeAmount));
            export.setSelfInvestmentFeeAmount(customerFeeAmount);
            if (!ObjectUtils.isEmpty(export.getActivityBeginDate())) {
                export.setActivityBeginDateStr(sif1.format(export.getActivityBeginDate()));
            }
            if (!ObjectUtils.isEmpty(export.getActivityEndDate())) {
                export.setActivityEndDateStr(sif1.format(export.getActivityEndDate()));
            }
            if (!ObjectUtils.isEmpty(export.getOrderBeginDate())) {
                export.setOrderBeginDateStr(sif1.format(export.getOrderBeginDate()));
            }
            if (!ObjectUtils.isEmpty(export.getOrderEndDate())) {
                export.setOrderEndDateStr(sif1.format(export.getOrderEndDate()));
            }
            if (!ObjectUtils.isEmpty(export.getFeeYearMonth())) {
                export.setFeeYearMonthStr(sif2.format(export.getFeeYearMonth()));
            }
//            if (!StringUtils.isBlank(typeCode)) {
//                export.setActivityTypeCode(typeCode);
//            }else {
//                if (!CollectionUtils.isEmpty(typeCodeMap)) {
//                    List<SubRelatedMainActivityTypeVo> typeVoList = typeCodeMap.get(export.getActivityTypeCode());
//                    export.setActivityTypeCode("");
//                    if (!CollectionUtils.isEmpty(typeVoList)) {
//                        List<String> subTypeCodes = typeVoList.stream().map(SubRelatedMainActivityTypeVo::getSubActivityTypeCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
//                        StringBuilder typeCodes = new StringBuilder();
//                        Iterator<String> codeIt = subTypeCodes.iterator();
//                        while (codeIt.hasNext()) {
//                            String next = codeIt.next();
//                            typeCodes.append(next);
//                            if (codeIt.hasNext()) {
//                                typeCodes.append(",");
//                            }
//                        }
//                        export.setActivityTypeCode(typeCodes.toString());
//                    }
//                }else {
//                    export.setActivityTypeCode("");
//                }
//            }
            if (!StringUtils.isBlank(formCode)) {
                export.setActivityFormCode(formCode);
            }else {
                if (!CollectionUtils.isEmpty(formCodeMap)) {
                    List<SubRelatedMainActivityFormVo> fromVoList = formCodeMap.get(export.getActivityFormCode());
                    export.setActivityFormCode("");
                    export.setActivityFormName("");
                    export.setActivityTypeCode("");
                    if (!CollectionUtils.isEmpty(fromVoList)) {
                        List<String> subFormCodes = fromVoList.stream().map(SubRelatedMainActivityFormVo::getSubFormCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                        List<String> subFormNames = fromVoList.stream().map(SubRelatedMainActivityFormVo::getSubFormName).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                        List<String> subTypeCodes = fromVoList.stream().map(SubRelatedMainActivityFormVo::getActivityTypeCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                        StringBuilder formCodes = new StringBuilder();
                        Iterator<String> codtIt = subFormCodes.iterator();
                        while (codtIt.hasNext()) {
                            String next = codtIt.next();
                            formCodes.append(next);
                            if (codtIt.hasNext()){
                                formCodes.append(",");
                            }
                        }
                        StringBuilder formNames = new StringBuilder();
                        Iterator<String> nameIt = subFormNames.iterator();
                        while (nameIt.hasNext()) {
                            String next = nameIt.next();
                            formNames.append(next);
                            if (nameIt.hasNext()) {
                                formNames.append(",");
                            }
                        }
                        StringBuilder typeCodes = new StringBuilder();
                        Iterator<String> codeIt = subTypeCodes.iterator();
                        while (codeIt.hasNext()) {
                            String next = codeIt.next();
                            typeCodes.append(next);
                            if (codeIt.hasNext()) {
                                typeCodes.append(",");
                            }
                        }
                        export.setActivityTypeCode(typeCodes.toString());
                        export.setActivityFormCode(formCodes.toString());
                        export.setActivityFormName(formNames.toString());
                    }
                }else {
                    export.setActivityFormCode("");
                    export.setActivityFormName("");
                }
            }
            if (!StringUtils.isBlank(export.getFirstChannelCode())) {
                DictDataVo dictDataVo = channelCodeMap.get(export.getFirstChannelCode());
                if (!Objects.isNull(dictDataVo)) {
                    export.setFirstChannelCode(dictDataVo.getDictValue());
                }
            }
            if (!StringUtils.isBlank(export.getUndertakingMode())){
                export.setUndertakingMode(AcceptTypeEnum.getDesc(export.getUndertakingMode()));
            }
            String mdgCode = mdgMap.get(export.getCustomerCode());
            SalesOrgSubComOrgVo orgVo = orgCodeMap.get(mdgCode);
            if (!ObjectUtils.isEmpty(orgVo)) {
                export.setSalesInstitutionCode(orgVo.getSalesOrgCode());
            }else {
                export.setSalesInstitutionCode("");
            }
        }
    }

    @Override
    public String getBusinessCode() {
        return "TPM_SUB_RELATED_ACTIVITY_DETAIL_PLAN_ITEM_EXPORT";
    }

    @Override
    public String getBusinessName() {
        return "分子向上关联活动细案导出";
    }

    /**
     * 获取分子公司活动形式对应的主体活动形式
     * @param formCode 分子公司活动形式
     */
    private List<String> conversionFormCode(String formCode){
        if (StringUtils.isBlank(formCode)) {
            return null;
        }
        ActivityFormVo formVo = activityFormService.findOneByCode(formCode);
        String subMainActivityFormCode = formVo.getSubMainActivityFormCode();
        if (StringUtils.isBlank(subMainActivityFormCode)) {
            return null;
        }
        String[] split = subMainActivityFormCode.split(",");
        return Lists.newArrayList(split);
    }

    /**
     * 获取分子公司活动分类对应的主体活动分类
     * @param typeCode 分子公司活动分类
     */
    private List<String> conversionTypeCode(String typeCode){
        if (StringUtils.isBlank(typeCode)) {
            return null;
        }
        List<String> typeCodes = new ArrayList<>();
        typeCodes.add(typeCode);
        List<ActivityTypeVo> typeVos = activityTypeService.findByCodes(typeCodes);
        if (CollectionUtils.isEmpty(typeVos) || ObjectUtils.isEmpty(typeVos.get(0))) {
            return null;
        }
        String subMainActivityTypeCode = typeVos.get(0).getSubMainActivityTypeCode();
        if (StringUtils.isBlank(subMainActivityTypeCode)) {
            return null;
        }
        String[] split = subMainActivityTypeCode.split(",");
        return Lists.newArrayList(split);

    }
}
