package com.biz.crm.tpm.business.activity.detail.plan.local.imports;

import cn.hutool.core.collection.CollectionUtil;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.customer.channel.sdk.service.CustomerChannelVoService;
import com.biz.crm.mdm.business.customer.channel.sdk.vo.CustomerChannelVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.product.brand.sdk.service.ProductBrandService;
import com.biz.crm.mdm.business.product.brand.sdk.vo.ProductBrandVo;
import com.biz.crm.mdm.business.product.level.sdk.enums.ProductLevelEnum;
import com.biz.crm.mdm.business.product.level.sdk.service.ProductLevelVoSdkService;
import com.biz.crm.mdm.business.product.level.sdk.vo.ProductLevelVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mdm.business.terminal.channel.sdk.service.MdmTerminalChannelVoService;
import com.biz.crm.mdm.business.terminal.channel.sdk.vo.MdmTerminalChannelVo;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.biz.crm.tpm.business.activity.detail.plan.local.imports.vo.ActivityDetailPlanDY00000008SalesItemImportVo;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.internal.ActivityDetailPlanItemPageCacheHelper;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.constant.ActivityDetailPlanConstant;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemTerminalDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.RtmModelCodeEnum;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.SummaryDimensionEnum;
import com.biz.crm.tpm.business.activity.form.sdk.enums.ApplicationDimensionEnum;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormVo;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.TpmAuditTypeEnum;
import com.biz.crm.tpm.business.activity.type.sdk.service.ActivityTypeService;
import com.biz.crm.tpm.business.activity.type.sdk.vo.ActivityTypeVo;
import com.biz.crm.tpm.business.audit.business.sdk.service.AuditFormulaMainService;
import com.biz.crm.tpm.business.audit.business.sdk.vo.AuditFormulaMainVo;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.MonthBudgetGroupEnum;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

/**
 * 活动细案明细导入服务-主体-销售费用
 * @author wanghaojia
 * @date 2022/11/11 16:19
 */
@Slf4j
@Component
public class ActivityDetailPlanDY00000008SalesImportsProcess implements ImportProcess<ActivityDetailPlanDY00000008SalesItemImportVo> {

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired
    private ActivityDetailPlanItemPageCacheHelper activityDetailPlanItemPageCacheHelper;

    @Autowired(required = false)
    private ActivityTypeService activityTypeService;
    @Autowired(required = false)
    private ActivityFormService activityFormService;
    @Autowired(required = false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required = false)
    private MonthBudgetService monthBudgetService;
    @Autowired(required = false)
    private CustomerVoService customerVoService;
    @Autowired(required = false)
    private MdmTerminalChannelVoService terminalChannelVoService;
    @Autowired(required = false)
    private ProductBrandService productBrandService;
    @Autowired(required = false)
    private ProductVoService productVoService;
    @Autowired(required = false)
    private ProductLevelVoSdkService productLevelVoSdkService;
    @Autowired(required = false)
    private TerminalVoService terminalVoService;

    @Autowired(required = false)
    private DictDataVoService dictDataVoService;
    @Autowired(required = false)
    private AuditFormulaMainService auditFormulaMainService;
    @Autowired(required = false)
    private CustomerChannelVoService customerChannelVoService;

    private final static String tpm_pay_type = "tpm_pay_type";//付款方式
    private final static String tpm_audit_form = "tpm_audit_form";//结案形式
    private final static String tpm_audit_type = "tpm_audit_type";//核销类型
    private final static String tpm_promotion_object = "tpm_promotion_object";//促销对象

    private final static String tpm_display_lot = "tpm_display_lot";//陈列批次
    private final static String yesOrNo = "yesOrNo";//是否

    private final static String accept_type = "accept_type";//活动承接类型


    private final static String activityIntensityPattern = "\\d+[/]\\d+";

    private final static String tpm_activity_import_template_mapping = "tpm_activity_import_template_mapping";//导入模板校验

    @Override
    public Map<Integer, String> execute(LinkedHashMap<Integer, ActivityDetailPlanDY00000008SalesItemImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        Map<Integer, String> errorMap = Maps.newHashMap();
        try {
            Object cacheKeyObj = params.get("cacheKey");
        Validate.notNull(cacheKeyObj,"扩展参数cacheKey不能为空");
        String cacheKey = String.valueOf(cacheKeyObj);
        //有策略编码，从数据库里面查出来放到缓存里面
        String[] split1 = cacheKey.split(":");
        String templateCode = split1[split1.length - 1];//模板编码
        DictDataVo dictDataVo = dictDataVoService.findByDictTypeCodeAndDictCode(tpm_activity_import_template_mapping, templateCode);
        if (null == dictDataVo){
            throw new RuntimeException("导入模板["+templateCode+"]未在数据字典[tpm_activity_import_template_mapping]中配置");
        }
        if (!dictDataVo.getDictValue().equals(getTemplateCode())){
            throw new RuntimeException("细案模板与导入模板请保持一致。");
        }

        Object businessFormatCodeObj = params.get("businessFormatCode");
        String businessFormatCode = null;
        if (null != businessFormatCodeObj){
            businessFormatCode = businessFormatCodeObj.toString();
        }

        Object isSummary = params.get("isGather");
        Validate.notNull(isSummary, "扩展参数isSummary不能为空");
        Validate.isTrue(BooleanEnum.TRUE.getCapital().equals(isSummary) || BooleanEnum.FALSE.getCapital().equals(isSummary), "扩展参数isSummary只能为Y或N");
        Object summaryDimension = params.get("summaryDimension");
        List<SummaryDimensionEnum> summaryDimensionEnumList = Lists.newArrayList();
        if (BooleanEnum.TRUE.getCapital().equals(isSummary)) {
            Validate.notNull(summaryDimension, "请选择汇总维度！");
            String summaryDimensionStr = summaryDimension.toString();
            Validate.notBlank(summaryDimensionStr, "请选择汇总维度！");
            if (summaryDimensionStr.contains(SummaryDimensionEnum.customer.getCode())) {
                summaryDimensionEnumList.add(SummaryDimensionEnum.customer);
            }
            if (summaryDimensionStr.contains(SummaryDimensionEnum.firstChannel.getCode())) {
                summaryDimensionEnumList.add(SummaryDimensionEnum.firstChannel);
            }
            if (summaryDimensionStr.contains(SummaryDimensionEnum.secondChannel.getCode())) {
                summaryDimensionEnumList.add(SummaryDimensionEnum.secondChannel);
            }
            if (summaryDimensionStr.contains(SummaryDimensionEnum.system.getCode())) {
                summaryDimensionEnumList.add(SummaryDimensionEnum.system);
            }
            if (summaryDimensionStr.contains(SummaryDimensionEnum.terminal.getCode())) {
                summaryDimensionEnumList.add(SummaryDimensionEnum.terminal);
            }
            if (summaryDimensionStr.contains(SummaryDimensionEnum.formDescription.getCode())) {
                summaryDimensionEnumList.add(SummaryDimensionEnum.formDescription);
            }
            Validate.isTrue(!CollectionUtils.isEmpty(summaryDimensionEnumList), "请维护活动形式导入汇总维度数据字典【tpm_detail_plan_summary_dimension】");
        }
        if (CollectionUtil.isEmpty(data)){
            return null;
        }
            List<ActivityDetailPlanDY00000008SalesItemImportVo> importVos = Lists.newArrayList(data.values());

            List<String> dictCodeList = Lists.newArrayList();
            dictCodeList.add(tpm_pay_type);
            dictCodeList.add(tpm_audit_form);
            dictCodeList.add(tpm_audit_type);
            dictCodeList.add(tpm_promotion_object);
            dictCodeList.add(yesOrNo);
            dictCodeList.add(tpm_display_lot);
            dictCodeList.add(accept_type);

            Map<String, List<DictDataVo>> dictMap = dictDataVoService.findByDictTypeCodeList(dictCodeList);
            Map<String, Map<String, String>> dictMapMap = dictMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, item -> item.getValue().stream().collect(Collectors.toMap(DictDataVo::getDictValue, DictDataVo::getDictCode,(o,n)->n)),(o,n)->n));

            Set<String> activityTypeCodeSet = Sets.newHashSet();
            Set<String> activityFormCodeSet = Sets.newHashSet();
            Set<String> salesOrgCodeSet = Sets.newHashSet();
            Set<String> monthBudgetCodeSet = Sets.newHashSet();
            Set<String> customerCodeSet = Sets.newHashSet();
            Set<String> terminalChannelSet = Sets.newHashSet();
            Set<String> productBrandCodeSet = Sets.newHashSet();
            Set<String> productLevelCodeSet = Sets.newHashSet();
            Set<String> productCodeSet = Sets.newHashSet();
            Set<String> terminalCodeSet = Sets.newHashSet();
            Set<String> supplierCodeSet = Sets.newHashSet();
            Set<String> materialCodeSet = Sets.newHashSet();
            Set<String> auditFormulaCodeSet = Sets.newHashSet();
            Set<String> cusChannelCodeSet = Sets.newHashSet();

            for (Map.Entry<Integer, ActivityDetailPlanDY00000008SalesItemImportVo> entry : data.entrySet()) {
                List<String> errorMsgList = new ArrayList<>();
                Integer key = entry.getKey();
                Integer index = key + 2;
                ActivityDetailPlanDY00000008SalesItemImportVo importVo = entry.getValue();
                if (StringUtils.isNotEmpty(importVo.getTerminalMonthSalesAmountStr())) {
                    try {
                        importVo.setTerminalMonthSalesAmount(new BigDecimal(importVo.getTerminalMonthSalesAmountStr()));
                    } catch (Exception e) {
                        log.error("", e);
                        errorMsgList.add("门店预计月销售额（元）格式错误!");
                    }
                }
                if (StringUtils.isNotEmpty(importVo.getActivityTypeCode())) {
                    List<String> typeCodes = Arrays.asList(importVo.getActivityTypeCode().split(","));
                    activityTypeCodeSet.addAll(typeCodes);
                }
                if (StringUtils.isNotEmpty(importVo.getActivityFormCode())) {
                    List<String> formCodes = Arrays.asList(importVo.getActivityFormCode().split(","));
                    activityFormCodeSet.addAll(formCodes);
                }
                if (StringUtils.isNotBlank(importVo.getChannelCode())) {
                    cusChannelCodeSet.add(importVo.getChannelCode());
                }
                if (StringUtils.isNotEmpty(importVo.getSalesInstitutionCode())) {
                    if (StringUtils.isEmpty(importVo.getChannelCode())){
                        errorMsgList.add("第[" + index + "]行渠道编码不能为空");
                    }
                    String insCode = importVo.getChannelCode() + businessFormatCode + importVo.getSalesInstitutionCode();
                    salesOrgCodeSet.add(insCode);
                    if(StringUtils.isNotBlank(importVo.getSalesRegionCode())){
                        String regionCode = insCode + importVo.getSalesRegionCode();
                        salesOrgCodeSet.add(regionCode);
                        if (StringUtils.isNotEmpty(importVo.getSalesOrgCode())) {
                            String salesOrgCode = regionCode + importVo.getSalesOrgCode();
                            salesOrgCodeSet.add(salesOrgCode);
                        }
                    }
                }
                if (StringUtils.isNotEmpty(importVo.getHeadMonthBudgetCode())) {
                    monthBudgetCodeSet.add(importVo.getHeadMonthBudgetCode());
                }
                if (StringUtils.isNotEmpty(importVo.getMonthBudgetCode())) {
                    monthBudgetCodeSet.add(importVo.getMonthBudgetCode());
                }
                if (StringUtils.isNotEmpty(importVo.getCustomerCode())) {
                    if (StringUtils.isEmpty(importVo.getChannelCode())) {
                        errorMsgList.add("第[" + index + "]行渠道编码不能为空");
                    }
                    if (StringUtils.isEmpty(importVo.getSalesInstitutionCode())) {
                        errorMsgList.add("第[" + index + "]行销售机构编码不能为空");
                    }
                    customerCodeSet.add(importVo.getCustomerCode() + importVo.getSalesInstitutionCode() + importVo.getChannelCode() + businessFormatCode);
                }
                if (StringUtils.isNotEmpty(importVo.getFirstChannelCode())) {
                    terminalChannelSet.add(importVo.getFirstChannelCode());
                }
                if (StringUtils.isNotEmpty(importVo.getSecondChannelCode())) {
                    terminalChannelSet.add(importVo.getSecondChannelCode());
                }
                if (StringUtils.isNotEmpty(importVo.getProductBrandCode())) {
                    productBrandCodeSet.add(importVo.getProductBrandCode());
                }
                if (StringUtils.isNotEmpty(importVo.getProductItemCode())) {
                    productLevelCodeSet.add(importVo.getProductItemCode());
                }
                if (StringUtils.isNotEmpty(importVo.getProductCategoryCode())) {
                    productLevelCodeSet.add(importVo.getProductCategoryCode());
                }
                if (StringUtils.isNotEmpty(importVo.getProductCode())) {
                    List<String> productCodes = Arrays.asList(importVo.getProductCode().split(","));
                    productCodeSet.addAll(productCodes);
                }
                if (StringUtils.isNotEmpty(importVo.getGiftCode())) {
                    productCodeSet.add(importVo.getGiftCode());
                }
                if (StringUtils.isNotEmpty(importVo.getTerminalCode())) {
                    terminalCodeSet.add(importVo.getTerminalCode());
                }
                if (StringUtils.isNotEmpty(importVo.getMaterialCode())) {
                    materialCodeSet.add(importVo.getMaterialCode());
                }
//                if (StringUtils.isNotEmpty(importVo.getSupplierCode())){
//                    supplierCodeSet.add(importVo.getSupplierCode());
//                }
                if (StringUtils.isNotEmpty(importVo.getAuditConditionCode())) {
                    auditFormulaCodeSet.add(importVo.getAuditConditionCode());
                }
                if (!CollectionUtils.isEmpty(errorMsgList)) {
                    errorMap.put(key, String.join(",", errorMsgList));
                }
            }

            Map<String,String> activityTypeMap = Maps.newHashMap();
            Map<String,ActivityFormVo> activityFormMap = Maps.newHashMap();
            Map<String,SalesOrgVo> salesOrgMap = Maps.newHashMap();
            Map<String, MonthBudgetVo> monthBudgetMap = Maps.newHashMap();
            Map<String, CustomerVo> customerMap = Maps.newHashMap();
            Map<String, TerminalVo> terminalMap = Maps.newHashMap();
            Map<String,String> terminalChannelMap = Maps.newHashMap();
            Map<String,String> productBrandMap = Maps.newHashMap();
            Map<String,ProductLevelVo> productLevelMap = Maps.newHashMap();
            Map<String, ProductVo> productMap = Maps.newHashMap();
            Map<String, AuditFormulaMainVo> auditFormulaMap = Maps.newHashMap();
            Map<String, CustomerChannelVo> cusChannelMap = Maps.newHashMap();

            if (!CollectionUtils.isEmpty(activityTypeCodeSet)){
                List<ActivityTypeVo> activityTypeList = activityTypeService.findByCodes(Lists.newArrayList(activityTypeCodeSet));
                activityTypeMap = activityTypeList.stream().collect(Collectors.toMap(ActivityTypeVo::getActivityTypeCode,ActivityTypeVo::getActivityTypeName,(o,n)->n));
            }
            if (!CollectionUtils.isEmpty(activityFormCodeSet)){
                List<String> activityFormCodeList = Lists.newArrayList(activityFormCodeSet);
                List<ActivityFormVo> activityFormVos = activityFormService.findByCodes(activityFormCodeList);
                activityFormMap = activityFormVos.stream().collect(Collectors.toMap(ActivityFormVo::getActivityFormCode,Function.identity(),(o,n)->n));
            }
            if (!CollectionUtils.isEmpty(cusChannelCodeSet)) {
                List<CustomerChannelVo> channelVos = customerChannelVoService.findByCodes(new ArrayList<>(cusChannelCodeSet));
                if (!CollectionUtils.isEmpty(channelVos)) {
                    cusChannelMap = channelVos.stream().collect(Collectors.toMap(CustomerChannelVo::getCustomerChannelCode, Function.identity(), (o, n) -> n));
                }
            }
            if (!CollectionUtils.isEmpty(salesOrgCodeSet)){
                List<SalesOrgVo> salesOrgVos = salesOrgVoService.findBySalesOrgCodes(Lists.newArrayList(salesOrgCodeSet));
                if (!CollectionUtils.isEmpty(salesOrgVos)){
                    salesOrgMap = salesOrgVos.stream().collect(Collectors.toMap(SalesOrgVo::getSalesOrgCode, Function.identity(),(o,n)->n));
                }
            }
            if (!CollectionUtils.isEmpty(monthBudgetCodeSet)){
                List<MonthBudgetVo> monthBudgetVos = monthBudgetService.listByCodes(Lists.newArrayList(monthBudgetCodeSet));
                monthBudgetMap = monthBudgetVos.stream().collect(Collectors.toMap(MonthBudgetVo::getMonthBudgetCode, Function.identity(),(o,n)->n));
            }
            if (!CollectionUtils.isEmpty(terminalChannelSet)){
                List<MdmTerminalChannelVo> mdmTerminalChannelVos = terminalChannelVoService.listByCodes(Lists.newArrayList(terminalChannelSet));
                terminalChannelMap = mdmTerminalChannelVos.stream().collect(Collectors.toMap(MdmTerminalChannelVo::getTerminalChannelCode,MdmTerminalChannelVo::getTerminalChannelName,(o,n)->n));
            }
            if (!CollectionUtils.isEmpty(productBrandCodeSet)){
                List<ProductBrandVo> productBrandVos = productBrandService.listByCodes(Lists.newArrayList(productBrandCodeSet));
                productBrandMap = productBrandVos.stream().collect(Collectors.toMap(ProductBrandVo::getProductBrandCode,ProductBrandVo::getProductBrandName,(o,n)->n));
            }
            if (!CollectionUtils.isEmpty(productLevelCodeSet)){
                List<ProductLevelVo> productLevelVos = productLevelVoSdkService.findListByBusinessFormatAndCodes(businessFormatCode,Lists.newArrayList(productLevelCodeSet));
                productLevelMap = productLevelVos.stream().collect(Collectors.toMap(item -> {
                    return item.getProductLevelType() + item.getProductLevelCode();
                },Function.identity(),(o,n)->n));
            }
            if (!CollectionUtils.isEmpty(productCodeSet)){
                List<ProductVo> productVos = productVoService.findByCodes(Lists.newArrayList(productCodeSet));
                productMap = productVos.stream().collect(Collectors.toMap(ProductVo::getProductCode,Function.identity(),(o,n)->n));
            }
            if (!CollectionUtils.isEmpty(terminalCodeSet)){
                List<TerminalVo> terminalVos = terminalVoService.findBaseByTerminalCodes(Lists.newArrayList(terminalCodeSet));
                terminalMap = terminalVos.stream().collect(Collectors.toMap(TerminalVo::getTerminalCode,Function.identity(),(o,n)->n));
            }
            if (!CollectionUtils.isEmpty(customerCodeSet)){
                List<String> customerCodeList = Lists.newArrayList(customerCodeSet);
                List<CustomerVo> customerVos = customerVoService.findBaseByCustomerCodes(customerCodeList);
                customerMap = customerVos.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode,Function.identity(),(o,n)->n));
            }
            if (!CollectionUtils.isEmpty(supplierCodeSet)){
                List<ProductVo> productVos = productVoService.findByCodes(Lists.newArrayList(productCodeSet));
                productMap = productVos.stream().collect(Collectors.toMap(ProductVo::getProductCode,Function.identity(),(o,n)->n));
            }

            if(!CollectionUtils.isEmpty(auditFormulaCodeSet)){
                List<AuditFormulaMainVo> auditFormulaList = auditFormulaMainService.findByCodeList(Lists.newArrayList(auditFormulaCodeSet));
                if (!CollectionUtils.isEmpty(auditFormulaList)){
                    auditFormulaMap = auditFormulaList.stream().collect(Collectors.toMap(AuditFormulaMainVo::getAuditFormulaCode, Function.identity(),(o,n)->n));
                }
            }

            Pattern activityIntensityCompile = Pattern.compile(ActivityDetailPlanConstant.activityIntensityPattern);

            List<ActivityDetailPlanItemDto> newList = Lists.newArrayList();
            for (Map.Entry<Integer, ActivityDetailPlanDY00000008SalesItemImportVo> entry : data.entrySet()) {
                List<String> errorMsgList = new ArrayList<>();
                Integer key = entry.getKey();
                Integer index = key + 2;
                ActivityDetailPlanDY00000008SalesItemImportVo importVo = entry.getValue();
                ActivityDetailPlanItemDto itemDto = nebulaToolkitService.copyObjectByWhiteList(importVo, ActivityDetailPlanItemDto.class, HashSet.class, ArrayList.class);

                validateAndConvertDictData(dictMapMap,tpm_pay_type,importVo.getPaymentMethod(),itemDto::setPaymentMethod,errorMsgList,"第["+index+"]付款方式");
                validateAndConvertDictData(dictMapMap,tpm_audit_form,importVo.getAuditForm(),itemDto::setAuditForm,errorMsgList,"第["+index+"]结案形式");
                validateAndConvertDictData(dictMapMap,tpm_audit_type,importVo.getAuditType(),itemDto::setAuditType,errorMsgList,"第["+index+"]核销类型");
                validateAndConvertDictData(dictMapMap,tpm_promotion_object,importVo.getPromotionObject(),itemDto::setPromotionObject,errorMsgList,"第["+index+"]促销对象");
                validateAndConvertDictData(dictMapMap,yesOrNo,importVo.getIsDeductionFeePool(),itemDto::setIsDeductionFeePool,errorMsgList,"第["+index+"]是否扣减费用池");
                validateAndConvertDictData(dictMapMap,tpm_display_lot,importVo.getDisplayLot(),itemDto::setDisplayLot,errorMsgList,"第["+index+"]陈列批次");
                validateAndConvertDictData(dictMapMap,accept_type,importVo.getUndertakingMode(),itemDto::setUndertakingMode,errorMsgList,"第["+index+"]活动承接形式");
                validateAndConvertDictData(dictMapMap,yesOrNo,importVo.getIsCustomerAccount(),itemDto::setIsCustomerAccount,errorMsgList,"第["+index+"]是否客户上账");
                validateAndConvertDictData(dictMapMap,yesOrNo,importVo.getIsBigDate(),itemDto::setIsBigDate,errorMsgList,"第["+index+"]是否大日期");

                //活动分类
                if (StringUtils.isNotEmpty(importVo.getActivityTypeCode())) {
                    String[] codes = importVo.getActivityTypeCode().split(",");
                    LinkedList<String> allNames = new LinkedList<>();
                    for (String code : codes) {
                        String activityTypeName = activityTypeMap.get(code);
                        if (StringUtils.isEmpty(activityTypeName)) {
//                            throw new RuntimeException("活动分类[" + code + "]有误");
                            errorMsgList.add("第["+index+"]活动分类[" + code + "]有误");
                        } else {
                            allNames.add(activityTypeName);
                        }
                    }
                    itemDto.setActivityType(importVo.getActivityTypeCode());
                    itemDto.setActivityTypeName(String.join(",", allNames));
                }

                //活动形式
                if (StringUtils.isNotEmpty(importVo.getActivityFormCode())){
                    boolean customerNotEmpty = false;
                    boolean terminalNotEmpty = false;
                    boolean orgNotEmpty = false;
                    String[] codes = importVo.getActivityFormCode().split(",");
                    LinkedList<String> allNames = new LinkedList<>();
                    for (String code : codes) {
                        ActivityFormVo activityFormVo = activityFormMap.get(code);
                        if (null == activityFormVo) {
//                            throw new RuntimeException("第["+index+"]活动形式[" + code + "]有误");
                            errorMsgList.add("第["+index+"]活动形式[" + code + "]有误");
                        } else {
                            allNames.add(activityFormVo.getActivityFormName());
                            if (StringUtils.isNotEmpty(activityFormVo.getApplyDimensionality())){
                                if (activityFormVo.getApplyDimensionality().contains(ApplicationDimensionEnum.ORG.getCode())){
                                    orgNotEmpty = true;
                                }
                                if (activityFormVo.getApplyDimensionality().contains(ApplicationDimensionEnum.CUSTOMER.getCode())){
                                    customerNotEmpty = true;
                                }
                                if (activityFormVo.getApplyDimensionality().contains(ApplicationDimensionEnum.TERMINAL.getCode())){
                                    terminalNotEmpty = true;
                                }
                            }
                        }
                    }
                    itemDto.setActivityForm(importVo.getActivityFormCode());
                    itemDto.setActivityFormName(String.join(",", allNames));
//                    if (orgNotEmpty && StringUtils.isEmpty(importVo.get())){
//                        throw new RuntimeException("活动形式["+importVo.getActivityFormCode()+"]组织不能为空");
//                    }
                    if (customerNotEmpty && StringUtils.isEmpty(importVo.getCustomerCode())){
//                        throw new RuntimeException("第["+index+"]活动形式["+importVo.getActivityFormCode()+"]客户不能为空");
                        errorMsgList.add("第["+index+"]活动形式["+importVo.getActivityFormCode()+"]客户不能为空");
                    }
//                    if (terminalNotEmpty && StringUtils.isEmpty(importVo.getCustomerCode())){
//                        throw new RuntimeException("活动形式["+importVo.getActivityFormCode()+"]门店不能为空");
//                    }
                }


                //核销条件（核销公式）
                if (StringUtils.isNotEmpty(importVo.getAuditConditionCode())){
                    AuditFormulaMainVo auditFormula = auditFormulaMap.get(importVo.getAuditConditionCode());
                    if (auditFormula == null){
//                        throw new RuntimeException("第["+index+"]核销条件["+importVo.getAuditConditionCode()+"]有误");
                        errorMsgList.add("第["+index+"]核销条件["+importVo.getAuditConditionCode()+"]有误");
                    }else {
                        itemDto.setAuditConditionName(auditFormula.getAuditFormulaName());

                    }
                } else {
//                    Validate.isTrue(!TpmAuditTypeEnum.AUDITTYPE2.getCode().equals(importVo.getAuditType()), "核销条件编码必填");
                    if (TpmAuditTypeEnum.AUDITTYPE2.getCode().equals(importVo.getAuditType())){
                        errorMsgList.add("第["+index+"]核销条件编码必填");
                    }
                    if (!TpmAuditTypeEnum.AUDITTYPE2.getCode().equals(importVo.getAuditType())){
                    }
                }

                ProductVo productVo = null;
                //产品
                if (StringUtils.isNotEmpty(importVo.getProductCode())){
                    String[] codes = importVo.getProductCode().split(",");
                    LinkedList<String> allNames = new LinkedList<>();
                    for (String code : codes) {
                        productVo = productMap.get(code);
                        if(null == productVo){
//                            throw new RuntimeException("产品编码["+importVo.getProductCode()+"]有误");
                            errorMsgList.add("第["+index+"]产品编码["+importVo.getProductCode()+"]有误");
                        }else {
                            itemDto.setProductUnit(productVo.getBaseUnit());
                            allNames.add(productVo.getProductName());
                        }

                    }
                    itemDto.setProductName(String.join(",",allNames));

                    if (null != productVo){
                        itemDto.setProductUnit(productVo.getBaseUnit());
                        itemDto.setProductBrandCode(productVo.getProductBrandCode());
                        itemDto.setProductBrandName(productVo.getProductBrandName());
                        itemDto.setProductCategoryCode(productVo.getProductCategoryCode());
                        itemDto.setProductCategoryName(productVo.getProductCategoryName());
                        itemDto.setProductItemCode(productVo.getProductLevelCode());
                        itemDto.setProductItemName(productVo.getProductLevelName());
                    }
                }

                //赠品
                if (StringUtils.isNotEmpty(importVo.getGiftCode())){
                    ProductVo giftVo = productMap.get(importVo.getGiftCode());
                    if(null == giftVo){
//                        throw new RuntimeException("赠品编码["+importVo.getGiftCode()+"]有误");
                        errorMsgList.add("第["+index+"]赠品编码["+importVo.getGiftCode()+"]有误");
                    }else {
                        itemDto.setGiftName(giftVo.getProductName());

                    }
                }

                //品牌
                if (StringUtils.isNotEmpty(importVo.getProductBrandCode())){
                    String brandName = productBrandMap.get(importVo.getProductBrandCode());
                    if (StringUtils.isEmpty(brandName)){
                        errorMsgList.add("第["+index+"]品牌["+importVo.getProductBrandCode()+"]有误");
//                        throw new RuntimeException("品牌["+importVo.getProductBrandCode()+"]有误");
                    }else {
                        itemDto.setProductBrandName(brandName);
                    }
                    if (null != productVo && !importVo.getProductBrandCode().equals(productVo.getProductBrandCode())){
//                        throw new RuntimeException("产品["+productVo.getProductCode()+"]不属于品牌["+importVo.getProductBrandCode()+"]");
                        errorMsgList.add("第["+index+"]产品["+productVo.getProductCode()+"]不属于品牌["+importVo.getProductBrandCode()+"]");
                    }
                }

                ProductLevelVo productCategory = null;
                //品类
                if (StringUtils.isNotEmpty(importVo.getProductCategoryCode())){
                    productCategory = productLevelMap.get(ProductLevelEnum.category.getCode() + importVo.getProductCategoryCode());
                    if (null == productCategory){
//                        throw new RuntimeException("品类["+importVo.getProductCategoryCode()+"]有误");
                        errorMsgList.add("第["+index+"]品类["+importVo.getProductCategoryCode()+"]有误");
                    }else {
                        String productLevelName = productCategory.getProductLevelName();
                        itemDto.setProductCategoryName(productLevelName);
                    }
                    if (null != productVo && !importVo.getProductCategoryCode().equals(productVo.getProductCategoryCode())){
//                        throw new RuntimeException("产品["+productVo.getProductCode()+"]不属于品类["+importVo.getProductBrandCode()+"]");
                        errorMsgList.add("第["+index+"]产品["+productVo.getProductCode()+"]不属于品类["+importVo.getProductBrandCode()+"]");
                    }
                }

                //品项
                if (StringUtils.isNotEmpty(importVo.getProductItemCode())){
                    ProductLevelVo productItem = productLevelMap.get(ProductLevelEnum.items.getCode() + importVo.getProductItemCode());
                    if (null == productItem){
//                        throw new RuntimeException("品项["+importVo.getProductItemCode()+"]有误");
                        errorMsgList.add("第["+index+"]品项["+importVo.getProductItemCode()+"]有误");
                    } else {
                        String productLevelName = productItem.getProductLevelName();
                        itemDto.setProductItemName(productLevelName);
                        if (null != productVo && !importVo.getProductItemCode().equals(productVo.getProductLevelCode())) {
//                        throw new RuntimeException("产品["+productVo.getProductCode()+"]不属于品项["+importVo.getProductItemCode()+"]");
                            errorMsgList.add("第[" + index + "]产品[" + productVo.getProductCode() + "]不属于品项[" + importVo.getProductItemCode() + "]");
                        }
                    }

                }

//                //赠品编码
//                if (StringUtils.isNotEmpty(importVo.getGiftCode())){
//                    ProductVo productVo = productMap.get(importVo.getGiftCode());
//                    if(null == productVo){
//                        throw new RuntimeException("赠品编码["+importVo.getGiftCode()+"]有误");
//                    }
//                    itemDto.setGiftName(productVo.getProductName());
//                    itemDto.setGiftUnit(productVo.getSaleUnit());
//                }

                if (StringUtils.isNotEmpty(importVo.getHeadMonthBudgetCode())){
                    MonthBudgetVo monthBudgetVo = monthBudgetMap.get(importVo.getHeadMonthBudgetCode());
                    if (null == monthBudgetVo){
//                        throw new RuntimeException("总部费用预算编码"+importVo.getHeadMonthBudgetCode()+"有误");
                        errorMsgList.add("第["+index+"]总部费用预算编码"+importVo.getHeadMonthBudgetCode()+"有误");
                    }else {
                        if (!MonthBudgetGroupEnum.organization.getCode().equals(monthBudgetVo.getGroupCode())) {
                            //                        throw new RuntimeException("月度预算["+monthBudgetVo.getMonthBudgetCode()+"],必须为部门分组");
                            errorMsgList.add("第[" + index + "]月度预算[" + monthBudgetVo.getMonthBudgetCode() + "],必须为部门分组");
                        }
                        itemDto.setHeadBudgetItemCode(monthBudgetVo.getBudgetItemCode());
                        itemDto.setHeadBudgetItemName(monthBudgetVo.getBudgetItemName());
                    }
                }
                if (StringUtils.isNotEmpty(importVo.getMonthBudgetCode())){
                    MonthBudgetVo monthBudgetVo = monthBudgetMap.get(importVo.getMonthBudgetCode());
                    if (null == monthBudgetVo){
//                        throw new RuntimeException("大区自控预算编码"+importVo.getHeadMonthBudgetCode()+"有误");
                        errorMsgList.add("第["+index+"]大区自控预算编码"+importVo.getHeadMonthBudgetCode()+"有误");
                    }else{
                        if (!MonthBudgetGroupEnum.organization.getCode().equals(monthBudgetVo.getGroupCode())){
//                        throw new RuntimeException("月度预算["+monthBudgetVo.getMonthBudgetCode()+"],必须为部门分组");
                            errorMsgList.add("第["+index+"]月度预算["+monthBudgetVo.getMonthBudgetCode()+"],必须为部门分组");
                        }
                        itemDto.setBudgetItemCode(monthBudgetVo.getBudgetItemCode());
                        itemDto.setBudgetItemName(monthBudgetVo.getBudgetItemName());
                    }
                }

                //渠道
                if (StringUtils.isNotEmpty(importVo.getChannelCode())) {
                    CustomerChannelVo channelVo = cusChannelMap.get(importVo.getChannelCode());
                    if (null == channelVo) {
//                        throw new RuntimeException("渠道编码" + importVo.getChannelCode() + "有误");
                        errorMsgList.add("第["+index+"]渠道编码" + importVo.getChannelCode() + "有误");
                    }else {
                        itemDto.setDistributionChannelCode(channelVo.getCustomerChannelCode());
                        itemDto.setDistributionChannelName(channelVo.getCustomerChannelName());
                    }
                }

                if (StringUtils.isNotEmpty(importVo.getCustomerCode())) {
                    String cusCode = importVo.getCustomerCode() + importVo.getSalesInstitutionCode() + importVo.getChannelCode() + businessFormatCode;
                    CustomerVo customerVo = customerMap.get(cusCode);
                    if (null == customerVo) {
//                        throw new RuntimeException("客户编码" + importVo.getCustomerCode() + "有误");
                        errorMsgList.add("第["+index+"]客户编码" + importVo.getCustomerCode() + "有误");
                    }else {
                        itemDto.setCustomerName(customerVo.getCustomerName());
                        itemDto.setCustomerCode(customerVo.getCustomerCode());
                        itemDto.setCustomerErpCode(customerVo.getErpCode());
                        itemDto.setSalesInstitutionCode(customerVo.getSalesInstitutionCode());
                        itemDto.setSalesInstitutionName(customerVo.getSalesInstitutionName());
                        itemDto.setSalesInstitutionErpCode(customerVo.getSalesInstitutionErpCode());
                        itemDto.setSalesRegionCode(customerVo.getSalesRegionCode());
                        itemDto.setSalesRegionName(customerVo.getSalesRegionName());
                        itemDto.setSalesRegionErpCode(customerVo.getSalesRegionErpCode());
                        itemDto.setSalesOrgCode(customerVo.getSalesOrgCode());
                        itemDto.setSalesOrgName(customerVo.getSalesOrgName());
                        itemDto.setSalesOrgErpCode(customerVo.getSalesOrgErpCode());
                    }
                }

                terminal:if (StringUtils.isNotEmpty(importVo.getTerminalCode())){
                    TerminalVo terminalVo = terminalMap.get(importVo.getTerminalCode());
                    if (null == terminalVo){
//                        throw new RuntimeException("门店编码"+importVo.getTerminalCode()+"有误");
                        break terminal;
                    }
                    itemDto.setTerminalName(terminalVo.getTerminalName());
                    itemDto.setFirstChannelCode(terminalVo.getFirstChannelCode());
                    itemDto.setFirstChannelName(terminalVo.getFirstChannelName());
                    itemDto.setSecondChannelCode(terminalVo.getSecondChannelCode());
                    itemDto.setSecondChannelName(terminalVo.getSecondChannelName());
                }
                //一级渠道
                if (StringUtils.isNotEmpty(importVo.getFirstChannelCode())){
                    String terminalChannelName = terminalChannelMap.get(importVo.getFirstChannelCode());
                    if (StringUtils.isEmpty(terminalChannelName)){
//                        throw new RuntimeException("一级渠道["+importVo.getFirstChannelCode()+"]有误");
                        errorMsgList.add("第["+index+"]一级渠道["+importVo.getFirstChannelCode()+"]有误");
                    }
                    itemDto.setFirstChannelCode(importVo.getFirstChannelCode());
                    itemDto.setFirstChannelName(terminalChannelName);
                }

                //二级渠道
                if (StringUtils.isNotEmpty(importVo.getSecondChannelCode())){
                    String terminalChannelName = terminalChannelMap.get(importVo.getSecondChannelCode());
                    if (StringUtils.isEmpty(terminalChannelName)){
//                        throw new RuntimeException("二级渠道["+importVo.getSecondChannelCode()+"]有误");
                        errorMsgList.add("第["+index+"]二级渠道["+importVo.getSecondChannelCode()+"]有误");
                    }
                    itemDto.setSecondChannelCode(importVo.getSecondChannelCode());
                    itemDto.setSecondChannelName(terminalChannelName);
                }
                //销售机构
                if (StringUtils.isNotEmpty(importVo.getSalesInstitutionCode())) {
                    String insCode = importVo.getChannelCode() + businessFormatCode + importVo.getSalesInstitutionCode();
                    SalesOrgVo salesOrgVo = salesOrgMap.get(insCode);
                    if (null == salesOrgVo) {
//                        throw new RuntimeException("销售机构编码[" + importVo.getSalesInstitutionCode() + "]有误");
                        errorMsgList.add("第["+index+"]销售机构编码[" + importVo.getSalesInstitutionCode() + "]有误");
                    }else {
                        itemDto.setSalesInstitutionCode(salesOrgVo.getSalesOrgCode());
                        itemDto.setSalesInstitutionName(salesOrgVo.getSalesOrgName());
                        itemDto.setSalesInstitutionErpCode(salesOrgVo.getErpCode());
                    }
                    if (StringUtils.isEmpty(importVo.getSalesOrgCode())) {
                        itemDto.setActivityOrgCode(itemDto.getSalesInstitutionCode());
                        itemDto.setActivityOrgName(itemDto.getSalesInstitutionName());
                        itemDto.setActivityOrgErpCode(itemDto.getSalesInstitutionErpCode());
                    }
                    //销售部门
                    if (StringUtils.isNotEmpty(importVo.getSalesRegionCode())) {
                        String regionCode = insCode + importVo.getSalesRegionCode();
                        SalesOrgVo salesOrgVo2 = salesOrgMap.get(regionCode);
                        if (null == salesOrgVo2) {
//                            throw new RuntimeException("销售大区编码[" + importVo.getSalesRegionCode() + "]有误");
                            errorMsgList.add("第["+index+"]销售大区编码[" + importVo.getSalesRegionCode() + "]有误");
                        }else {
                            itemDto.setSalesRegionCode(salesOrgVo2.getSalesOrgCode());
                            itemDto.setSalesRegionErpCode(salesOrgVo2.getErpCode());
                            itemDto.setSalesRegionName(salesOrgVo2.getSalesOrgName());
                        }
                        if (StringUtils.isEmpty(importVo.getSalesOrgCode())) {
                            itemDto.setActivityOrgCode(itemDto.getSalesRegionCode());
                            itemDto.setActivityOrgName(itemDto.getSalesRegionName());
                            itemDto.setActivityOrgErpCode(itemDto.getSalesRegionErpCode());
                        }
                        //销售组
                        if (StringUtils.isNotEmpty(importVo.getSalesOrgCode())) {
                            if (StringUtils.isEmpty(itemDto.getSalesRegionCode())){
//                                throw new RuntimeException("省区编码[" + importVo.getSalesOrgCode() + "]未获取到销售大区");
                                errorMsgList.add("第["+index+"]省区编码[" + importVo.getSalesOrgCode() + "]未获取到销售大区");
                            }
                            String salesCode = itemDto.getSalesRegionCode() + importVo.getSalesOrgCode();
                            SalesOrgVo salesOrgVo3 = salesOrgMap.get(salesCode);
                            if (null == salesOrgVo3) {
//                                throw new RuntimeException("省区编码[" + importVo.getSalesOrgCode() + "]有误");
                                errorMsgList.add("第["+index+"]省区编码[" + importVo.getSalesOrgCode() + "]有误");
                            }else {
                                itemDto.setSalesOrgCode(salesOrgVo3.getSalesOrgCode());
                                itemDto.setSalesOrgErpCode(salesOrgVo3.getErpCode());
                                itemDto.setSalesOrgName(salesOrgVo3.getSalesOrgName());
                                itemDto.setActivityOrgCode(itemDto.getSalesOrgCode());
                                itemDto.setActivityOrgName(itemDto.getSalesOrgName());
                                itemDto.setActivityOrgErpCode(itemDto.getSalesOrgErpCode());
                            }
                        }
                    }
                }

                //校验活动分类，形式
                if (StringUtils.isNotEmpty(importVo.getActivityFormCode())){
                    String[] split = importVo.getActivityFormCode().split(",");
                    for (String str : split) {
                        List<ActivityTypeVo> activityTypeByActivityFormCode = activityTypeService.getActivityTypeByActivityFormCode(str);
                        activityTypeByActivityFormCode.forEach(act->{
                            if (StringUtils.isNotEmpty(importVo.getActivityTypeCode())){
                                String[] actType = importVo.getActivityTypeCode().split(",");
                                if (!Arrays.asList(actType).contains(act.getActivityTypeCode())){
//                                    throw new RuntimeException("活动形式需在活动分类下，请检查数据填写是否正确");
                                    errorMsgList.add("第["+index+"]活动形式需在活动分类下，请检查数据填写是否正确");
                                }
                            }else {
//                                throw new RuntimeException("第["+index+"]活动形式需在活动分类下，请检查数据填写是否正确");
                                errorMsgList.add("第["+index+"]活动形式需在活动分类下，请检查数据填写是否正确");
                            }
                        });
                    }
                }
                //校验必填项
                if (StringUtils.isNotEmpty(importVo.getHeadMonthBudgetCode())){
                    if (StringUtils.isEmpty(importVo.getHeadFeeAmountStr())){
//                        throw new RuntimeException("第["+index+"]总部承担金额不能为空，请检查数据填写是否正确");
                        errorMsgList.add("第["+index+"]总部承担金额不能为空，请检查数据填写是否正确");
                    }
                }
                if (StringUtils.isNotEmpty(importVo.getMonthBudgetCode())){
                    if (StringUtils.isEmpty(importVo.getDepartmentFeeAmountStr())){
//                        throw new RuntimeException("大区承担金额不能为空，请检查数据填写是否正确");
                        errorMsgList.add("大区承担金额不能为空，请检查数据填写是否正确");
                    }
                }
                if (StringUtils.isNotEmpty(importVo.getActivityIntensity())){
                    //活动力度校验
                    try {
                        new BigDecimal(importVo.getActivityIntensity());
                    }catch (Exception e){
                        Matcher activityIntensityMatcher = activityIntensityCompile.matcher(importVo.getActivityIntensity());
                        if (!activityIntensityMatcher.matches()){
//                            throw new RuntimeException("活动力度["+importVo.getActivityIntensity()+"]格式有误");
                            errorMsgList.add("第["+index+"]活动力度["+importVo.getActivityIntensity()+"]格式有误");
                        }
                    }
                }
                //点外金额
                if (StringUtils.isNotEmpty(importVo.getCustomerCode())){
                    String cusCode = importVo.getCustomerCode()+importVo.getSalesInstitutionCode()+importVo.getChannelCode()+businessFormatCode;
                    CustomerVo customerVo = customerMap.get(cusCode);
//                    Validate.notNull(customerVo, "客户编码[" + importVo.getCustomerCode() + "]有误");
                    if (customerVo == null){
                        errorMsgList.add("第["+index+"]客户编码[" + importVo.getCustomerCode() + "]有误");
                    }
                    String rtmModelCode = null;
                    if (customerVo != null) {
                        rtmModelCode = customerVo.getRtmModelCode();
                    }
                    if (StringUtils.isNotEmpty(rtmModelCode)){
                        if (rtmModelCode.equals(RtmModelCodeEnum.SON_COMPANY.getCode())){
                            BigDecimal headFeeAmountStr = new BigDecimal(0);
                            BigDecimal departmentFeeAmountStr = new BigDecimal(0);
                            BigDecimal intraCompanyAmountStr = new BigDecimal(0);
                            BigDecimal offPointAmountStr = new BigDecimal(0);
                            if (StringUtils.isNotEmpty(importVo.getHeadFeeAmountStr())){
                                //总部承担金额
                                try {
                                    headFeeAmountStr = new BigDecimal(importVo.getHeadFeeAmountStr());
                                } catch (NumberFormatException e) {
//                                    throw new IllegalArgumentException("总部承担金额【"+ importVo.getHeadFeeAmountStr() +"】数字转换异常");
                                    errorMsgList.add("第["+index+"]总部承担金额【"+ importVo.getHeadFeeAmountStr() +"】数字转换异常");
                                }
                            }
                            if (StringUtils.isNotEmpty(importVo.getDepartmentFeeAmountStr())){
                                //大区承担金额
                                try {
                                    departmentFeeAmountStr = new BigDecimal(importVo.getDepartmentFeeAmountStr());
                                } catch (NumberFormatException e) {
//                                    throw new IllegalArgumentException("大区承担金额【"+ importVo.getDepartmentFeeAmountStr() +"】数字转换异常");
                                    errorMsgList.add("第["+index+"]大区承担金额【"+ importVo.getDepartmentFeeAmountStr() +"】数字转换异常");
                                }
                            }
                            if (StringUtils.isNotEmpty(importVo.getIntraCompanyAmountStr())){
                                //分子公司点内金额
                                try {
                                    intraCompanyAmountStr = new BigDecimal(importVo.getIntraCompanyAmountStr());
                                } catch (NumberFormatException e) {
//                                    throw new IllegalArgumentException("分子公司点内金额【"+ importVo.getIntraCompanyAmountStr() +"】数字转换异常");
                                    errorMsgList.add("第["+index+"]分子公司点内金额【"+ importVo.getIntraCompanyAmountStr() +"】数字转换异常");
                                }
                            }
                            if (StringUtils.isNotEmpty(importVo.getOffPointAmountStr())){
                                //分子公司点外金额
                                try {
                                    offPointAmountStr = new BigDecimal(importVo.getOffPointAmountStr());
                                } catch (NumberFormatException e) {
//                                    throw new IllegalArgumentException("分子公司点外金额【"+ importVo.getOffPointAmountStr() +"】数字转换异常");
                                    errorMsgList.add("第["+index+"]分子公司点外金额【"+ importVo.getOffPointAmountStr() +"】数字转换异常");
                                }
                            }
                            BigDecimal subtract = headFeeAmountStr.add(departmentFeeAmountStr).subtract(intraCompanyAmountStr);
                            if (subtract.compareTo(offPointAmountStr) != 0){
//                                throw new RuntimeException("分子公司点外金额=总部承担金额+大区承担金额-分子公司点内金额，请检查数据填写是否正确");
                                errorMsgList.add("第["+index+"]分子公司点外金额=总部承担金额+大区承担金额-分子公司点内金额，请检查数据填写是否正确");
                            }
                        }else if (rtmModelCode.equals(RtmModelCodeEnum.DEALER.getCode())){
                            if (StringUtils.isNotEmpty(importVo.getIntraCompanyAmountStr()) && StringUtils.isNotEmpty(importVo.getOffPointAmountStr())){
//                                throw new RuntimeException("分子公司点外金额与分子公司点内金额必须为空，请检查数据填写是否正确");
                                errorMsgList.add("第["+index+"]分子公司点外金额与分子公司点内金额必须为空，请检查数据填写是否正确");
                            }
                            if (StringUtils.isNotEmpty(importVo.getIntraCompanyAmountStr())){
//                                throw new RuntimeException("分子公司点内金额必须为空，请检查数据填写是否正确");
                                errorMsgList.add("第["+index+"]分子公司点内金额必须为空，请检查数据填写是否正确");
                            }
                            if (StringUtils.isNotEmpty(importVo.getOffPointAmountStr())){
//                                throw new RuntimeException("分子公司点外金额必须为空，请检查数据填写是否正确");
                                errorMsgList.add("第["+index+"]分子公司点外金额必须为空，请检查数据填写是否正确");
                            }
                        }
                    }
                }
                newList.add(itemDto);
                if (!CollectionUtils.isEmpty(errorMsgList)){
                    if (errorMap.containsKey(key)){
                        errorMsgList.add(0,errorMap.get(key));
                    }
                    errorMap.put(key,String.join(",",errorMsgList));
                }
            }
            List<ActivityDetailPlanItemDto> finalList = Lists.newArrayList();
            this.summaryByDimension(newList, finalList, isSummary, summaryDimensionEnumList);
            if (errorMap.isEmpty()) {
                this.activityDetailPlanItemPageCacheHelper.importNewItem(cacheKey.toString(), finalList);
            }
        }catch (Exception e){
            log.error(e.getMessage(),e);
            String errorMsg = e.getMessage();
            if (StringUtils.isEmpty(e.getMessage())){
                errorMsg = "数据处理失败！";
            }
            throw new IllegalArgumentException(errorMsg);
        }
        return errorMap;
    }

    private void summaryByDimension(List<ActivityDetailPlanItemDto> newList, List<ActivityDetailPlanItemDto> finalList, Object isSummary, List<SummaryDimensionEnum> summaryDimensionEnumList) {
        if (BooleanEnum.FALSE.getCapital().equals(isSummary)) {
            finalList.addAll(newList);
            return;
        }
        Map<String, List<ActivityDetailPlanItemDto>> dimensionToItemListMap = newList.stream().collect(Collectors.groupingBy(item -> {
            String dimension =
                    //活动类型编码、活动形式编码、活动开始时间 活动结束时间
                    item.getActivityTypeCode() + item.getActivityFormCode() + item.getActivityBeginDateStr() + item.getActivityEndDateStr()
                            //订单开始时间 订单结束时间 总部统筹预算编码 、大区统筹预算编码
                            + item.getOrderBeginDateStr() + item.getOrderEndDateStr() + item.getHeadMonthBudgetCode() + item.getMonthBudgetCode()
                            //大区编码、省区编码、品牌编码、品类编码
                            + item.getSalesRegionCode() + item.getSalesOrgCode() + item.getProductBrandCode() + item.getProductCategoryCode()
                            //品项编码、产品编码、物料编码、采购类型
                            + item.getProductItemCode() + item.getProductCode() + item.getMaterialCode() + item.getProcurementType()
                            //是否扣减费用池、核销类型、付款方式、是否和价额有关
                            + item.getIsDeductionFeePool() + item.getAuditType() + item.getPaymentMethod() + item.getRelateToPrice()
                            //是否涨价政策、是否考核扣款、是否责任利润调整
                            + item.getIncreasePricePromotion() + item.getDeductType() + item.getDutyProfitAdjust()
                            //促销对象、新品归类、是否占用划拨预算、活动力度
                            + item.getPromotionObject() + item.getNewProductType() + item.getOccupyTransferBudget() + item.getActivityIntensity()
                            //陈列批次、是否客户上账、是否发起巡查需求
                            + item.getDisplayLot() + item.getIsCustomerAccount() + item.getIsStartPatrol();
                    if (summaryDimensionEnumList.contains(SummaryDimensionEnum.customer)) {
                        dimension += item.getCustomerCode();
                    }
                    if (summaryDimensionEnumList.contains(SummaryDimensionEnum.firstChannel)) {
                        dimension += item.getFirstChannelCode();
                    }
                    if (summaryDimensionEnumList.contains(SummaryDimensionEnum.secondChannel)) {
                        dimension += item.getSecondChannelCode();
                    }
                    if (summaryDimensionEnumList.contains(SummaryDimensionEnum.system)) {
                        dimension += item.getSystemCode();
                    }
                    if (summaryDimensionEnumList.contains(SummaryDimensionEnum.terminal)) {
                        dimension += item.getTerminalCode();
                    }
                    if (summaryDimensionEnumList.contains(SummaryDimensionEnum.formDescription)) {
                        dimension += item.getFormDescription();
                    }
                    return dimension;
                }
        ));
        log.error("汇总维度：{}", dimensionToItemListMap.keySet());
        dimensionToItemListMap.forEach((key, value) -> {
            List<ActivityDetailPlanItemTerminalDto> terminalDtoList = Lists.newArrayList(nebulaToolkitService.copyCollectionByWhiteList(value, ActivityDetailPlanItemDto.class, ActivityDetailPlanItemTerminalDto.class, HashSet.class, ArrayList.class));
            //汇总：费用合计、 总部承担金额、 大区承担金额、分子公司点内金额、分子公司点外金额、 客户承担金额
            BigDecimal totalFeeAmount = value.stream().filter(e -> StringUtils.isNotEmpty(e.getTotalFeeAmountStr())).map(e -> new BigDecimal(e.getTotalFeeAmountStr())).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal headFeeAmount = value.stream().filter(e -> StringUtils.isNotEmpty(e.getHeadFeeAmountStr())).map(e -> new BigDecimal(e.getHeadFeeAmountStr())).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal departmentFeeAmount = value.stream().filter(e -> StringUtils.isNotEmpty(e.getDepartmentFeeAmountStr())).map(e -> new BigDecimal(e.getDepartmentFeeAmountStr())).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal intraCompanyAmount = value.stream().filter(e -> StringUtils.isNotEmpty(e.getIntraCompanyAmountStr())).map(e -> new BigDecimal(e.getIntraCompanyAmountStr())).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal offPointAmount = value.stream().filter(e -> StringUtils.isNotEmpty(e.getOffPointAmountStr())).map(e -> new BigDecimal(e.getOffPointAmountStr())).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal customerFeeAmount = value.stream().filter(e -> StringUtils.isNotEmpty(e.getCustomerFeeAmountStr())).map(e -> new BigDecimal(e.getCustomerFeeAmountStr())).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            ActivityDetailPlanItemDto finalItem = value.get(0);
            finalItem.setTotalFeeAmountStr(totalFeeAmount.toPlainString());
            finalItem.setHeadFeeAmountStr(headFeeAmount.toPlainString());
            finalItem.setDepartmentFeeAmountStr(departmentFeeAmount.toPlainString());
            finalItem.setIntraCompanyAmountStr(intraCompanyAmount.toPlainString());
            finalItem.setOffPointAmountStr(offPointAmount.toPlainString());
            finalItem.setCustomerFeeAmountStr(customerFeeAmount.toPlainString());
            finalItem.setTerminalList(terminalDtoList);
            finalItem.setTerminalName(null);
            finalItem.setTerminalCode(null);
            finalItem.setTerminalType(null);
            finalItem.setQuantity(null);
            finalItem.setQuantityStr(null);
            finalItem.setPrice(null);
            finalItem.setPriceStr(null);
            finalItem.setTerminalMonthSalesAmountStr(null);
            finalItem.setTerminalMonthSalesAmount(null);
            finalItem.setPersonCode(null);
            finalItem.setPersonName(null);
            finalItem.setPersonType(null);
            finalItem.setIdentityCard(null);
            finalItem.setPersonIdCard(null);
            finalList.add(finalItem);
        });
    }

    @Override
    public Integer getBatchCount() {
        //保证导入不分片
        return Integer.MAX_VALUE;
    }

    public void validateAndConvertDictData(Map<String, Map<String,String>> dictMap, String dictTypeCode, String dictValue, Consumer<String> setMethod, List<String> errorMsgList,String desc){
        if (StringUtils.isEmpty(dictValue)){
            return;
        }
        Map<String, String> dictDataMap = dictMap.get(dictTypeCode);
        String dictCode = dictDataMap.get(dictValue);
        if (StringUtils.isEmpty(dictCode)){
//            throw new RuntimeException(desc+"["+dictValue+"]有误");
            errorMsgList.add(desc+"["+dictValue+"]有误");
        }
        setMethod.accept(dictCode);
    }

    @Override
    public Class<ActivityDetailPlanDY00000008SalesItemImportVo> findCrmExcelVoClass() {
        return ActivityDetailPlanDY00000008SalesItemImportVo.class;
    }

    @Override
    public String getTemplateCode() {
        return "TPM_DETAIL_ACTIVITY_PLAN_IMPORT_DY00000008_SALES";
    }

    @Override
    public String getTemplateName() {
        return "活动细案销售费用导入模板（主体）";
    }

    @Override
    public String getBusinessCode() {
        return "TPM_ACTIVITY_DETAIL_PLAN_IMPORT";
    }

    @Override
    public String getBusinessName() {
        return "TPM-活动细案明细导入";
    }

}
