package com.biz.crm.tpm.business.activity.detail.plan.local.imports;

import cn.hutool.core.collection.CollectionUtil;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.customer.channel.sdk.service.CustomerChannelVoService;
import com.biz.crm.mdm.business.customer.channel.sdk.vo.CustomerChannelVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.material.sdk.service.MaterialVoService;
import com.biz.crm.mdm.business.product.brand.sdk.service.ProductBrandService;
import com.biz.crm.mdm.business.product.brand.sdk.vo.ProductBrandVo;
import com.biz.crm.mdm.business.product.level.sdk.service.ProductLevelVoSdkService;
import com.biz.crm.mdm.business.product.level.sdk.vo.ProductLevelVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mdm.business.supplier.sdk.service.SupplierVoService;
import com.biz.crm.mdm.business.supplier.sdk.vo.SupplierVo;
import com.biz.crm.mdm.business.terminal.channel.sdk.service.MdmTerminalChannelVoService;
import com.biz.crm.mdm.business.terminal.channel.sdk.vo.MdmTerminalChannelVo;
import com.biz.crm.tpm.business.activity.detail.plan.local.imports.vo.ActivityDetailPlanDY00000008SupplyItemImportVo;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.internal.ActivityDetailPlanItemPageCacheHelper;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.RtmModelCodeEnum;
import com.biz.crm.tpm.business.activity.form.sdk.enums.ApplicationDimensionEnum;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormVo;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.TpmAuditTypeEnum;
import com.biz.crm.tpm.business.activity.type.sdk.service.ActivityTypeService;
import com.biz.crm.tpm.business.activity.type.sdk.vo.ActivityTypeVo;
import com.biz.crm.tpm.business.audit.business.sdk.service.AuditFormulaMainService;
import com.biz.crm.tpm.business.audit.business.sdk.vo.AuditFormulaMainVo;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.MonthBudgetGroupEnum;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 供应商活动细案-主体导入
 * @author baokai
 * @date 2023/9/19 15:42
 */
@Slf4j
@Component
public class ActivityDetailPlanDY00000008SupplyImportsProcess implements ImportProcess<ActivityDetailPlanDY00000008SupplyItemImportVo> {

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired
    private ActivityDetailPlanItemPageCacheHelper activityDetailPlanItemPageCacheHelper;

    @Autowired(required = false)
    private ActivityTypeService activityTypeService;
    @Autowired(required = false)
    private ActivityFormService activityFormService;
    @Autowired(required = false)
    private MonthBudgetService monthBudgetService;
    @Autowired(required = false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required = false)
    private CustomerVoService customerVoService;
    @Autowired(required = false)
    private MdmTerminalChannelVoService terminalChannelVoService;
    @Autowired(required = false)
    private ProductBrandService productBrandService;
    @Autowired(required = false)
    private ProductVoService productVoService;
    @Autowired(required = false)
    private ProductLevelVoSdkService productLevelVoSdkService;
    @Autowired(required = false)
    private SupplierVoService supplierVoService;
    @Autowired(required = false)
    private MaterialVoService materialVoService;
    @Autowired(required = false)
    private AuditFormulaMainService auditFormulaMainService;
    @Autowired(required = false)
    private DictDataVoService dictDataVoService;
    @Autowired(required = false)
    private CustomerChannelVoService customerChannelVoService;

    private final static String tpm_audit_type = "tpm_audit_type";//核销类型

    private final static String tpm_activity_import_template_mapping = "tpm_activity_import_template_mapping";//导入模板校验

    @Override
    public Map<Integer, String> execute(LinkedHashMap<Integer, ActivityDetailPlanDY00000008SupplyItemImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        try {
            Object cacheKeyObj = params.get("cacheKey");
            Validate.notNull(cacheKeyObj, "扩展参数cacheKey不能为空");
            String cacheKey = String.valueOf(cacheKeyObj);
            //有策略编码，从数据库里面查出来放到缓存里面
            String[] split1 = cacheKey.split(":");
            String templateCode = split1[split1.length - 1];//模板编码
            DictDataVo dictDataVo = dictDataVoService.findByDictTypeCodeAndDictCode(tpm_activity_import_template_mapping, templateCode);
            if (null == dictDataVo) {
                throw new RuntimeException("导入模板[" + templateCode + "]未在数据字典[tpm_activity_import_template_mapping]中配置");
            }
            if (!dictDataVo.getDictValue().equals(getTemplateCode())) {
                throw new RuntimeException("细案模板与导入模板请保持一致。");
            }

            Object businessFormatCodeObj = params.get("businessFormatCode");
            String businessFormatCode = null;
            if (null != businessFormatCodeObj) {
                businessFormatCode = businessFormatCodeObj.toString();
            }

            Object isSummary = params.get("isGather");
            Validate.notNull(isSummary, "扩展参数isSummary不能为空");
            Validate.isTrue(BooleanEnum.TRUE.getCapital().equals(isSummary) || BooleanEnum.FALSE.getCapital().equals(isSummary), "扩展参数isSummary只能为Y或N");
            Validate.isTrue(BooleanEnum.FALSE.getCapital().equals(isSummary), "供应商活动导入不支持汇总！");
            if (CollectionUtil.isEmpty(data)) {
                return null;
            }
            List<ActivityDetailPlanDY00000008SupplyItemImportVo> importVos = Lists.newArrayList(data.values());

            List<String> dictCodeList = Lists.newArrayList();
            dictCodeList.add(tpm_audit_type);

            Map<String, List<DictDataVo>> dictMap = dictDataVoService.findByDictTypeCodeList(dictCodeList);
            Map<String, Map<String, String>> dictMapMap = dictMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, item -> item.getValue().stream().collect(Collectors.toMap(DictDataVo::getDictValue, DictDataVo::getDictCode, (o, n) -> n)), (o, n) -> n));

            Set<String> activityTypeCodeSet = Sets.newHashSet();
            Set<String> activityFormCodeSet = Sets.newHashSet();
            Set<String> salesOrgCodeSet = Sets.newHashSet();
            Set<String> monthBudgetCodeSet = Sets.newHashSet();
            Set<String> customerCodeSet = Sets.newHashSet();
            Set<String> terminalChannelSet = Sets.newHashSet();
            Set<String> productBrandCodeSet = Sets.newHashSet();
            Set<String> productLevelCodeSet = Sets.newHashSet();
            Set<String> productCodeSet = Sets.newHashSet();
            Set<String> supplierCodeSet = Sets.newHashSet();
            Set<String> materialCodeSet = Sets.newHashSet();
            Set<String> auditFormulaCodeSet = Sets.newHashSet();
            Set<String> cusChannelCodeSet = Sets.newHashSet();

            for (ActivityDetailPlanDY00000008SupplyItemImportVo importVo : importVos) {
                if (StringUtils.isNotEmpty(importVo.getActivityTypeCode())) {
                    List<String> typeCodes = Arrays.asList(importVo.getActivityTypeCode().split(","));
                    activityTypeCodeSet.addAll(typeCodes);
                }
                if (StringUtils.isNotEmpty(importVo.getActivityFormCode())) {
                    List<String> formCodes = Arrays.asList(importVo.getActivityFormCode().split(","));
                    activityFormCodeSet.addAll(formCodes);
                }
                if (StringUtils.isNotBlank(importVo.getChannelCode())) {
                    cusChannelCodeSet.add(importVo.getChannelCode());
                }
                if (StringUtils.isNotEmpty(importVo.getSalesInstitutionCode())) {
                    Validate.notBlank(importVo.getChannelCode(), "渠道编码不能为空");
                    String insCode = importVo.getChannelCode() + businessFormatCode + importVo.getSalesInstitutionCode();
                    salesOrgCodeSet.add(insCode);
                    if (StringUtils.isNotBlank(importVo.getSalesRegionCode())) {
                        String regionCode = insCode + importVo.getSalesRegionCode();
                        salesOrgCodeSet.add(regionCode);
                        if (StringUtils.isNotEmpty(importVo.getSalesOrgCode())) {
                            String salesOrgCode = regionCode + importVo.getSalesOrgCode();
                            salesOrgCodeSet.add(salesOrgCode);
                        }
                    }
                }

                if (StringUtils.isNotEmpty(importVo.getHeadMonthBudgetCode())) {
                    monthBudgetCodeSet.add(importVo.getHeadMonthBudgetCode());
                }
                if (StringUtils.isNotEmpty(importVo.getMonthBudgetCode())) {
                    monthBudgetCodeSet.add(importVo.getMonthBudgetCode());
                }
                if (StringUtils.isNotEmpty(importVo.getCustomerCode())) {
                    Validate.notBlank(importVo.getChannelCode(), "渠道编码不能为空");
                    Validate.notBlank(importVo.getSalesInstitutionCode(), "销售机构编码不能为空");
                    customerCodeSet.add(importVo.getCustomerCode() + importVo.getSalesInstitutionCode() + importVo.getChannelCode() + businessFormatCode);
                }
                if (StringUtils.isNotEmpty(importVo.getFirstChannelCode())) {
                    terminalChannelSet.add(importVo.getFirstChannelCode());
                }
                if (StringUtils.isNotEmpty(importVo.getSecondChannelCode())) {
                    terminalChannelSet.add(importVo.getSecondChannelCode());
                }
                if (StringUtils.isNotEmpty(importVo.getAuditConditionCode())) {
                    auditFormulaCodeSet.add(importVo.getAuditConditionCode());
                }
            }

            Map<String, String> activityTypeMap = Maps.newHashMap();
            Map<String, ActivityFormVo> activityFormMap = Maps.newHashMap();
            Map<String, SalesOrgVo> salesOrgMap = Maps.newHashMap();
            Map<String, MonthBudgetVo> monthBudgetMap = Maps.newHashMap();
            Map<String, CustomerVo> customerMap = Maps.newHashMap();
            Map<String, String> terminalChannelMap = Maps.newHashMap();
            Map<String, SupplierVo> supplierMap = Maps.newHashMap();
            Map<String, String> productBrandMap = Maps.newHashMap();
            Map<String, String> productLevelMap = Maps.newHashMap();
            Map<String, ProductVo> productMap = Maps.newHashMap();
            Map<String, AuditFormulaMainVo> auditFormulaMap = Maps.newHashMap();
            Map<String, CustomerChannelVo> cusChannelMap = Maps.newHashMap();

            if (!CollectionUtils.isEmpty(activityTypeCodeSet)) {
                List<ActivityTypeVo> activityTypeList = activityTypeService.findByCodes(Lists.newArrayList(activityTypeCodeSet));
                activityTypeMap = activityTypeList.stream().collect(Collectors.toMap(ActivityTypeVo::getActivityTypeCode, ActivityTypeVo::getActivityTypeName, (o, n) -> n));
            }
            if (!CollectionUtils.isEmpty(activityFormCodeSet)) {
                List<String> activityFormCodeList = Lists.newArrayList(activityFormCodeSet);
                List<ActivityFormVo> activityFormVos = activityFormService.findByCodes(activityFormCodeList);
                activityFormMap = activityFormVos.stream().collect(Collectors.toMap(ActivityFormVo::getActivityFormCode, Function.identity(), (o, n) -> n));
            }
            if (!CollectionUtils.isEmpty(cusChannelCodeSet)) {
                List<CustomerChannelVo> channelVos = customerChannelVoService.findByCodes(new ArrayList<>(cusChannelCodeSet));
                if (!CollectionUtils.isEmpty(channelVos)) {
                    cusChannelMap = channelVos.stream().collect(Collectors.toMap(CustomerChannelVo::getCustomerChannelCode, Function.identity(), (o, n) -> n));
                }
            }
            if (!CollectionUtils.isEmpty(salesOrgCodeSet)) {
                List<SalesOrgVo> salesOrgVos = salesOrgVoService.findBySalesOrgCodes(Lists.newArrayList(salesOrgCodeSet));
                if (!CollectionUtils.isEmpty(salesOrgVos)) {
                    salesOrgMap = salesOrgVos.stream().collect(Collectors.toMap(SalesOrgVo::getSalesOrgCode, Function.identity(), (o, n) -> n));
                }
            }
            if (!CollectionUtils.isEmpty(monthBudgetCodeSet)) {
                List<MonthBudgetVo> monthBudgetVos = monthBudgetService.listByCodes(Lists.newArrayList(monthBudgetCodeSet));
                monthBudgetMap = monthBudgetVos.stream().collect(Collectors.toMap(MonthBudgetVo::getMonthBudgetCode, Function.identity(), (o, n) -> n));
            }
            if (!CollectionUtils.isEmpty(terminalChannelSet)) {
                List<MdmTerminalChannelVo> mdmTerminalChannelVos = terminalChannelVoService.listByCodes(Lists.newArrayList(terminalChannelSet));
                terminalChannelMap = mdmTerminalChannelVos.stream().collect(Collectors.toMap(MdmTerminalChannelVo::getTerminalChannelCode, MdmTerminalChannelVo::getTerminalChannelName, (o, n) -> n));
            }
            if (!CollectionUtils.isEmpty(supplierCodeSet)){
                List<SupplierVo> supplierVos = supplierVoService.findBySupplierCodes(Lists.newArrayList(supplierCodeSet));
                supplierMap = supplierVos.stream().collect(Collectors.toMap(SupplierVo::getSupplierCode,Function.identity()));
            }
            if (!CollectionUtils.isEmpty(productBrandCodeSet)) {
                List<ProductBrandVo> productBrandVos = productBrandService.listByCodes(Lists.newArrayList(productBrandCodeSet));
                productBrandMap = productBrandVos.stream().collect(Collectors.toMap(ProductBrandVo::getProductBrandCode, ProductBrandVo::getProductBrandName, (o, n) -> n));
            }
            if (!CollectionUtils.isEmpty(productLevelCodeSet)) {
                List<ProductLevelVo> productLevelVos = productLevelVoSdkService.findListByBusinessFormatAndCodes(businessFormatCode, Lists.newArrayList(productLevelCodeSet));
                productLevelMap = productLevelVos.stream().collect(Collectors.toMap(item -> {
                    return item.getProductLevelType() + item.getProductLevelCode();
                }, ProductLevelVo::getProductLevelName, (o, n) -> n));
            }
            if (!CollectionUtils.isEmpty(productCodeSet)) {
                List<ProductVo> productVos = productVoService.findByCodes(Lists.newArrayList(productCodeSet));
                productMap = productVos.stream().collect(Collectors.toMap(ProductVo::getProductCode, Function.identity(), (o, n) -> n));
            }
            if (!CollectionUtils.isEmpty(customerCodeSet)) {
                List<String> customerCodeList = Lists.newArrayList(customerCodeSet);
                List<CustomerVo> customerVos = customerVoService.findBaseByCustomerCodes(customerCodeList);
                customerMap = customerVos.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, Function.identity(), (o, n) -> n));
            }

            if (!CollectionUtils.isEmpty(auditFormulaCodeSet)) {
                List<AuditFormulaMainVo> auditFormulaList = auditFormulaMainService.findByCodeList(Lists.newArrayList(auditFormulaCodeSet));
                if (!CollectionUtils.isEmpty(auditFormulaList)) {
                    auditFormulaMap = auditFormulaList.stream().collect(Collectors.toMap(AuditFormulaMainVo::getAuditFormulaCode, Function.identity(), (o, n) -> n));
                }
            }

            List<ActivityDetailPlanItemDto> newList = Lists.newArrayList();
            for (ActivityDetailPlanDY00000008SupplyItemImportVo importVo : importVos) {
                ActivityDetailPlanItemDto itemDto = nebulaToolkitService.copyObjectByWhiteList(importVo, ActivityDetailPlanItemDto.class, HashSet.class, ArrayList.class);

                validateAndConvertDictData(dictMapMap, tpm_audit_type, importVo.getAuditType(), itemDto::setAuditType, "核销类型");
                //活动分类
                if (StringUtils.isNotEmpty(importVo.getActivityTypeCode())) {
                    String[] codes = importVo.getActivityTypeCode().split(",");
                    LinkedList<String> allNames = new LinkedList<>();
                    for (String code : codes) {
                        String activityTypeName = activityTypeMap.get(code);
                        if (StringUtils.isEmpty(activityTypeName)) {
                            throw new RuntimeException("活动分类[" + code + "]有误");
                        } else {
                            allNames.add(activityTypeName);
                        }
                    }
                    itemDto.setActivityType(importVo.getActivityTypeCode());
                    itemDto.setActivityTypeName(String.join(",", allNames));
                }

                //活动形式
                if (StringUtils.isNotEmpty(importVo.getActivityFormCode())) {
                    boolean customerNotEmpty = false;
                    boolean terminalNotEmpty = false;
                    boolean orgNotEmpty = false;
                    String[] codes = importVo.getActivityFormCode().split(",");
                    LinkedList<String> allNames = new LinkedList<>();
                    for (String code : codes) {
                        ActivityFormVo activityFormVo = activityFormMap.get(code);
                        if (null == activityFormVo) {
                            throw new RuntimeException("活动形式[" + code + "]有误");
                        } else {
                            allNames.add(activityFormVo.getActivityFormName());
                            if (StringUtils.isNotEmpty(activityFormVo.getApplyDimensionality())) {
                                if (activityFormVo.getApplyDimensionality().contains(ApplicationDimensionEnum.ORG.getCode())) {
                                    orgNotEmpty = true;
                                }
                                if (activityFormVo.getApplyDimensionality().contains(ApplicationDimensionEnum.CUSTOMER.getCode())) {
                                    customerNotEmpty = true;
                                }
                                if (activityFormVo.getApplyDimensionality().contains(ApplicationDimensionEnum.TERMINAL.getCode())) {
                                    terminalNotEmpty = true;
                                }
                            }
                        }
                    }
                    itemDto.setActivityForm(importVo.getActivityFormCode());
                    itemDto.setActivityFormName(String.join(",", allNames));
                    if (customerNotEmpty && StringUtils.isEmpty(importVo.getCustomerCode())) {
                        throw new RuntimeException("活动形式[" + importVo.getActivityFormCode() + "]客户不能为空");
                    }
                }


                //核销条件（核销公式）
                if (StringUtils.isNotEmpty(importVo.getAuditConditionCode())) {
                    AuditFormulaMainVo auditFormula = auditFormulaMap.get(importVo.getAuditConditionCode());
                    if (auditFormula == null) {
                        throw new RuntimeException("核销条件[" + importVo.getAuditConditionCode() + "]有误");
                    }
                    itemDto.setAuditConditionName(auditFormula.getAuditFormulaName());
                } else {
                    Validate.isTrue(!TpmAuditTypeEnum.AUDITTYPE2.getCode().equals(importVo.getAuditType()), "核销条件编码必填");
                }

                if (StringUtils.isNotEmpty(importVo.getHeadMonthBudgetCode())) {
                    MonthBudgetVo monthBudgetVo = monthBudgetMap.get(importVo.getHeadMonthBudgetCode());
                    if (null == monthBudgetVo) {
                        throw new RuntimeException("总部费用预算编码" + importVo.getHeadMonthBudgetCode() + "有误");
                    }
                    if (!MonthBudgetGroupEnum.organization.getCode().equals(monthBudgetVo.getGroupCode())) {
                        throw new RuntimeException("月度预算[" + monthBudgetVo.getMonthBudgetCode() + "],必须为部门分组");
                    }
                    itemDto.setHeadBudgetItemCode(monthBudgetVo.getBudgetItemCode());
                    itemDto.setHeadBudgetItemName(monthBudgetVo.getBudgetItemName());
                }
                if (StringUtils.isNotEmpty(importVo.getMonthBudgetCode())) {
                    MonthBudgetVo monthBudgetVo = monthBudgetMap.get(importVo.getMonthBudgetCode());
                    if (null == monthBudgetVo) {
                        throw new RuntimeException("大区自控预算编码" + importVo.getHeadMonthBudgetCode() + "有误");
                    }
                    if (!MonthBudgetGroupEnum.organization.getCode().equals(monthBudgetVo.getGroupCode())) {
                        throw new RuntimeException("月度预算[" + monthBudgetVo.getMonthBudgetCode() + "],必须为部门分组");
                    }
                    itemDto.setBudgetItemCode(monthBudgetVo.getBudgetItemCode());
                    itemDto.setBudgetItemName(monthBudgetVo.getBudgetItemName());
                }

                //渠道
                if (StringUtils.isNotEmpty(importVo.getChannelCode())) {
                    CustomerChannelVo channelVo = cusChannelMap.get(importVo.getChannelCode());
                    if (null == channelVo) {
                        throw new RuntimeException("渠道编码" + importVo.getChannelCode() + "有误");
                    }
                    itemDto.setDistributionChannelCode(channelVo.getCustomerChannelCode());
                    itemDto.setDistributionChannelName(channelVo.getCustomerChannelName());
                }

                if (StringUtils.isNotEmpty(importVo.getCustomerCode())) {
                    String cusCode = importVo.getCustomerCode() + importVo.getSalesInstitutionCode() + importVo.getChannelCode() + businessFormatCode;
                    CustomerVo customerVo = customerMap.get(cusCode);
                    if (null == customerVo) {
                        throw new RuntimeException("客户编码" + importVo.getCustomerCode() + "有误");
                    }
                    itemDto.setCustomerName(customerVo.getCustomerName());
                    itemDto.setCustomerCode(customerVo.getCustomerCode());
                    itemDto.setCustomerErpCode(customerVo.getErpCode());
                    itemDto.setSalesInstitutionCode(customerVo.getSalesInstitutionCode());
                    itemDto.setSalesInstitutionName(customerVo.getSalesInstitutionName());
                    itemDto.setSalesInstitutionErpCode(customerVo.getSalesInstitutionErpCode());
                    itemDto.setSalesRegionCode(customerVo.getSalesRegionCode());
                    itemDto.setSalesRegionName(customerVo.getSalesRegionName());
                    itemDto.setSalesRegionErpCode(customerVo.getSalesRegionErpCode());
                    itemDto.setSalesOrgCode(customerVo.getSalesOrgCode());
                    itemDto.setSalesOrgName(customerVo.getSalesOrgName());
                    itemDto.setSalesOrgErpCode(customerVo.getSalesOrgErpCode());
                }

                //一级渠道
                if (StringUtils.isNotEmpty(importVo.getFirstChannelCode())) {
                    String terminalChannelName = terminalChannelMap.get(importVo.getFirstChannelCode());
                    if (StringUtils.isEmpty(terminalChannelName)) {
                        throw new RuntimeException("一级渠道[" + importVo.getFirstChannelCode() + "]有误");
                    }
                    itemDto.setFirstChannelCode(importVo.getFirstChannelCode());
                    itemDto.setFirstChannelName(terminalChannelName);
                }

                //二级渠道
                if (StringUtils.isNotEmpty(importVo.getSecondChannelCode())) {
                    String terminalChannelName = terminalChannelMap.get(importVo.getSecondChannelCode());
                    if (StringUtils.isEmpty(terminalChannelName)) {
                        throw new RuntimeException("二级渠道[" + importVo.getSecondChannelCode() + "]有误");
                    }
                    itemDto.setSecondChannelCode(importVo.getSecondChannelCode());
                    itemDto.setSecondChannelName(terminalChannelName);
                }

                //销售机构
                if (StringUtils.isNotEmpty(importVo.getSalesInstitutionCode())) {
                    String insCode = importVo.getChannelCode() + businessFormatCode + importVo.getSalesInstitutionCode();
                    SalesOrgVo salesOrgVo = salesOrgMap.get(insCode);
                    if (null == salesOrgVo) {
                        throw new RuntimeException("销售机构编码[" + importVo.getSalesInstitutionCode() + "]有误");
                    }
                    itemDto.setSalesInstitutionCode(salesOrgVo.getSalesOrgCode());
                    itemDto.setSalesInstitutionName(salesOrgVo.getSalesOrgName());
                    itemDto.setSalesInstitutionErpCode(salesOrgVo.getErpCode());
                    if (StringUtils.isEmpty(importVo.getSalesOrgCode())) {
                        itemDto.setActivityOrgCode(itemDto.getSalesInstitutionCode());
                        itemDto.setActivityOrgName(itemDto.getSalesInstitutionName());
                        itemDto.setActivityOrgErpCode(itemDto.getSalesInstitutionErpCode());
                    }
                    //销售部门
                    if (StringUtils.isNotEmpty(importVo.getSalesRegionCode())) {
                        String regionCode = insCode + importVo.getSalesRegionCode();
                        SalesOrgVo salesOrgVo2 = salesOrgMap.get(regionCode);
                        if (null == salesOrgVo2) {
                            throw new RuntimeException("销售大区编码[" + importVo.getSalesRegionCode() + "]有误");
                        }
                        itemDto.setSalesRegionCode(salesOrgVo2.getSalesOrgCode());
                        itemDto.setSalesRegionErpCode(salesOrgVo2.getErpCode());
                        itemDto.setSalesRegionName(salesOrgVo2.getSalesOrgName());
                        if (StringUtils.isEmpty(importVo.getSalesOrgCode())) {
                            itemDto.setActivityOrgCode(itemDto.getSalesRegionCode());
                            itemDto.setActivityOrgName(itemDto.getSalesRegionName());
                            itemDto.setActivityOrgErpCode(itemDto.getSalesRegionErpCode());
                        }
                        //销售组
                        if (StringUtils.isNotEmpty(importVo.getSalesOrgCode())) {
                            if (StringUtils.isEmpty(itemDto.getSalesRegionCode())) {
                                throw new RuntimeException("省区编码[" + importVo.getSalesOrgCode() + "]未获取到销售大区");
                            }
                            String salesCode = itemDto.getSalesRegionCode() + importVo.getSalesOrgCode();
                            SalesOrgVo salesOrgVo3 = salesOrgMap.get(salesCode);
                            if (null == salesOrgVo3) {
                                throw new RuntimeException("省区编码[" + importVo.getSalesOrgCode() + "]有误");
                            }
                            itemDto.setSalesOrgCode(salesOrgVo3.getSalesOrgCode());
                            itemDto.setSalesOrgErpCode(salesOrgVo.getErpCode());
                            itemDto.setSalesOrgName(salesOrgVo.getSalesOrgName());
                            itemDto.setActivityOrgCode(itemDto.getSalesOrgCode());
                            itemDto.setActivityOrgName(itemDto.getSalesOrgName());
                            itemDto.setActivityOrgErpCode(itemDto.getSalesOrgErpCode());
                        }
                    }
                }
                //供应商
                if (StringUtils.isNotEmpty(importVo.getSupplierCode())) {
                    SupplierVo supplierVo = supplierMap.get(importVo.getSupplierCode());
                    if (null == supplierVo) {
                        throw new RuntimeException("供应商[" + importVo.getSupplierCode() + "]有误");
                    }
                    itemDto.setSupplierCode(supplierVo.getSupplierCode());
                    itemDto.setSupplierName(supplierVo.getSupplierName());
                }

                //校验活动分类，形式
                if (StringUtils.isNotEmpty(importVo.getActivityFormCode())) {
                    String[] split = importVo.getActivityFormCode().split(",");
                    for (String str : split) {
                        List<ActivityTypeVo> activityTypeByActivityFormCode = activityTypeService.getActivityTypeByActivityFormCode(str);
                        activityTypeByActivityFormCode.forEach(act -> {
                            if (StringUtils.isNotEmpty(importVo.getActivityTypeCode())) {
                                String[] actType = importVo.getActivityTypeCode().split(",");
                                if (!Arrays.asList(actType).contains(act.getActivityTypeCode())) {
                                    throw new RuntimeException("活动形式需在活动分类下，请检查数据填写是否正确");
                                }
                            } else {
                                throw new RuntimeException("活动形式需在活动分类下，请检查数据填写是否正确");
                            }
                        });
                    }
                }
                //校验必填项
                if (StringUtils.isNotEmpty(importVo.getHeadMonthBudgetCode())) {
                    if (StringUtils.isEmpty(importVo.getHeadFeeAmountStr())) {
                        throw new RuntimeException("总部承担金额不能为空，请检查数据填写是否正确");
                    }
                }
                if (StringUtils.isNotEmpty(importVo.getMonthBudgetCode())) {
                    if (StringUtils.isEmpty(importVo.getDepartmentFeeAmountStr())) {
                        throw new RuntimeException("大区承担金额不能为空，请检查数据填写是否正确");
                    }
                }
                //点外金额
                if (StringUtils.isNotEmpty(importVo.getCustomerCode())) {
                    String cusCode = importVo.getCustomerCode() + importVo.getSalesInstitutionCode() + importVo.getChannelCode() + businessFormatCode;
                    CustomerVo customerVo = customerMap.get(cusCode);
                    Validate.notNull(customerVo, "客户编码[" + importVo.getCustomerCode() + "]有误");
                    String rtmModelCode = customerVo.getRtmModelCode();
                    if (StringUtils.isNotEmpty(rtmModelCode)) {
                        if (rtmModelCode.equals(RtmModelCodeEnum.SON_COMPANY.getCode())) {
                            BigDecimal headFeeAmountStr = new BigDecimal(0);
                            BigDecimal departmentFeeAmountStr = new BigDecimal(0);
                            BigDecimal intraCompanyAmountStr = new BigDecimal(0);
                            BigDecimal offPointAmountStr = new BigDecimal(0);
                            if (StringUtils.isNotEmpty(importVo.getHeadFeeAmountStr())) {
                                //总部承担金额
                                try {
                                    headFeeAmountStr = new BigDecimal(importVo.getHeadFeeAmountStr());
                                } catch (NumberFormatException e) {
                                    throw new IllegalArgumentException("总部承担金额【" + importVo.getHeadFeeAmountStr() + "】数字转换异常");
                                }
                            }
                            if (StringUtils.isNotEmpty(importVo.getDepartmentFeeAmountStr())) {
                                //大区承担金额
                                try {
                                    departmentFeeAmountStr = new BigDecimal(importVo.getDepartmentFeeAmountStr());
                                } catch (NumberFormatException e) {
                                    throw new IllegalArgumentException("大区承担金额【" + importVo.getDepartmentFeeAmountStr() + "】数字转换异常");
                                }
                            }
                            if (StringUtils.isNotEmpty(importVo.getIntraCompanyAmountStr())) {
                                //分子公司点内金额
                                try {
                                    intraCompanyAmountStr = new BigDecimal(importVo.getIntraCompanyAmountStr());
                                } catch (NumberFormatException e) {
                                    throw new IllegalArgumentException("分子公司点内金额【" + importVo.getIntraCompanyAmountStr() + "】数字转换异常");
                                }
                            }
                            if (StringUtils.isNotEmpty(importVo.getOffPointAmountStr())) {
                                //分子公司点外金额
                                try {
                                    offPointAmountStr = new BigDecimal(importVo.getOffPointAmountStr());
                                } catch (NumberFormatException e) {
                                    throw new IllegalArgumentException("分子公司点外金额【" + importVo.getOffPointAmountStr() + "】数字转换异常");
                                }
                            }
                            BigDecimal subtract = headFeeAmountStr.add(departmentFeeAmountStr).subtract(intraCompanyAmountStr);
                            if (subtract.compareTo(offPointAmountStr) != 0) {
                                throw new RuntimeException("分子公司点外金额=总部承担金额+大区承担金额-分子公司点内金额，请检查数据填写是否正确");
                            }
                        } else if (rtmModelCode.equals(RtmModelCodeEnum.DEALER.getCode())) {
                            if (StringUtils.isNotEmpty(importVo.getIntraCompanyAmountStr()) && StringUtils.isNotEmpty(importVo.getOffPointAmountStr())) {
                                throw new RuntimeException("分子公司点外金额与分子公司点内金额必须为空，请检查数据填写是否正确");
                            }
                            if (StringUtils.isNotEmpty(importVo.getIntraCompanyAmountStr())) {
                                throw new RuntimeException("分子公司点内金额必须为空，请检查数据填写是否正确");
                            }
                            if (StringUtils.isNotEmpty(importVo.getOffPointAmountStr())) {
                                throw new RuntimeException("分子公司点外金额必须为空，请检查数据填写是否正确");
                            }
                        }
                    }
                }

                newList.add(itemDto);
            }


            this.activityDetailPlanItemPageCacheHelper.importNewItem(cacheKey.toString(), newList);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            String errorMsg = e.getMessage();
            if (StringUtils.isEmpty(e.getMessage())) {
                errorMsg = "数据处理失败！";
            }
            throw new IllegalArgumentException(errorMsg);
        }
        return null;
    }

    public void validateAndConvertDictData(Map<String, Map<String, String>> dictMap, String dictTypeCode, String dictValue, Consumer<String> setMethod, String desc) {
        if (StringUtils.isEmpty(dictValue)) {
            return;
        }
        Map<String, String> dictDataMap = dictMap.get(dictTypeCode);
        String dictCode = dictDataMap.get(dictValue);
        if (StringUtils.isEmpty(dictCode)) {
            throw new RuntimeException(desc + "[" + dictValue + "]有误");
        }
        setMethod.accept(dictCode);
    }

    @Override
    public Class<ActivityDetailPlanDY00000008SupplyItemImportVo> findCrmExcelVoClass() {
        return ActivityDetailPlanDY00000008SupplyItemImportVo.class;
    }

    @Override
    public String getTemplateCode() {
        return "TPM_DETAIL_ACTIVITY_PLAN_IMPORT_DY00000008_SUPPLY";
    }

    @Override
    public String getTemplateName() {
        return "供应商活动细案导入模板（主体）";
    }
    @Override
    public String getBusinessCode() {
        return "TPM_ACTIVITY_DETAIL_PLAN_IMPORT";
    }

    @Override
    public String getBusinessName() {
        return "TPM-活动细案明细导入";
    }
}
