package com.biz.crm.tpm.business.activity.detail.plan.local.imports;

import cn.hutool.core.collection.CollectionUtil;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.tpm.business.activity.detail.plan.local.imports.vo.ActivityDetailPlanItemImportVo;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.ActivityDetailPlanItemService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.*;

/**
 * 活动细案明细导入服务-通用
 * @author wanghaojia
 * @date 2022/11/11 16:19
 */
@Slf4j
@Component
public class ActivityDetailPlanImportsProcess implements ImportProcess<ActivityDetailPlanItemImportVo> {

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired
    private ActivityDetailPlanItemService activityDetailPlanItemService;


    @Override
    public Map<Integer, String> execute(LinkedHashMap<Integer, ActivityDetailPlanItemImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        if (CollectionUtil.isNotEmpty(data)){
            Collection<ActivityDetailPlanItemImportVo> importVos = data.values();
            if (CollectionUtil.isNotEmpty(importVos)){
                Collection<ActivityDetailPlanItemDto> itemDtoCollection = nebulaToolkitService.copyCollectionByWhiteList(importVos, ActivityDetailPlanItemImportVo.class, ActivityDetailPlanItemDto.class, HashSet.class, ArrayList.class);
                this.activityDetailPlanItemService.addItemCache(UUID.randomUUID().toString(),Lists.newArrayList(itemDtoCollection));
            }
        }
        return null;
    }

    @Override
    public Class<ActivityDetailPlanItemImportVo> findCrmExcelVoClass() {
        return ActivityDetailPlanItemImportVo.class;
    }

    @Override
    public String getTemplateCode() {
        return "TPM_DETAIL_ACTIVITY_PLAN_IMPORT_COMMON";
    }

    @Override
    public String getTemplateName() {
        return "TPM-活动细案明细导入-通用";
    }

    @Override
    public String getBusinessCode() {
        return "TPM_ACTIVITY_DETAIL_PLAN_IMPORT";
    }

    @Override
    public String getBusinessName() {
        return "TPM-活动细案明细导入";
    }

}
