package com.biz.crm.tpm.business.activity.detail.plan.local.imports.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 活动细案明细-主体-销售费用导入VO
 *
 * @author wanghaojia
 * @date 2023/1/11 14:17
 */
@Data
@CrmExcelImport(startRow = 2)
@ApiModel("活动细案明细-主体-销售费用导入VO")
public class ActivityDetailPlanDY00000008SalesItemImportVo extends CrmExcelVo {

    /**
     * 活动类型编码
     */
    @ApiModelProperty("活动类型编码")
    @CrmExcelColumn(value = "* 活动分类编码")
    private String activityTypeCode;
    /**
     * 活动类型名称
     */
    @ApiModelProperty("活动类型名称")
    @CrmExcelColumn(value = "活动分类")
    private String activityTypeName;

    /**
     * 活动形式编码
     */
    @ApiModelProperty("活动形式编码")
    @CrmExcelColumn(value = "* 活动形式编码")
    private String activityFormCode;
    /**
     * 活动形式名称
     */
    @ApiModelProperty("活动形式名称")
    @CrmExcelColumn(value = "活动形式")
    private String activityFormName;


    /**
     * 活动开始时间-字符串，前端传
     */
    @ApiModelProperty("活动开始时间-字符串，前端传")
    @CrmExcelColumn(value = "* 活动开始时间")
    private String activityBeginDateStr;

    /**
     * 活动结束时间-字符串，前端传
     */
    @CrmExcelColumn(value = "* 活动结束时间")
    private String activityEndDateStr;

    /**
     * 订单开始时间-字符串，前端用
     */
    @ApiModelProperty("订单开始时间-字符串，前端用")
    @CrmExcelColumn(value = "订单开始日期")
    private String orderBeginDateStr;

    /**
     * 订单开始时间-字符串，前端用
     */
    @ApiModelProperty("订单开始时间-字符串，前端用")
    @CrmExcelColumn(value = "订单结束日期")
    private String orderEndDateStr;

    /**
     * 总部预算编码
     */
    @ApiModelProperty("总部预算编码")
    @CrmExcelColumn(value = "总部统筹预算编码")
    private String headMonthBudgetCode;

    /**
     * 总部预算编码
     */
    @ApiModelProperty("总部预算编码")
    @CrmExcelColumn(value = "总部统筹预算名称")
    private String headBudgetItemName;
    /**
     * 大区预算编码
     */
    @ApiModelProperty("预算编码/大区预算编码")
    @CrmExcelColumn(value = "大区自控预算编码")
    private String monthBudgetCode;
    /**
     * 大区预算项目名称
     */
    @ApiModelProperty("大区预算项目名称")
    @CrmExcelColumn(value = "大区自控预算名称")
    private String budgetItemName;

    /**
     * 渠道编码
     */
    @ApiModelProperty("渠道编码")
    @CrmExcelColumn(value = "渠道编码")
    private String channelCode;

    /**
     * 销售机构编码
     */
    @ApiModelProperty("销售机构编码")
    @CrmExcelColumn(value = "销售机构编码")
    private String salesInstitutionCode;

    /**
     * 区域编码
     */
    @ApiModelProperty("大区")
    @CrmExcelColumn(value = "大区")
    private String salesRegionCode;
    /**
     * 区域名称
     */
    @ApiModelProperty("省区")
    @CrmExcelColumn(value = "省区")
    private String salesOrgCode;
    /**
     * 一级管理渠道
     */
    @ApiModelProperty("一级管理渠道编码")
    @CrmExcelColumn(value = "一级渠道编码")
    private String firstChannelCode;

    /**
     * 一级管理渠道名称
     */
    @ApiModelProperty("一级管理渠道名称")
    @CrmExcelColumn(value = "一级渠道名称")
    private String firstChannelName;
    /**
     * 二级管理渠道
     */
    @ApiModelProperty("二级管理渠道")
    @CrmExcelColumn(value = "二级渠道编码")
    private String secondChannelCode;
    /**
     * 二级管理渠道名称
     */
    @ApiModelProperty("二级管理渠道名称")
    @CrmExcelColumn(value = "二级渠道名称")
    private String secondChannelName;
    /**
     * 零售商
     */
    @ApiModelProperty(name = "零售商", notes = "零售商")
    @CrmExcelColumn(value = "零售商编码")
    private String systemCode;
    /**
     * 零售商名称
     */
    @ApiModelProperty(name = "零售商名称", notes = "零售商名称")
    @CrmExcelColumn(value = "零售商名称")
    private String systemName;

    /**
     * 客户编码
     */
    @ApiModelProperty("客户编码")
    @CrmExcelColumn(value = "* 客户编码")
    private String customerCode;
    /**
     * 客户名称
     */
    @ApiModelProperty("客户名称")
    @CrmExcelColumn(value = "客户名称")
    private String customerName;


    /**
     * 品牌编码
     */
    @ApiModelProperty("品牌编码")
    @CrmExcelColumn(value = "品牌编码")
    private String productBrandCode;
    /**
     * 品牌名称
     */
    @ApiModelProperty("品牌名称")
    @CrmExcelColumn(value = "品牌名称")
    private String productBrandName;
    /**
     * 品类编码
     */
    @ApiModelProperty("品类编码")
    @CrmExcelColumn(value = "品类编码")
    private String productCategoryCode;
    /**
     * 品类名称
     */
    @ApiModelProperty("品类名称")
    @CrmExcelColumn(value = "品类名称")
    private String productCategoryName;
    /**
     * 品项编码
     */
    @ApiModelProperty("品项编码")
    @CrmExcelColumn(value = "品项编码")
    private String productItemCode;
    /**
     * 品项名称
     */
    @ApiModelProperty("品项名称")
    @CrmExcelColumn(value = "品项名称")
    private String productItemName;
    /**
     * 产品编码
     */
    @ApiModelProperty("产品编码")
    @CrmExcelColumn(value = "产品编码")
    private String productCode;
    /**
     * 产品名称
     */
    @ApiModelProperty("产品名称")
    @CrmExcelColumn(value = "产品名称")
    private String productName;

    /**
     * 赠品价格
     */
    @ApiModelProperty("赠品编码")
    @CrmExcelColumn(value = "赠品编码")
    private String giftCode;

    /**
     * 赠品名称
     */
    @ApiModelProperty("赠品名称")
    @CrmExcelColumn(value = "赠品名称")
    private String giftName;

    /**
     * 赠品价格
     */
    @ApiModelProperty("赠品价格")
    @CrmExcelColumn(value = "赠品价格")
    private String giftPriceStr;

    /**
     * 原品数量
     */
    @ApiModelProperty("原品数量")
    @CrmExcelColumn(value = "原品数量")
    private String productQuantityStr;

    /**
     * 赠品数量
     */
    @ApiModelProperty("赠品数量")
    @CrmExcelColumn(value = "赠品数量")
    private String giftQuantityStr;

    /**
     * 赠品总量
     */
    @ApiModelProperty("赠品总量")
    @CrmExcelColumn(value = "赠品总量")
    private String giftWeightStr;



    /**
     * 月销售任务-字符串，前端用
     */
    @ApiModelProperty("月销售任务-字符串，前端用")
    @CrmExcelColumn(value = "月销售任务（元）")
    private String monthSalesTargetStr;

    /**
     * 目前铺市率-字符串，前端用
     */
    @ApiModelProperty("目前铺市率-字符串，前端用")
    @CrmExcelColumn(value = "目前铺市率")
    private String currentMarketRateStr;
    /**
     * 月目标铺市率-字符串，前端用
     */
    @ApiModelProperty("月目标铺市率-字符串，前端用")
    @CrmExcelColumn(value = "月目标铺市率")
    private String monthTargetMarketRateStr;
    /**
     * 是否发起巡查需求
     */
    @ApiModelProperty("是否发起巡查需求")
    @CrmExcelColumn(value = "是否发起巡查需求")
    private String isStartPatrol;
    /**
     * 期间促销量（件）-字符串，前端用
     */
    @ApiModelProperty("期间促销量（件）-字符串，前端用")
    @CrmExcelColumn(value = "期间促销量（件）")
    private String periodPromoteQuantityStr;
    /**
     * 期间促销额（元）-字符串，前端用
     */
    @ApiModelProperty("期间促销额（元）-字符串，前端用")
    @CrmExcelColumn(value = "期间促销额（元）")
    private String periodPromoteAmountStr;

    /**
     * 期间渠道促销量（件）-字符串，前端用
     */
    @ApiModelProperty("期间渠道促销量（件）-字符串，前端用")
    @CrmExcelColumn(value = "期间渠道促销量（件）")
    private String periodChPromoteQuantityStr;
    /**
     * 期间渠道促销额（元）-字符串，前端用
     */
    @ApiModelProperty("期间渠道促销额（元）-字符串，前端用")
    @CrmExcelColumn(value = "期间渠道促销额（元）")
    private String periodChPromoteAmountStr;
    /**
     * 全月回复量（件）-字符串，前端用
     */
    @ApiModelProperty("全月回复量（件）-字符串，前端用")
    @CrmExcelColumn(value = "全月回复量（件）")
    private String monthReturnQuantityStr;
    /**
     * 全月回复额（元）-字符串，前端用
     */
    @ApiModelProperty("全月回复额（元）-字符串，前端用")
    @CrmExcelColumn(value = "全月回复额（元）")
    private String monthReturnAmountStr;

    /**
     * 本月投入产出比-字符串，前端用
     */
    @ApiModelProperty("本月投入产出比-字符串，前端用")
    @CrmExcelColumn(value = "本月投入产出比（%）")
    private String monthPutOutputRatioStr;

    @ApiModelProperty("门店编码")
    @CrmExcelColumn(value = "门店编码")
    private String terminalCode;

    @ApiModelProperty("门店名称")
    @CrmExcelColumn(value = "门店名称")
    private String terminalName;

    @ApiModelProperty("门店类型")
    @CrmExcelColumn(value = "门店类型")
    private String terminalType;

    @ApiModelProperty("堆头陈列数量（个/月）")
    @CrmExcelColumn(value = "堆头陈列数量（个/月）")
    private String displayQuantityStr;

    @ApiModelProperty("陈列单价")
    @CrmExcelColumn(value = "堆头陈列单价（元）")
    private String displayPriceStr;

    /**
     * 门店预计月销售额
     */
    @ApiModelProperty("门店预计月销售额（元）")
    @CrmExcelColumn(value = "门店预计月销售额（元）")
    private String terminalMonthSalesAmountStr;
    private BigDecimal terminalMonthSalesAmount;

    /**
     * 人员编码
     */
    @ApiModelProperty("人员编码")
    @CrmExcelColumn(value = "人员编码")
    private String personCode;
    /**
     * 人员名称
     */
    @ApiModelProperty("人员名称")
    @CrmExcelColumn(value = "人员名称")
    private String personName;

    /**
     * 人员类型
     */
    @ApiModelProperty("人员类型")
    @CrmExcelColumn(value = "人员类型")
    private String personType;

    /**
     * 身份证号码
     */
    @ApiModelProperty("身份证号码")
    @CrmExcelColumn(value = "身份证号码")
    private String personIdCard;

    /**
     * 物料编码
     */
    @ApiModelProperty("物料编码")
    @CrmExcelColumn(value = "物料编码")
    private String materialCode;

    /**
     * 物料名称
     */
    @ApiModelProperty("物料名称")
    @CrmExcelColumn(value = "物料名称")
    private String materialName;

    @ApiModelProperty("物料数量")
    @CrmExcelColumn(value = "物料数量")
    private String materialQuantityStr;


    @CrmExcelColumn(value = "单价")
    private String materialPriceStr;

    @ApiModelProperty("采购类型")
    @CrmExcelColumn(value = "采购类型")
    private String procurementType;


    /**
     * 费用合计-字符串，前端用
     */
    @ApiModelProperty("费用合计-字符串，前端用")
    @CrmExcelColumn(value = "* 费用合计（元）")
    private String totalFeeAmountStr;
    /**
     * 总部承担金额-字符串，前端用
     */
    @ApiModelProperty("总部承担金额-字符串，前端用")
    @CrmExcelColumn(value = "总部承担金额（元）")
    private String headFeeAmountStr;

    /**
     * 大区承担金额-字符串，前端用
     */
    @ApiModelProperty("大区承担金额-字符串，前端用")
    @CrmExcelColumn(value = "大区承担金额（元）")
    private String departmentFeeAmountStr;

    /**
     * 分子公司点内金额
     */
    @ApiModelProperty("分子公司点内金额")
    @CrmExcelColumn(value = "分子公司点内预算金额（元）")
    private String intraCompanyAmountStr;

    /**
     * 分子公司点外金额
     */
    @ApiModelProperty("分子公司点外金额")
    @CrmExcelColumn(value = "分子公司点外预算金额（元）")
    private String offPointAmountStr;

    /**
     * 客户承担金额-字符串，前端用
     */
    @ApiModelProperty("客户承担金额-字符串，前端用")
    @CrmExcelColumn(value = "客户承担金额（元）")
    private String customerFeeAmountStr;

    /**
     * 是否扣减费用池
     */
    @ApiModelProperty("是否扣减费用池")
    @CrmExcelColumn(value = "* 是否扣减费用池")
    private String isDeductionFeePool;

    /**
     * 核销方式
     */
    @ApiModelProperty("核销方式")
    @CrmExcelColumn(value = "* 核销类型")
    private String auditType;

    /**
     * 核销条件编码
     */
    @ApiModelProperty("核销条件编码")
    @CrmExcelColumn(value = "* 核销条件编码")
    private String auditConditionCode;

    /**
     * 结案形式
     */
    @ApiModelProperty("结案形式")
    @CrmExcelColumn(value = "结案形式")
    private String auditForm;

    /**
     * 付款方式
     */
    @ApiModelProperty("付款方式")
    @CrmExcelColumn(value = "付款方式")
    private String paymentMethod;
    /**
     * 是否和价格有关
     */
    @ApiModelProperty("是否和价格有关")
    @CrmExcelColumn(value = "是否和价格有关")
    private String relateToPrice;

    /**
     * 形式说明
     */
    @ApiModelProperty("形式说明")
    @CrmExcelColumn(value = "形式说明")
    private String formDescription;

    /**
     * 是否涨价政策
     */
    @ApiModelProperty("是否涨价政策")
    @CrmExcelColumn(value = "是否涨价政策")
    private String increasePricePromotion;

    /**
     * 扣款方式
     */
    @ApiModelProperty("扣款方式/是否扣款，   Y是N否")
    @CrmExcelColumn(value = "是否考核扣款")
    private String deductType;

    /**
     * 是否责任利润调整
     */
    @ApiModelProperty("是否责任利润调整")
    @CrmExcelColumn(value = "是否责任利润调整")
    private String dutyProfitAdjust;

    /**
     * 促销对象
     */
    @ApiModelProperty("促销对象")
    @CrmExcelColumn(value = "促销对象")
    private String promotionObject;

    /**
     * 促销对象
     */
    @ApiModelProperty("新品归类")
    @CrmExcelColumn(value = "新品归类")
    private String newProductType;

    /**
     * 是否占用划拨预算
     */
    @ApiModelProperty("是否占用划拨预算")
    @CrmExcelColumn(value = "是否占用划拨预算")
    private String occupyTransferBudget;

    @CrmExcelColumn(value = "关联方案明细编码")
    private String relatePlanItemCode;

    @CrmExcelColumn(value = "活动力度")
    private String activityIntensity;

    @CrmExcelColumn(value = "陈列批次")
    private String displayLot;

    @CrmExcelColumn(value = "是否客户上账")
    private String isCustomerAccount;


    @CrmExcelColumn(value = "活动承接形式")
    private String undertakingMode;

    /**
     * 是否大日期
     */
    @ApiModelProperty("是否为大日期活动（是/否）")
    @CrmExcelColumn(value = "是否为大日期活动（是/否）")
    private String isBigDate;

    @ApiModelProperty("产品日期")
    @CrmExcelColumn(value = "产品日期")
    private String thisProductProductionDateStr;

    /**
     * 大日期盘点数量
     */
    @ApiModelProperty("大日期盘点数量")
    @CrmExcelColumn(value = "大日期盘点数量")
    private String bigDateQtyStr;
}
