package com.biz.crm.tpm.business.activity.detail.plan.local.imports.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author baokai
 * @date 2023/9/19 15:43
 */
@Data
@CrmExcelImport(startRow = 2)
@ApiModel("供应商活动细案导入VO")
public class ActivityDetailPlanDY00000008SupplyItemImportVo extends CrmExcelVo {

    /**
     * 活动分类编码
     */
    @ApiModelProperty("活动分类编码")
    @CrmExcelColumn(value = "* 活动分类编码")
    private String activityTypeCode;
    /**
     * 活动分类
     */
    @ApiModelProperty("活动分类")
    @CrmExcelColumn(value = "活动分类")
    private String activityTypeName;

    /**
     * 活动形式编码
     */
    @ApiModelProperty("活动形式编码")
    @CrmExcelColumn(value = "* 活动形式编码")
    private String activityFormCode;
    /**
     * 活动形式名称
     */
    @ApiModelProperty("活动形式名称")
    @CrmExcelColumn(value = "活动形式")
    private String activityFormName;


    /**
     * 活动开始时间-字符串，前端传
     */
    @ApiModelProperty("活动开始时间-字符串，前端传")
    @CrmExcelColumn(value = "* 活动开始时间")
    private String activityBeginDateStr;

    /**
     * 活动结束时间-字符串，前端传
     */
    @CrmExcelColumn(value = "* 活动结束时间")
    private String activityEndDateStr;



    /**
     * 总部预算编码
     */
    @ApiModelProperty("总部预算编码")
    @CrmExcelColumn(value = "总部统筹预算编码")
    private String headMonthBudgetCode;

    /**
     * 总部统筹预算项目名称
     */
    @ApiModelProperty("总部统筹预算项目名称")
    @CrmExcelColumn(value = "总部统筹预算项目名称")
    private String headBudgetItemName;
    /**
     * 大区预算编码
     */
    @ApiModelProperty("预算编码/大区预算编码")
    @CrmExcelColumn(value = "大区自控预算编码")
    private String monthBudgetCode;
    /**
     * 大区预算项目名称
     */
    @ApiModelProperty("大区预算项目名称")
    @CrmExcelColumn(value = "大区自控预算名称")
    private String budgetItemName;

    /**
     * 渠道编码
     */
    @ApiModelProperty("渠道编码")
    @CrmExcelColumn(value = "渠道编码")
    private String channelCode;

    /**
     * 销售机构编码
     */
    @ApiModelProperty("销售机构编码")
    @CrmExcelColumn(value = "销售机构编码")
    private String salesInstitutionCode;

    /**
     * 区域编码
     */
    @ApiModelProperty("大区")
    @CrmExcelColumn(value = "大区编码")
    private String salesRegionCode;
    /**
     * 区域编码
     */
    @ApiModelProperty("大区")
    @CrmExcelColumn(value = "大区名称")
    private String salesRegionName;
    /**
     * 区域名称
     */
    @ApiModelProperty("省区")
    @CrmExcelColumn(value = "省区编码")
    private String salesOrgCode;

    /**
     * 区域名称
     */
    @ApiModelProperty("省区")
    @CrmExcelColumn(value = "省区名称")
    private String salesOrgName;

    /**
     * 一级管理渠道
     */
    @ApiModelProperty("一级管理渠道编码")
    @CrmExcelColumn(value = "* 一级渠道编码")
    private String firstChannelCode;

    /**
     * 一级管理渠道名称
     */
    @ApiModelProperty("一级管理渠道名称")
    @CrmExcelColumn(value = "一级渠道名称")
    private String firstChannelName;
    /**
     * 二级管理渠道
     */
    @ApiModelProperty("二级管理渠道")
    @CrmExcelColumn(value = "二级渠道编码")
    private String secondChannelCode;
    /**
     * 二级管理渠道名称
     */
    @ApiModelProperty("二级管理渠道名称")
    @CrmExcelColumn(value = "二级渠道名称")
    private String secondChannelName;


    /**
     * 客户编码
     */
    @ApiModelProperty("客户编码")
    @CrmExcelColumn(value = "* 客户编码")
    private String customerCode;
    /**
     * 客户名称
     */
    @ApiModelProperty("客户名称")
    @CrmExcelColumn(value = "客户名称")
    private String customerName;

    /**
     * 促销对象
     */
    @ApiModelProperty("促销对象")
    @CrmExcelColumn(value = "促销对象")
    private String promotionObject;

    /**
     * 供应商编码
     */
    @ApiModelProperty("供应商编码")
    @CrmExcelColumn(value = "* 供应商编码")
    private String supplierCode;
    /**
     * 供应商名称
     */
    @ApiModelProperty("供应商名称")
    @CrmExcelColumn(value = "供应商名称")
    private String supplierName;

    @CrmExcelColumn(value = "个税金额(元）")
    private String personIncomeTaxAmount;

    /**
     * 费用合计-字符串，前端用
     */
    @ApiModelProperty("费用合计-字符串，前端用")
    @CrmExcelColumn(value = "* 费用总金额（元）")
    private String totalFeeAmountStr;
    /**
     * 总部承担金额-字符串，前端用
     */
    @ApiModelProperty("总部承担金额-字符串，前端用")
    @CrmExcelColumn(value = "总部承担金额（元）")
    private String headFeeAmountStr;

    /**
     * 大区承担金额-字符串，前端用
     */
    @ApiModelProperty("大区承担金额-字符串，前端用")
    @CrmExcelColumn(value = "大区承担金额（元）")
    private String departmentFeeAmountStr;
    /**
     * 分子公司点内金额
     */
    @ApiModelProperty("分子公司点内金额")
    @CrmExcelColumn(value = "分子公司点内预算金额（元）")
    private String intraCompanyAmountStr;

    /**
     * 分子公司点外金额
     */
    @ApiModelProperty("分子公司点外金额")
    @CrmExcelColumn(value = "分子公司点外预算金额（元）")
    private String offPointAmountStr;


    /**
     * 是否扣减费用池
     */
    @ApiModelProperty("是否扣减费用池")
    @CrmExcelColumn(value = "* 是否扣减费用池")
    private String isDeductionFeePool;

    /**
     * 核销方式
     */
    @ApiModelProperty("核销方式")
    @CrmExcelColumn(value = "* 核销类型")
    private String auditType;


    /**
     * 核销条件编码
     */
    @ApiModelProperty("核销条件编码")
    @CrmExcelColumn(value = "* 核销条件编码")
    private String auditConditionCode;

    @CrmExcelColumn(value = "关联方案明细编码")
    private String relatePlanItemCode;


}
