package com.biz.crm.tpm.business.activity.detail.plan.local.imports.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @ClassName ActivityPlanItemDY00000010TradeSaleImportVo
 * @Description
 * @Author: jiangyin
 * @Date 2023/1/30
 */
@Data
@CrmExcelImport(startRow = 1)
@ApiModel("行销细案导入模版（垂直）导入VO")
public class ActivityDetailPlanItemDY00000010TradeSaleImportVo extends CrmExcelVo {

    /**
     * 活动类型编码
     */
    @ApiModelProperty("活动类型编码编码")
    @CrmExcelColumn(value = "✳ 活动分类编码")
    private String activityTypeCode;

    /**
     * 活动类型编码
     */
    @ApiModelProperty("活动类型名称")
    @CrmExcelColumn(value = "✳ 活动分类名称")
    private String activityTypeName;

    /**
     * 活动形式编码
     */
    @ApiModelProperty("活动形式编码")
    @CrmExcelColumn(value = "✳ 活动形式编码")
    private String activityFormCode;

    /**
     * 活动形式名称
     */
    @ApiModelProperty("活动形式名称")
    @CrmExcelColumn(value = "✳ 活动形式名称")
    private String activityFormName;

    /**
     * ✳活动开始时间
     */
    @CrmExcelColumn("✳活动开始时间")
    private String activityBeginDateStr;
    /**
     * ✳活动结束时间
     */
    @CrmExcelColumn("✳活动结束时间")
    private String activityEndDateStr;

    /**
     * 费用归属年月
     */
    @ApiModelProperty("费用归属年月")
    @CrmExcelColumn(value = "费用归属年月")
    private String feeBelongYearMonth;

    /**
     * ✳区域
     */
    @ApiModelProperty("✳区域")
    @CrmExcelColumn(value = "✳区域")
    private String region;

    /**
     * ✳零售商编码
     */
    @ApiModelProperty("✳零售商编码")
    @CrmExcelColumn(value = "✳零售商编码")
    private String systemCode;

    /**
     * 零售商
     */
    @ApiModelProperty("零售商")
    @CrmExcelColumn(value = "零售商")
    private String systemName;

    /**
     * 一级营销渠道
     */
    @CrmExcelColumn(value = "一级营销渠道")
    private String firstChannelCode;
    /**
     * 二级营销渠道
     */
    @CrmExcelColumn(value = "二级营销渠道")
    private String secondChannelCode;

    /**
     * AC门店类型
     */
    @CrmExcelColumn(value = "AC门店类型")
    private String acStoreType;

    /**
     * 采购类型
     */
    @CrmExcelColumn(value = "采购类型")
    private String isTypeOfPurchaseNo;

    /**
     * 品牌编码
     */
    @CrmExcelColumn("品牌编码")
    private String productBrandCode;
    /**
     * 品牌名称
     */
    @CrmExcelColumn("品牌")
    private String productBrandName;
    /**
     * 品类编码
     */
    @CrmExcelColumn("品类编码")
    private String productCategoryCode;
    /**
     * 品类名称
     */
    @CrmExcelColumn("品类")
    private String productCategoryName;
    /**
     * 品项编码
     */
    @CrmExcelColumn("品项编码")
    private String productItemCode;
    /**
     * 品项名称
     */
    @CrmExcelColumn("品项")
    private String productItemName;

    /**
     * 本品编码
     */
    @CrmExcelColumn("本品编码")
    private String productCode;
    /**
     * 本品
     */
    @CrmExcelColumn("本品")
    private String productName;

    /**
     * 物料编码
     */
    @CrmExcelColumn("物料编码")
    private String materialCode;
    /**
     * 物料名称
     */
    @CrmExcelColumn("物料名称")
    private String materialName;

    @CrmExcelColumn(value = "门店编码")
    private String terminalCode;

    @CrmExcelColumn(value = "门店名称")
    private String terminalName;

    @CrmExcelColumn(value = "物料数量")
    private String materialQuantityStr;

    @CrmExcelColumn("税率")
    private String taxRateStr;

    @CrmExcelColumn("活动场次")
    private String activityEventCode;

    @CrmExcelColumn("场次名称")
    private String activityEventName;

    @CrmExcelColumn("数量")
    private String quantityStr;

    @CrmExcelColumn("*合同编码")
    private String contractCode;
    /**
     * 供应商名称
     */
    @CrmExcelColumn("供应商名称")
    private String supplierName;

    @CrmExcelColumn("未含税单价")
    private String priceExcludingTaxStr;

    @CrmExcelColumn("含税单价")
    private String priceIncludingTaxStr;

    @CrmExcelColumn("合同未税金额")
    private String contractExcludingTaxStr;

    @CrmExcelColumn("合同含税金额")
    private String contractIncludingTaxStr;

    @CrmExcelColumn("实际未税金额")
    private String amountExcludingTaxStr;

    @CrmExcelColumn("实际含税金额")
    private String amountIncludingTaxStr;

    /**
     * 系统承担金额
     */
    @CrmExcelColumn("系统承担金额")
    private String systemBorneAmountStr;
    /**
     * 我方承担金额
     */
    @CrmExcelColumn("我方承担金额")
    private String feeAmountStr;
    /**
     * 总部费用预算编码
     */
    @CrmExcelColumn("总部费用预算编码")
    private String headMonthBudgetCode;
    /**
     * 公投费用预算编码
     */
    @CrmExcelColumn("公投费用预算编码")
    private String regionReferendumMonthBudgetCode;
    /**
     * 公投费用预算编码
     */
    @CrmExcelColumn("自投费用预算编码")
    private String regionAutomaticMonthBudgetCode;
    /**
     * 总部费用
     */
    @CrmExcelColumn("总部费用")
    private String headFeeAmountStr;
    /**
     * 公投费用
     */
    @CrmExcelColumn("公投费用")
    private String regionReferendumFeeAmountStr;
    /**
     * 自投费用
     */
    @CrmExcelColumn("自投费用")
    private String regionAutomaticFeeAmountStr;

    /**
     * ✳结案形式
     */
    @CrmExcelColumn("✳结案形式")
    private String auditForm;
    /**
     * 活动描述
     */
    @CrmExcelColumn("活动描述")
    private String activityDesc;
    /**
     * 活动描述
     */
    @CrmExcelColumn("* 核销类型")
    private String auditType;
    /**
     * 核销条件编码
     */
    @CrmExcelColumn("核销条件编码")
    private String auditConditionCode;

    @CrmExcelColumn("活动产品活动期间销售目标（元）")
    private String activityProductSaleTargetAmountStr;

    @CrmExcelColumn("全品活动期间销售目标（元）")
    private String activitySaleTargetAmountStr;

    @CrmExcelColumn("投产比")
    private String productionRatioStr;

    @CrmExcelColumn("费用合计")
    private String totalFeeAmountStr;



}
