package com.biz.crm.tpm.business.activity.detail.plan.local.imports.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 活动细案明细-通用导入VO
 * @author wanghaojia
 * @date 2023/1/11 14:17
 */
@Data
@CrmExcelImport(startRow = 2)
@ApiModel("活动细案明细-通用导入VO")
public class ActivityDetailPlanItemImportVo extends CrmExcelVo {

    /**
     * 活动类型编码
     */
    @ApiModelProperty("活动类型编码")
    @CrmExcelColumn(value = "* 活动分类编码")
    private String activityTypeCode;
    /**
     * 活动类型名称
     */
    @ApiModelProperty("活动类型名称")
    @CrmExcelColumn(value = "活动分类名称")
    private String activityTypeName;

    /**
     * 活动形式编码
     */
    @ApiModelProperty("活动形式编码")
    @CrmExcelColumn(value = "* 活动形式编码")
    private String activityFormCode;
    /**
     * 活动形式名称
     */
    @ApiModelProperty("活动形式名称")
    @CrmExcelColumn(value = "活动形式名称")
    private String activityFormName;

}
