package com.biz.crm.tpm.business.activity.detail.plan.local.listener;

import com.biz.crm.tpm.business.activity.detail.plan.local.entity.ActivityDetailPlan;
import com.biz.crm.tpm.business.activity.detail.plan.local.entity.ActivityDetailPlanItem;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.ActivityDetailPlanService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.constant.ActivityDetailPlanConstant;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemDto;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.listener.ProcessCompleteListener;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.beans.PropertyDescriptor;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 活动细案修改审批通过监听
 */
@Component
public class ActivityDetailPlanModifyProcessCompleteListener implements ProcessCompleteListener {


    @Autowired(required = false)
    private ActivityDetailPlanService activityDetailPlanService;
    @Autowired(required = false)
    private NebulaNetEventClient nebulaNetEventClient;

    @Override
    public String getBusinessCode() {
        return ActivityDetailPlanConstant.PROCESS_NAME_ACTIVITY_DETAIL_PLAN_MODIFY;
    }

    @Override
    public void onProcessComplete(ProcessStatusDto dto) {

        if (StringUtils.isEmpty(dto.getBusinessNo())) {
            return;
        }
        //多策略提交
        String processStatus = dto.getProcessStatus();
        Validate.notEmpty(dto.getProcessNo(), "流程编码不能为空！");
        //审批通过
        if (ProcessStatusEnum.PASS.getDictCode().equals(processStatus)) {
            //修改细案审批状态
            activityDetailPlanService.processPass(dto);
        }
        //审批驳回|流程追回
        if (ProcessStatusEnum.REJECT.getDictCode().equals(processStatus) ||
                ProcessStatusEnum.RECOVER.getDictCode().equals(processStatus)) {
            activityDetailPlanService.processRejectAndRecover(dto);
        }

    }


    public static void main(String[] args) {
        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(ActivityDetailPlanItem.class);
        Map<String, PropertyDescriptor> map = Arrays.stream(propertyDescriptors).collect(Collectors.toMap(PropertyDescriptor::getName, Function.identity()));
        PropertyDescriptor[] propertyDescriptors1 = BeanUtils.getPropertyDescriptors(ActivityDetailPlanItemDto.class);
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors1) {
            PropertyDescriptor propertyDescriptor1 = map.get(propertyDescriptor.getName());
            if (null != propertyDescriptor1 && propertyDescriptor.getPropertyType() != propertyDescriptor1.getPropertyType()){
                System.out.println(propertyDescriptor1.getName());
            }


        }
    }

}
