package com.biz.crm.tpm.business.activity.detail.plan.local.listener;

import com.biz.crm.tpm.business.activity.detail.plan.local.entity.ActivityDetailPlanPlan;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.ActivityDetailPlanItemService;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.ActivityDetailPlanPlanService;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityDetailPlanPlanEventDto;
import com.biz.crm.tpm.business.activity.plan.sdk.listener.ActivityDetailPlanPlanListener;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityDetailPlanPlanResponse;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityDetailPlanPlanVo;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanNoCloseItemResponse;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;

/**
 * 查询活动细案关系 对外提供事件
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2023.2.26 18:09
 */
@Slf4j
@Component
public class ActivityDetailPlanPlanListenerImpl implements ActivityDetailPlanPlanListener {

    @Autowired(required = false)
    private ActivityDetailPlanItemService activityDetailPlanItemService;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public void validateCloseActivityPlanItem(ActivityDetailPlanPlanEventDto dto) {
        if (CollectionUtils.isEmpty(dto.getPlanItemCodeList())){
            return;
        }
        List<String> approvedDetailItemCodelistByPlanItemCodeList1 = activityDetailPlanItemService.findApprovedDetailItemCodeListByPlanItemCodeList(dto.getPlanItemCodeList());
        if (approvedDetailItemCodelistByPlanItemCodeList1.size() > 0){
            throw new RuntimeException("存在已关联细案["+String.join(",",approvedDetailItemCodelistByPlanItemCodeList1)+"]");
        }
    }

    @Override
    public void closeActivityDetailPlanItem(ActivityDetailPlanPlanEventDto dto) {
        activityDetailPlanItemService.closeByPlanCodeItemList(dto.getPlanItemCodeList());
    }

    /**
     * 查询可关闭的方案明细编码（无细案关联，或已关联的细案完全关闭）
     *
     * @param dto 方案明细编码
     * @return List<String>
     **/
    @Override
    public ActivityPlanNoCloseItemResponse getNoClosePlanItemNo(ActivityDetailPlanPlanEventDto dto) {
        ActivityPlanNoCloseItemResponse activityPlanNoCloseItemResponse = new ActivityPlanNoCloseItemResponse();
        if(CollectionUtils.isEmpty(dto.getPlanItemCodeList())){
            return activityPlanNoCloseItemResponse;
        }
        List<String> itemNos = activityDetailPlanItemService.getNoClosePlanItemNo(dto.getPlanItemCodeList());
        activityPlanNoCloseItemResponse.setItemNos(itemNos);
        return activityPlanNoCloseItemResponse;
    }

}
