package com.biz.crm.tpm.business.activity.detail.plan.local.listener;

import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.ActivityDetailPlanService;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.PushActivityDetailPlanService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.constant.ActivityDetailPlanConstant;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.listener.ProcessCompleteListener;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;

/**
 * 活动细案审批通过回调
 *
 * @author wanghaojia
 * @date 2022/11/30 20:57
 */
@Slf4j
@Component
public class ActivityDetailPlanProcessCompleteListener implements ProcessCompleteListener {

    @Autowired(required = false)
    private ActivityDetailPlanService activityDetailPlanService;

    @Autowired
    private PushActivityDetailPlanService pushActivityDetailPlanService;

    @Autowired(required = false)
    private RocketMqProducer rocketMqProducer;


    @Resource
    private ApplicationEventPublisher eventPublisher;

    @Autowired(required = false)
    private LoginUserService loginUserService;


    @Override
    public String getBusinessCode() {
        return ActivityDetailPlanConstant.PROCESS_NAME_ACTIVITY_DETAIL_PLAN;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void onProcessComplete(ProcessStatusDto dto) {
        if (StringUtils.isEmpty(dto.getBusinessNo())) {
            return;
        }
        //多策略提交
        String processStatus = dto.getProcessStatus();
        Validate.notEmpty(dto.getProcessNo(), "流程编码不能为空！");
        //审批通过
        if (ProcessStatusEnum.PASS.getDictCode().equals(processStatus)) {
            //修改审批状态
            activityDetailPlanService.processPass(dto);
            pushActivityDetailPlanService.passPushMqDirect(dto.getProcessNo(), dto.getBusinessNoList());
        }
        //审批驳回|流程追回
        if (ProcessStatusEnum.REJECT.getDictCode().equals(processStatus) ||
                ProcessStatusEnum.RECOVER.getDictCode().equals(processStatus)) {
            activityDetailPlanService.processRejectAndRecover(dto);
        }
    }

}
