package com.biz.crm.tpm.business.activity.detail.plan.local.listener;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.activity.detail.plan.local.entity.ActivityDetailPlanItem;
import com.biz.crm.tpm.business.activity.detail.plan.local.repository.ActivityDetailPlanItemRepository;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.SapAmountEventDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.event.SapAmountListener;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.SapAmountResponse;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanSapAmountEventDto;
import com.biz.crm.tpm.business.activity.plan.sdk.event.ActivityPlanSapAmountListener;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanSapAmountResponse;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author: chenlong
 * @date: 2023/3/16 19:56
 * @description: 查询sap发生额通过活动细案编码 对外提供事件实现
 */
@Slf4j
@Component
public class ActivityPlanSapAmountListenerImpl implements ActivityPlanSapAmountListener {

    @Autowired
    private ActivityDetailPlanItemRepository activityDetailPlanItemRepository;

    @Autowired(required = false)
    private NebulaNetEventClient nebulaNetEventClient;

    /**
     * 查询sap发生额通过活动细案编码
     *
     * @param eventDto 事件dto
     * @return Map<String, BigDecimal>
     **/
    @Override
    public ActivityPlanSapAmountResponse getSapAmountByDetailItemNos(ActivityPlanSapAmountEventDto eventDto) {
        ActivityPlanSapAmountResponse activityPlanSapAmountResponse = new ActivityPlanSapAmountResponse();
        if(CollectionUtils.isEmpty(eventDto.getPlanItemCodeList())){
            activityPlanSapAmountResponse.setAmountMap(Maps.newHashMap());
            return activityPlanSapAmountResponse;
        }

        //根据方案明细编码，获取关联的细案明细
        List<ActivityDetailPlanItem> detailPlanItems = this.activityDetailPlanItemRepository.lambdaQuery()
                .eq(ActivityDetailPlanItem::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(ActivityDetailPlanItem::getTenantCode, TenantUtils.getTenantCode())
                .in(ActivityDetailPlanItem::getRelatePlanItemCode, eventDto.getPlanItemCodeList())
                .select(ActivityDetailPlanItem::getRelatePlanItemCode,ActivityDetailPlanItem::getDetailPlanItemCode)
                .list();
        if (CollectionUtils.isEmpty(detailPlanItems)) {
            activityPlanSapAmountResponse.setAmountMap(Maps.newHashMap());
            return activityPlanSapAmountResponse;
        }

        List<String> detailPlanItemCodes = detailPlanItems.stream().map(ActivityDetailPlanItem::getDetailPlanItemCode).collect(Collectors.toList());
        SapAmountEventDto sapAmountEventDto = new SapAmountEventDto();
        sapAmountEventDto.setItemNos(detailPlanItemCodes);
        SerializableBiConsumer<SapAmountListener, SapAmountEventDto> getSapAmountByDetailItemNos =
                SapAmountListener::getSapAmountByDetailItemNos;
        SapAmountResponse sapAmountResponse = (SapAmountResponse) this.nebulaNetEventClient.directPublish(sapAmountEventDto,
                SapAmountListener.class, getSapAmountByDetailItemNos);
        Map<String, BigDecimal> sapMap = sapAmountResponse.getAmountMap();
        if (null == sapMap){
            sapMap = Maps.newHashMap();
        }
        Map<String, BigDecimal> activityPlanSapMap = Maps.newHashMap();
        Map<String, BigDecimal> finalSapMap = sapMap;
        for (ActivityDetailPlanItem item : detailPlanItems) {
            activityPlanSapMap.put(item.getRelatePlanItemCode(), finalSapMap.get(item.getDetailPlanItemCode()));
        }
        activityPlanSapAmountResponse.setAmountMap(activityPlanSapMap);
        return activityPlanSapAmountResponse;
    }
}
