package com.biz.crm.tpm.business.activity.detail.plan.local.mapper;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.activity.detail.plan.local.entity.ActivityDetailPlan;
import com.biz.crm.tpm.business.activity.detail.plan.local.entity.ActivityDetailPlanBudget;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanBudgetDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanBudgetVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ReconciliationActivityVo;
import org.apache.ibatis.annotations.Param;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/**
 * 活动细案(ActivityDetailPlan)表mybatis访问层
 *
 * @author wanghaojia
 * @since 2022-11-04 16:52:04
 */
public interface ActivityDetailPlanBudgetMapper extends BaseMapper<ActivityDetailPlanBudget> {


    List<ActivityDetailPlanBudgetDto> listDtoListByDetailPlanCode(@Param("detailPlanCode") String detailPlanCode);

    LinkedList<ActivityDetailPlanBudget> listByOperateCodeListVertical(@Param("operateCodeList") List<String> operateCodeList);

    List<ActivityDetailPlanBudgetVo> findByPlanItemCode(@Param("itemCodeSet") Set<String> itemCodeSet, @Param("tenantCode") String tenantCode);

    /**
     * 根据细案编码查询关联方案编码
     * @param detailPlanCodeSet 细案编码
     * @param tenantCode 租户编码
     * @return 方案编码
     */
    List<String> detailPlanRelatePlanCodeList(@Param("detailPlanCodeSet") Set<String> detailPlanCodeSet, @Param("tenantCode") String tenantCode);

    List<ActivityDetailPlanBudgetVo> findPlanItemCodeByActivityDetailItemCodes(@Param("activityDetailCodes") List<String> activityDetailCodes);

    List<ActivityDetailPlanBudgetVo> findRegionIsRelateHead(@Param("codes") List<String> planCodes,@Param("tenantCode") String tenantCode);

    List<String> hasRelateDetailPlanCodeList(@Param("planItemCodeSet") Set<String> planItemCodeSet, @Param("tenantCode") String tenantCode);

}

