package com.biz.crm.tpm.business.activity.detail.plan.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mn.common.base.dto.audit.AutoAuditParamsDto;
import com.biz.crm.tpm.business.activity.detail.plan.local.entity.ActivityDetailPlanItem;
import com.biz.crm.tpm.business.activity.detail.plan.local.entity.BusinessUnitSetTable;
import com.biz.crm.tpm.business.activity.detail.plan.local.vo.ActivityDetailPlanItemsExportsVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemStatisticsDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.*;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.RedPacketQueryScheme2Dto;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.RedPacketQueryScheme2Vo;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditCustomerDetailCollectionVo;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;
import java.util.Set;

/**
 * @author ：dengwei
 * @date ：Created in 2022/11/10 18:06
 * @description：活动细案明细
 */
public interface ActivityDetailPlanItemMapper extends BaseMapper<ActivityDetailPlanItem> {

    /**
     * 分页查询所有数据
     *
     * @param page                      分页对象
     * @param activityDetailPlanItemDto 查询实体
     * @return 所有数据
     */
    Page<ActivityDetailPlanItemVo> findByConditions(@Param("page") Page<ActivityDetailPlanItemVo> page, @Param("dto") ActivityDetailPlanItemDto activityDetailPlanItemDto);

    List<String> findForAuditConditionCodeList(@Param("dto") ActivityDetailPlanItemDto activityDetailPlanItemDto);

    Page<ActivityDetailPlanItemVo> findForAudit(@Param("page") Page<ActivityDetailPlanItemVo> page,
                                                @Param("dto") ActivityDetailPlanItemDto activityDetailPlanItemDto);

    int findTotalForAudit(@Param("dto") ActivityDetailPlanItemDto activityDetailPlanItemDto);


    /**
     * 根据客户与区域 统计费用合计
     *
     * @param dto 统计参数
     * @return List<ActivityDetailPlanItemStatisticsVo>
     */
    List<ActivityDetailPlanItemStatisticsVo> statisticsFeeAmountByCusOrgCodes(@Param("dto") ActivityDetailPlanItemStatisticsDto dto);

    /**
     * 根据品牌，零售商，区域统计细案明细的费用合计
     *
     * @param dto 统计参数
     * @return List<ActivityDetailPlanItemStatisticsVo>
     */
    List<ActivityDetailPlanItemStatisticsVo> statisticsDetailPlanItemTotalFee(@Param("dto") ActivityDetailPlanItemStatisticsDto dto);

    /**
     * 根据零售商，区域统计细案明细的费用合计
     *
     * @param dto 统计参数
     * @return List<NextMonthPredictAccountFeeVo>
     */
    List<NextMonthPredictAccountFeeVo> statisNextMonthPredictAccountFee(@Param("dto") ActivityDetailPlanItemStatisticsDto dto);

    /**
     * 根据品牌，零售商，区域统计细案明细到结案核销的折扣上账金额
     *
     * @param dto 统计参数
     * @return List<DiscountAccountFeeVo>
     */
    List<DiscountAccountFeeVo> statisDiscountAccountFee(@Param("dto") ActivityDetailPlanItemStatisticsDto dto);

    /**
     * 获取预提明细生成数据
     *
     * @param page            分页参数
     * @param vo              用户选择参数
     * @param processStatus   审批状态
     * @param upAccountStatus 上账状态
     * @return com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo>
     * @author jiangyin
     * @date 2022/12/26 15:48
     */
    Page<ActivityDetailPlanItemVo> findByProcessStatusAndUpAccountStatus(Page<ActivityDetailPlanItemVo> page,
                                                                         @Param("vo") ActivityDetailPlanItemDto vo,
                                                                         @Param("processStatus") String processStatus,
                                                                         @Param("upAccountStatus") String upAccountStatus);

    List<ActivityDetailPlanItemVo> findSubComActivityDetailByYearMonth(@Param("beginDate") String beginDate,
                                                                       @Param("endDate") String endDate,
                                                                       @Param("mainCode") String mainCode,
                                                                       @Param("inConditionList") List<String> inConditionList,
                                                                       @Param("tenantCode") String tenantCode);

    Page<ActivityDetailPlanItemVo> findUpwardDetailForWithholding(Page<ActivityDetailPlanItemVo> page,
                                                                  @Param("customerCodeInStrList") List<String> customerCodeInStrList,
                                                                  @Param("vo") ActivityDetailPlanItemDto upwardDto,
                                                                  @Param("upAccountStatus") String upAccountStatus,
                                                                  @Param("processStatus") String processStatus,
                                                                  @Param("excludeActivityTypeCodeSet") Set<String> excludeActivityTypeCodeSet);

    List<ActivityDetailPlanItemVo> findItemCodesByDetailPlanCodes(@Param("code") String planCode,
                                                                  @Param("tenantCode") String tenantCode);

    List<RedPacketQueryScheme2Vo> redPacketQueryScheme(@Param("dto") RedPacketQueryScheme2Dto dto2);

    BigDecimal findByCode(@Param("detailPlanItemCode") String detailPlanItemCode, @Param("tenantCode") String tenantCode);

    List<String> findApprovedDetailItemCodeListByPlanItemCodeList(@Param("planItemCodeList") List<String> planItemCodeList);

    List<ActivityDetailPlanItemVo> findPlanItemList(@Param("detailPlanCodes") List<String> detailPlanCodes
            , @Param("wholeAudit") String wholeAudit
            , @Param("auditDate") String auditDate, @Param("autoAudit") String autoAudit);


    List<ActivityDetailPlanItemVo> findDetailItemList(@Param("autoAuditParams") AutoAuditParamsDto autoAuditParams);


    /**
     * 查询可关闭的方案明细编码（无细案关联，或已关联的细案完全关闭）
     *
     * @param itemNos 方案明细编码
     * @return List<String>
     **/
    List<String> getNoClosePlanItemNo(@Param("itemNos") List<String> itemNos, @Param("tenantCode") String tenantCode);

    /**
     * 分页查询，方案未关闭，细案已关闭，细案未回退预算的数据
     *
     * @param page 分页对象
     * @param activityDetailPlanItemDto 查询实体
     * @return 所有数据
     */
    Page<ActivityDetailPlanItemVo> findNoRollBackByConditions(@Param("page") Page<ActivityDetailPlanItemVo> page, @Param("dto") ActivityDetailPlanItemDto activityDetailPlanItemDto);
    Integer getSubRelatedItemTotal(@Param("dto") ActivityDetailPlanItemDto dto);

    List<ActivityDetailPlanItemVo> getDetailItemList(@Param("num") Integer num,@Param("size") Integer pageSize, @Param("dto") ActivityDetailPlanItemDto dto);
    /**
     * 查询可核销数据
     * @param autoAuditParams 查询参数
     * @return List
     */
    Page<ActivityDetailPlanItemVo> findCanAutoAuditItemPage(@Param("page") Page<ActivityDetailPlanItemVo> page,@Param("autoAuditParams") AutoAuditParamsDto autoAuditParams);


    List<ActivityDetailPlanReportVo> findTerminalVoListByDetailItemCode(@Param("detailPlanItemCode") String detailPlanItemCode);

    /**
     * 更新头状态
     */
    void updateHeadStatus(@Param("detailPlanItemCodeList") List<String> itemCodeList);

    List<ActivityDetailPlanItemVo> findByCodes(@Param("set") Set<String> set);

    /**
     * 更据商超扣费映射配置的维度 查询匹配的活动明细总条数
     *
     * @param selectDto
     * @return
     */
    Integer getExtractAuditDetailPlanCheckDataTotal(@Param("dto") ActivityDetailPlanItemDto selectDto);

    /**
     * 更据商超扣费映射配置的维度 查询匹配的活动明细详情
     *
     * @param selectDto
     * @param pageNumber
     * @param pageSize
     * @return
     */
    List<ActivityDetailPlanItemVo> extractAuditDetailPlanCheckData(@Param("dto") ActivityDetailPlanItemDto selectDto, @Param("pageNumber") int pageNumber, @Param("pageSize") int pageSize);
    List<ActivityDetailPlanItem> findByRegionPlanItemCodes(@Param("planItemCodes") List<String> planItemCodes);

    /**
     * 根据方案明细编码或方案编码查关联细案明细数量
     *
     * @param detailPlanItemCodes
     * @param planCodes
     * @param tenantCode
     * @return
     */
    Integer findByItemCodesOrPlanCods(@Param("detailPlanItemCodes")Set<String> detailPlanItemCodes, @Param("planCodes")Set<String> planCodes,@Param("tenantCode") String tenantCode);

    /**
     * 根据总部方案编码查关联方案的细案明细
     * @param cods
     * @param tenantCode
     * @return
     */
    List<ActivityDetailPlanItemVo> findByPlanCodes(@Param("cods") Set<String> cods, @Param("tenantCode") String tenantCode);

    /**
     * 根据活动方案编码查 细案明细
     *
     * @param set
     * @param tenantCode
     * @return
     */
    List<ActivityDetailPlanItemVo> findByPlanItemCodes(@Param("set") Set<String> set,@Param("tenantCode") String tenantCode);

    List<ActivityDetailPlanItemVo> listForVariable(@Param("dto") ActivityDetailPlanItemDto dto, @Param("tenantCode") String tenantCode);

    List<ActivityDetailPlanItem> findByPlanItemCode(@Param("planItemCode") String planItemCode);

    List<String> findDetailItemCodesByPlanItemCodes(@Param("planItemCodes") List<String> planItemCodes);

    List<ActivityDetailPlanItemVo> findByConditionsList(@Param("dto") ActivityDetailPlanItemDto activityDetailPlanItemDto);


    Page<ActivityDetailPlanItemsExportsVo> findExportListByDetailPlanCodes(@Param("page") Page<ActivityDetailPlanItemsExportsVo> page, @Param("tenantCode") String tenantCode,
                                                                           @Param("detailPlanCodes") List<String> detailPlanCodes);

    /**
     * 查询对应的分组数据，ect系统用
     * @param page
     * @param dto
     * @return
     */
    Page<DiscountAccountFeeGroupVo> findPageStatisDiscountAccountFee(@Param("page") Page<DiscountAccountFeeGroupVo> page, @Param("dto") ActivityDetailPlanItemStatisticsDto dto);

    Page<ActivityDetailPlanItemVo> findConditionByPlanCodes(@Param("page") Page<ActivityDetailPlanItemVo> page, @Param("dto") ActivityDetailPlanItemDto dto);

    Page<ActivityDetailPlanItemVo> findItemForMaterialPurchasing(Page<ActivityDetailPlanItemVo> page, @Param("dto") ActivityDetailPlanItemDto activityDetailPlanItemDto);

    Page<String> findByDtoForPrediction(@Param("page") Page<String> page, @Param("dto") ActivityDetailPlanItemDto dto);

    ActivityDetailPlanItemVo getDetailPlanItemByCode(@Param("itemCode")String itemCode, @Param("tenantCode") String tenantCode);

    Page<BusinessUnitSetTable> findListForFR(Page<BusinessUnitSetTable> page, @Param("yearMonths") List<String> yearMonths);

    List<ActivityDetailPlanItemVo> findChangeStatus(@Param("codes") List<String> detailPlanItemCodes,@Param("tenantCode") String tenantCode);

    void useProductNumber(@Param("dto") ActivityDetailPlanItemVo item);

    List<AuditCustomerDetailCollectionVo> findAuditDetailListByDetailPlanCodeList(@Param("codes") List<String> detailPlanItemCodeList, @Param("tenantCode") String tenantCode);

    Page<ActivityDetailPlanItemVo> repeatActivityDetailPlanItemPage(Page<ActivityDetailPlanItemVo> page, @Param("dto") ActivityDetailPlanItemDto dto, @Param("sourceDto") ActivityDetailPlanItemDto sourceDto);
}
