package com.biz.crm.tpm.business.activity.detail.plan.local.mapper;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mn.common.base.dto.audit.AutoAuditParamsDto;
import com.biz.crm.tpm.business.activity.detail.plan.local.entity.ActivityDetailPlan;
import com.biz.crm.tpm.business.activity.detail.plan.local.vo.ActivityPlanMessageVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanReportDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanReportVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanVo;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityDetailPlanPlanVo;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;
import java.util.Set;

/**
 * 活动细案(ActivityDetailPlan)表mybatis访问层
 *
 * @author wanghaojia
 * @since 2022-11-04 16:52:04
 */
public interface ActivityDetailPlanMapper extends BaseMapper<ActivityDetailPlan> {

  /**
   * 分页查询所有数据
   *
   * @param page               分页对象
   * @param activityDetailPlan 查询实体
   * @return 所有数据
   */
  Page<ActivityDetailPlanVo> findByConditions(@Param("page") Page<ActivityDetailPlanVo> page, @Param("dto") ActivityDetailPlanDto activityDetailPlan);

  Page<ActivityDetailPlanReportVo> findDetailByConditions(@Param("page") Page<ActivityDetailPlanReportVo> page, @Param("dto") ActivityDetailPlanReportDto dto);

  /**
   * 分页查询明细数据
   *
   * @param page
   * @param activityDetailPlanItemDto
   * @return
   */
  Page<ActivityDetailPlanItemVo> queryActivityDetailPlan(@Param("page") Page<ActivityDetailPlanItemVo> page, @Param("dto") ActivityDetailPlanItemDto activityDetailPlanItemDto);


  List<ActivityDetailPlanItemVo> getCanAutoAuditDto(@Param("date") Date date);

  /**
   * 分页查询可自动核销数据
   *
   * @param page      分页
   * @param auditDate 核销日期
   * @return Page
   */
  Page<ActivityDetailPlanItemVo> listCanAutoAudit(@Param("page") Page<ActivityDetailPlanItemVo> page, @Param("auditDate") String auditDate, @Param("autoAudit") String autoAudit, @Param("wholeAudit") String wholeAudit);


  Page<ActivityDetailPlanVo> listDetailPlanCanAudoAudit(Page<ActivityDetailPlanVo> page, @Param("auditDate") String auditDate, @Param("autoAudit") String autoAudit, @Param("wholeAudit") String wholeAudit);

  Page<ActivityDetailPlanVo> findCanAutoAudit(@Param("page") Page<ActivityDetailPlanVo> page, @Param("autoAuditParams") AutoAuditParamsDto autoAuditParams);

  /**
   * 获取能自动核销的总条数
   *
   * @param auditDate 核销时间
   * @return int
   */
  Integer getCanAutoAuditTotalNumber(@Param("auditDate") String auditDate
          , @Param("businessUnitCode") String businessUnitCode
          , @Param("autoAudit") String autoAudit
          , @Param("wholeAudit") String wholeAudit);

  Integer getActivityTotalNumber(@Param("autoAuditParams") AutoAuditParamsDto autoAuditParams);

  void updateActivityDetailPlanAutoAudit(@Param("detailPlanCode") String detailPlanCode, @Param("autoAudit") String autoAudit);

  List<ActivityDetailPlanItemVo> findPlanItemList(@Param("detailPlanCodes") List<String> detailPlanCodes
          , @Param("wholeAudit") String wholeAudit
          , @Param("auditDate") String auditDate, @Param("autoAudit") String autoAudit);

  List<ActivityPlanMessageVo> findPlanMessageByDetailPlanCodeSet(@Param("detailPlanCodeSet") Set<String> detailPlanCodeSet);

  /**
   * 修改标识
   *
   * @param codeList         活动编码
   * @param autoAudit 标识
   */
  void updateAutoAuditFlag(@Param("codeList") List<String> codeList, @Param("autoAudit") String autoAudit);

  /**
   * 根据方案编码查细案
   *
   * @param codeSet
   * @return
   */
    List<ActivityDetailPlanVo> findPlanCodes(@Param("codeSet") Set<String> codeSet,@Param("tenantCode") String tenantCode,@Param("code") String code);

  /**
   * 查找没有被核销的细案
   *
   * @param dto 查询条件
   * @return 实体集合
   */
  List<ActivityDetailPlan> findHaveNotAuditDetailPlanEntity(@Param("dto") ActivityDetailPlanDto dto);


    Page<ActivityDetailPlanVo> findPageForOut(@Param("page") Page<ActivityDetailPlanVo> page, @Param("dto") ActivityDetailPlanDto dto);

  /**
   * 更新细案活动状态
   *
   * @param detailPlanCodeList
   * @param planStatus
   * @param tenantCode
   * @return void
   * @author: huxmld
   * @version: v1.0.0
   * @date: 2023-08-26 02:29
   */
    void updatePlanStatusByDetailPlanCodeList(@Param("codeList")List<String> detailPlanCodeList,@Param("planStatus") String planStatus,@Param("tenantCode") String tenantCode);

  /**
   * 根据方案明细编码获取细案信息
   *
   * @param planItemCodeList
   * @param tenantCode
   * @return java.util.List<com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityDetailPlanPlanVo>
   * @author: huxmld
   * @version: v1.0.0
   * @date: 2023-11-29 15:08
   */
  List<ActivityDetailPlanPlanVo> getDetailPlanInfoByPlanItemCodeList(@Param("codeList")List<String> planItemCodeList, @Param("tenantCode")  String tenantCode);

  /**
   * 细案编码查询方案信息
   * @param detailPlanCodeList
   * @param tenantCode
   * @return
   */
  List<ActivityDetailPlanPlanVo> findPlanByRelateDetailPlanCode(@Param("codeList") List<String> detailPlanCodeList, @Param("tenantCode") String tenantCode);
}

