package com.biz.crm.tpm.business.activity.detail.plan.local.modify.consumer;

import com.biz.crm.mn.common.rocketmq.service.AbstractRocketMqConsumer;
import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.mn.common.rocketmq.util.RocketMqUtil;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.service.ActivityDetailPlanModifyService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.modify.constant.ActivityDetailPlanModifyMqConstant;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.modify.enums.ActivityDetailPlanModifyMqTagEnum;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.constant.ActivityPlanModifyMqConstant;
import com.biz.crm.tpm.business.marketing.strategy.sdk.enums.MarketingStrategyModifyMqTagEnum;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.spring.annotation.ConsumeMode;
import org.apache.rocketmq.spring.annotation.MessageModel;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Objects;

/**
 * @author wanghaojia
 * @date 2023/1/16 19:59
 */
@Slf4j
@Component
@RocketMQMessageListener(topic = ActivityDetailPlanModifyMqConstant.PROCESS_PASS_TOPIC + "${rocketmq.environment}",
        /**
         * tag
         * 可用 || 监听多个tag： "tag1 || tag2 || tag3"
         * 请把tag  定义在 *** 内 需要统一维护
        */
        selectorExpression = ActivityDetailPlanModifyMqConstant.PASS_UPDATE_ORIGIN,
        /**
         * 相同分组下 consumer 可自动负载均衡
         * 请把consumerGroup  定义在 *** 内 需要统一维护
        */
        consumerGroup = ActivityDetailPlanModifyMqConstant.PASS_UPDATE_ORIGIN + "${rocketmq.environment}",
        /**
         * 默认集群消费MqConstant
         * 可以设置 ConsumeMode.ORDERLY 使用广播消费
         * 也可使用集群模式模拟广播模式：
         * 启动多个不同 consumerGroup 的consumer实例
        */
        consumeMode = ConsumeMode.CONCURRENTLY,
        /**
         * 集群消费or广播消费;默认是集群消费
        */
        messageModel = MessageModel.CLUSTERING)
public class ActivityDetailPlanModifyPassUpdatePlanConsumer extends AbstractRocketMqConsumer {

    @Autowired
    private ActivityDetailPlanModifyService activityPlanModifyService;

    @Autowired(required = false)
    private RocketMqProducer rocketMqProducer;

    @Override
    protected Object handleMessage(MqMessageVo message) {
        log.info(ActivityDetailPlanModifyMqTagEnum.PASS_UPDATE_ORIGIN.getName()+" order mq message received  : {}", message);
        if (Objects.isNull(message)
                || StringUtils.isEmpty(message.getMsgBody())) {
            return "消息为空!";
        }

        try {
            //更新原数据
            String businessNo = message.getMsgBody();
            activityPlanModifyService.doUpdateOriginData(businessNo);
            //更新成功之后发送mq消息更新sd等信息
            passPushMq(businessNo);
        }catch (Exception e){
            log.error(ActivityDetailPlanModifyMqTagEnum.PASS_UPDATE_ORIGIN.getName()+"处理失败"+e.getMessage(),e);
            return "消费失败."+e.getMessage();
        }

        return "消费成功.";
    }


    /**
     * 审批通过推送mq处理
     * @param businessNo 业务编码
     */
    private void passPushMq(String businessNo){
        if (StringUtils.isEmpty(businessNo)){
            return;
        }

        List<ActivityDetailPlanModifyMqTagEnum> pushTagList = Lists.newArrayList();
        for (ActivityDetailPlanModifyMqTagEnum mqTagEnum : ActivityDetailPlanModifyMqTagEnum.values()) {
            if (ActivityDetailPlanModifyMqTagEnum.PushType.after_update_origin.equals(mqTagEnum.getPushType())){
                pushTagList.add(mqTagEnum);
            }
        }

        if (CollectionUtils.isEmpty(pushTagList)){
            return;
        }

        for (ActivityDetailPlanModifyMqTagEnum mqTagEnum : pushTagList) {
            MqMessageVo mqMessageVo = new MqMessageVo();
            mqMessageVo.setMsgBody(businessNo);
            mqMessageVo.setTopic(ActivityDetailPlanModifyMqConstant.PROCESS_PASS_TOPIC + RocketMqUtil.mqEnvironment());
            mqMessageVo.setTag(mqTagEnum.getCode());
            rocketMqProducer.sendMqMsg(mqMessageVo);
        }
    }

}
