package com.biz.crm.tpm.business.activity.detail.plan.local.modify.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mn.common.page.cache.controller.MnPageCacheController;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.vo.ActivityDetailPlanModifyFieldValue;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemModifyDto;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.service.ActivityDetailPlanItemModifyService;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.vo.ActivityDetailPlanItemModifyVo;
import com.biz.crm.tpm.business.activity.detail.plan.local.vo.ActivityDetailPlanBudgetSumVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author wanghaojia
 * @date 2022/12/9 15:18
 */
@RestController
@RequestMapping("/v1/activityDetailPlanItemModify")
@Slf4j
@Api(tags = "活动细案变更明细")
public class ActivityDetailPlanItemModifyController extends MnPageCacheController<ActivityDetailPlanItemModifyVo, ActivityDetailPlanItemModifyDto> {

    @Autowired(required = false)
    private ActivityDetailPlanItemModifyService activityDetailPlanItemModifyService;

    /**
     * 获取预算汇总信息
     *
     * @param cacheKey 缓存key
     * @return
     */
    @ApiOperation(value = "获取预算汇总信息")
    @PostMapping("findBudgetCacheSumList")
    public Result<List<ActivityDetailPlanBudgetSumVo>> findBudgetCacheSumList(@ApiParam(name = "cacheKey", value = "缓存键") @RequestParam String cacheKey) {
        try {
            List<ActivityDetailPlanBudgetSumVo> list = this.activityDetailPlanItemModifyService.findBudgetCacheSumList(cacheKey);
            return Result.ok(list);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    /**
     * 策略调整前数据查询
     */
    @ApiOperation(value = "策略调整前数据查询")
    @PostMapping(value = "findItemModifyLFieldValueListByProcessNo")
    public Result<List<ActivityDetailPlanModifyFieldValue>> findItemModifyLFieldValueListByProcessNo(@ApiParam(value = "流程编号")@RequestParam String processNo){
        try {
            List<ActivityDetailPlanModifyFieldValue> list = this.activityDetailPlanItemModifyService.findItemModifyLFieldValueListByProcessNo(processNo);
            return Result.ok(list);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

}
