package com.biz.crm.tpm.business.activity.detail.plan.local.modify.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.dto.ActivityDetailPlanModifyApproveSubmitDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanModifyDto;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.service.ActivityDetailPlanModifyService;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.vo.ActivityDetailPlanModifyVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 活动细案变更
 * @author wanghaojia
 * @date 2022/12/9 15:18
 */
@RestController
@RequestMapping("/v1/activityDetailPlanModify")
@Slf4j
@Api(tags = "活动细案变更")
public class ActivityDetailPlanModifyController {


    @Autowired(required = false)
    private ActivityDetailPlanModifyService activityDetailPlanModifyService;

    /**
     * 获取待调整的方案数据
     */
    @ApiOperation(value = "获取待调整的细案数据")
    @GetMapping(value = "findToModifyList")
    public Result<Page<ActivityDetailPlanVo>> findToModifyList(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                               @ApiParam(name = "dto",value = "查询条件") ActivityDetailPlanDto dto){
        try {
            Page<ActivityDetailPlanVo> page = this.activityDetailPlanModifyService.findToModifyList(pageable, dto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 新增数据
     * @param cacheKey 明细缓存键
     * @param dto 实体对象
     * @return 新增结果
     */
    @ApiOperation(value = "新增数据")
    @PostMapping(value = "create")
    public Result<?> create(@ApiParam(name = "cacheKey", value = "缓存键")@RequestParam String cacheKey,
                            @ApiParam(name = "dto", value = "分子公司细案变更表头")@RequestBody ActivityDetailPlanModifyDto dto) {
        try {
            this.activityDetailPlanModifyService.saveActivityDetailPlan(dto,cacheKey);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 新增数据
     * @param cacheKey 明细缓存键
     * @param dto 实体对象
     * @return 新增结果
     */
    @ApiOperation(value = "更新数据")
    @PatchMapping(value = "update")
    public Result<?> update(@ApiParam(name = "cacheKey", value = "缓存键")@RequestParam String cacheKey,
                            @ApiParam(name = "dto", value = "分子公司细案变更表头")@RequestBody ActivityDetailPlanModifyDto dto) {
        try {
            if (StringUtils.isEmpty(dto.getId())){
                throw new RuntimeException("编辑操作参数有误");
            }
            this.activityDetailPlanModifyService.saveActivityDetailPlan(dto,cacheKey);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    /**
     * 通过id获取营销策略数据
     */
    @ApiOperation(value = "通过id获取营销策略数据")
    @GetMapping("findById")
    public Result<ActivityDetailPlanModifyVo> findById(@ApiParam(value = "id")@RequestParam(required = false) String id,@ApiParam(value = "code")@RequestParam(required = false) String code){
        try {
            ActivityDetailPlanModifyVo vo = this.activityDetailPlanModifyService.findByIdOrCode(id,code);
            return Result.ok(vo);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 提交审批流
     *
     * @param dto 查询对象
     * @return
     */
    @ApiOperation(value = "提交审批流")
    @PostMapping("/submit")
    public Result submit(@RequestBody ActivityDetailPlanModifyApproveSubmitDto dto) {
        try {
            this.activityDetailPlanModifyService.submit(dto);
            return Result.ok("提交成功");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 删除策略调整
     * @param ids 策略ids
     */
    @ApiOperation(value = "删除")
    @DeleteMapping(value = "delete")
    public Result delete(@ApiParam(value = "策略id集合")@RequestParam List<String> ids){
        try {
            this.activityDetailPlanModifyService.delete(ids);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 审批通过修改源数据
     */
    @ApiOperation(value = "审批通过修改源数据")
    @PostMapping(value = "doUpdateOriginData")
    public Result doUpdateOriginData(@ApiParam(value = "方案变更编码")@RequestParam String modifyBusinessCode){
        try {
            this.activityDetailPlanModifyService.doUpdateOriginData(modifyBusinessCode);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 审批通过退预算
     */
    @ApiOperation(value = "审批通过退预算")
    @PostMapping(value = "passReturnMonthBudgetByModifyCode")
    public Result passReturnMonthBudgetByModifyCode(@ApiParam(value = "方案变更编码")@RequestParam String modifyBusinessCode){
        try {
            this.activityDetailPlanModifyService.passReturnMonthBudgetByModifyCode(modifyBusinessCode);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 方案变更通过自动变更细案
     */
    @ApiOperation(value = "方案变更通过自动变更细案")
    @PostMapping(value = "planModifyUpdateDetailPlan")
    public Result planModifyUpdateDetailPlan(@ApiParam(value = "方案变更编码")@RequestParam String modifyBusinessCode){
        try {
            this.activityDetailPlanModifyService.planModifyUpdateDetailPlan(modifyBusinessCode);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

}
