package com.biz.crm.tpm.business.activity.detail.plan.local.modify.entity;


import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 活动细案明细表(ActivityDetailPlanItem)
 *
 * @author wanghaojia
 * @since 2022-11-12 15:14:12
 */
@ApiModel(value = "ActivityDetailPlanItemModify", description = "活动细案明细变更表")
@TableName("tpm_activity_detail_plan_item_modify")
@Getter
@Setter
@Entity(name = "tpm_activity_detail_plan_item_modify")
@org.hibernate.annotations.Table(appliesTo = "tpm_activity_detail_plan_item_modify", comment = "活动细案明细变更表")
@Table(
    name = "tpm_activity_detail_plan_item_modify",
    indexes = {
        @Index(name = "activity_detail_plan_item_modify_inx1", columnList = "modify_business_code,", unique = false),
    }
)
public class ActivityDetailPlanItemModify extends TenantFlagOpEntity {

    /**
     * 变更编码
     */
    @ApiModelProperty("变更编码")
    @Column(name = "modify_business_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '变更编码'")
    private String modifyBusinessCode;

    /**
     * 活动细案编码
     */
    @ApiModelProperty("活动细案编码")
    @Column(name = "detail_plan_code", length = 32, columnDefinition = "varchar(32) COMMENT '活动细案编码'")
    private String detailPlanCode;
    /**
     * 活动细案名称
     */
    @ApiModelProperty("活动细案明细编码")
    @Column(name = "detail_plan_item_code", length = 255, columnDefinition = "varchar(255) COMMENT '活动细案明细编码'")
    private String detailPlanItemCode;

    /**
     * 方案模板编码
     */
    @ApiModelProperty("方案模板编码")
    @Column(name = "template_config_code", length = 32, columnDefinition = "varchar(32) COMMENT '方案模板编码'")
    private String templateConfigCode;

    /**
     * 活动类型编码
     */
    @ApiModelProperty("活动类型编码")
    @Column(name = "activity_type_code", length = 255, columnDefinition = "varchar(255) COMMENT '活动类型编码'")
    private String activityTypeCode;
    /**
     * 活动类型名称
     */
    @ApiModelProperty("活动类型名称")
    @Column(name = "activity_type_name", length = 255, columnDefinition = "varchar(255) COMMENT '活动类型名称'")
    private String activityTypeName;
    /**
     * 活动形式编码
     */
    @ApiModelProperty("活动形式编码")
    @Column(name = "activity_form_code", length = 255, columnDefinition = "varchar(255) COMMENT '活动形式编码'")
    private String activityFormCode;
    /**
     * 活动形式名称
     */
    @ApiModelProperty("活动形式名称")
    @Column(name = "activity_form_name", length = 255, columnDefinition = "varchar(255) COMMENT '活动形式名称'")
    private String activityFormName;


    /**
     * 活动开始时间
     */
    @ApiModelProperty("活动开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "activity_begin_date", columnDefinition = "datetime COMMENT '活动开始时间'")
    private Date activityBeginDate;
    /**
     * 活动结束时间
     */
    @ApiModelProperty("活动结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "activity_end_date",  columnDefinition = "datetime COMMENT '活动结束时间'")
    private Date activityEndDate;

    /**
     * 订单开始时间
     */
    @ApiModelProperty("订单开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "order_begin_date",  columnDefinition = "datetime COMMENT '活动结束时间'")
    private Date orderBeginDate;
    /**
     * 订单结束时间
     */
    @ApiModelProperty("订单结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "order_end_date",  columnDefinition = "datetime COMMENT '活动结束时间'")
    private Date orderEndDate;
    /**
     * 期间促销件数
     */
    @ApiModelProperty("期间促销件数")
    @Column(name = "period_promotional_number", length = 11, columnDefinition = "int(11) COMMENT '期间促销件数'")
    private Integer periodPromotionalNumber;   /**
     * 期间促销金额
     */
    @ApiModelProperty("期间促销金额")
    @Column(name = "period_promotional_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '期间促销金额'")
    private BigDecimal periodPromotionalAmount;

    /**
     * 一级管理渠道编码
     */
    @ApiModelProperty("一级管理渠道编码")
    @Column(name = "first_channel_code", length = 32, columnDefinition = "varchar(32) COMMENT '一级管理渠道编码'")
    private String firstChannelCode;
    /**
     * 一级管理渠道名称
     */
    @ApiModelProperty("一级管理渠道名称")
    @Column(name = "first_channel_name", length = 256, columnDefinition = "varchar(256) COMMENT '一级管理渠道名称'")
    private String firstChannelName;
    /**
     * 二级管理渠道编码
     */
    @ApiModelProperty("二级管理渠道编码")
    @Column(name = "second_channel_code", length = 32, columnDefinition = "varchar(32) COMMENT '二级管理渠道编码'")
    private String secondChannelCode;
    /**
     * 二级管理渠道名称
     */
    @ApiModelProperty("二级管理渠道名称")
    @Column(name = "second_channel_name", length = 256, columnDefinition = "varchar(256) COMMENT '二级管理渠道名称'")
    private String secondChannelName;

    /**
     * 品牌编码
     */
    @ApiModelProperty("品牌编码")
    @Column(name = "product_brand_code", length = 32, columnDefinition = "varchar(32) COMMENT '品牌编码'")
    private String productBrandCode;
    /**
     * 品牌名称
     */
    @ApiModelProperty("品牌名称")
    @Column(name = "product_brand_name", length = 255, columnDefinition = "varchar(255) COMMENT '品牌名称'")
    private String productBrandName;
    /**
     * 品类编码
     */
    @ApiModelProperty("品类编码")
    @Column(name = "product_category_code", length = 32, columnDefinition = "varchar(32) COMMENT '品类编码'")
    private String productCategoryCode;
    /**
     * 品类名称
     */
    @ApiModelProperty("品类名称")
    @Column(name = "product_category_name", length = 255, columnDefinition = "varchar(255) COMMENT '品类名称'")
    private String productCategoryName;
    /**
     * 品项编码
     */
    @ApiModelProperty("品项编码")
    @Column(name = "product_item_code", length = 32, columnDefinition = "varchar(32) COMMENT '品项编码'")
    private String productItemCode;
    /**
     * 品项名称
     */
    @ApiModelProperty("品项名称")
    @Column(name = "product_item_name", length = 255, columnDefinition = "varchar(255) COMMENT '品项名称'")
    private String productItemName;
    /**
     * 产品编码
     */
    @ApiModelProperty("产品编码")
    @Column(name = "product_code", length = 512, columnDefinition = "varchar(512) COMMENT '产品编码'")
    private String productCode;
    /**
     * 产品名称
     */
    @ApiModelProperty("产品名称")
    @Column(name = "product_name", length = 2000, columnDefinition = "varchar(2000) COMMENT '产品名称'")
    private String productName;
    /**
     * 单位编码
     */
    @ApiModelProperty("单位编码")
    @Column(name = "product_unit", length = 32, columnDefinition = "varchar(32) COMMENT '单位编码'")
    private String productUnit;
    /**
     * 原品价格
     */
    @ApiModelProperty("原品价格")
    @Column(name = "product_price", length = 32, columnDefinition = "decimal(24,6) COMMENT '原品价格'")
    private BigDecimal productPrice;
    /**
     * 原品数量
     */
    @ApiModelProperty("原品数量")
    @Column(name = "product_quantity", length = 32, columnDefinition = "int(11) COMMENT '原品数量'")
    private Integer productQuantity;
    /**
     * 赠品编码
     */
    @ApiModelProperty("赠品编码")
    @Column(name = "gift_code", length = 32, columnDefinition = "varchar(32) COMMENT '单位编码'")
    private String giftCode;
    /**
     * 赠品名称
     */
    @ApiModelProperty("赠品名称")
    @Column(name = "gift_name", length = 255, columnDefinition = "varchar(255) COMMENT '赠品名称'")
    private String giftName;
    /**
     * 赠品价格
     */
    @ApiModelProperty("赠品价格")
    @Column(name = "gift_price", length = 32, columnDefinition = "decimal(24,6) COMMENT '赠品价格'")
    private BigDecimal giftPrice;
    /**
     * 赠品数量
     */
    @ApiModelProperty("赠品数量")
    @Column(name = "gift_quantity", length = 32, columnDefinition = "int(11) COMMENT '赠品数量'")
    private Integer giftQuantity;
    /**
     * 赠品总量
     */
    @ApiModelProperty("赠品总量")
    @Column(name = "gift_weight", length = 32, columnDefinition = "int(11) COMMENT '赠品总量'")
    private Integer giftWeight;

    /**
     * 月销售任务
     */
    @ApiModelProperty("月销售任务")
    @Column(name = "month_sales_target", length = 24, columnDefinition = "decimal(24,6) COMMENT '月销售任务'")
    private BigDecimal monthSalesTarget;
    /**
     * 目前铺市率
     */
    @ApiModelProperty("目前铺市率")
    @Column(name = "current_market_rate", length = 24, columnDefinition = "decimal(24,6) COMMENT '目前铺市率'")
    private BigDecimal currentMarketRate;
    /**
     * 月目标铺市率
     */
    @ApiModelProperty("月目标铺市率")
    @Column(name = "month_target_market_rate", length = 24, columnDefinition = "decimal(24,6) COMMENT '月目标铺市率'")
    private BigDecimal monthTargetMarketRate;
    /**
     * 是否发起巡查需求
     */
    @ApiModelProperty("是否发起巡查需求")
    @Column(name = "is_start_patrol", length = 32, columnDefinition = "varchar(32) COMMENT '是否发起巡查需求'")
    private String isStartPatrol;
    /**
     * 期间促销量（件）
     */
    @ApiModelProperty("期间促销量（件）")
    @Column(name = "period_promote_quantity", length = 24, columnDefinition = "decimal(24,6) COMMENT '期间促销量（件）'")
    private BigDecimal periodPromoteQuantity;
    /**
     * 期间促销额（元）
     */
    @ApiModelProperty("期间促销额（元）")
    @Column(name = "period_promote_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '期间促销额（元）'")
    private BigDecimal periodPromoteAmount;
    /**
     * 期间渠道促销量（件）
     */
    @ApiModelProperty("期间渠道促销量（件）")
    @Column(name = "period_ch_promote_quantity", length = 24, columnDefinition = "decimal(24,6) COMMENT '期间渠道促销量（件）'")
    private BigDecimal periodChPromoteQuantity;
    /**
     * 期间渠道促销额（元）
     */
    @ApiModelProperty("期间渠道促销额（元）")
    @Column(name = "period_ch_promote_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '期间渠道促销额（元）'")
    private BigDecimal periodChPromoteAmount;
    /**
     * 全月回复量（件）
     */
    @ApiModelProperty("全月回复量（件）")
    @Column(name = "month_return_quantity", length = 24, columnDefinition = "decimal(24,6) COMMENT '全月回复量（件）'")
    private BigDecimal monthReturnQuantity;
    /**
     * 全月回复额（元）
     */
    @ApiModelProperty("全月回复额（元）")
    @Column(name = "month_return_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '全月回复额（元）'")
    private BigDecimal monthReturnAmount;
    /**
     * 本月投入产出比
     */
    @ApiModelProperty("本月投入产出比")
    @Column(name = "month_put_output_ratio", length = 24, columnDefinition = "decimal(24,6) COMMENT '本月投入产出比'")
    private BigDecimal monthPutOutputRatio;

    /**
     * 门店编码
     */
    @ApiModelProperty("门店编码")
    @Column(name = "terminal_code", length = 32, columnDefinition = "varchar(32) COMMENT '门店编码'")
    private String terminalCode;
    /**
     * 门店名称
     */
    @ApiModelProperty("门店名称")
    @Column(name = "terminal_name", length = 255, columnDefinition = "varchar(255) COMMENT '门店名称'")
    private String terminalName;
    /**
     * 门店类型
     */
    @ApiModelProperty(name = "门店类型", notes = "门店类型")
    @Column(name = "terminal_type", length = 32, columnDefinition = "VARCHAR(32) COMMENT '门店类型'")
    private String terminalType;

    /**
     * 门店预计月销售额
     */
    @ApiModelProperty("门店预计月销售额")
    @Column(name = "terminal_month_sales_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '门店预计月销售额'")
    private BigDecimal terminalMonthSalesAmount;

    /**
     * 身份证号码
     */
    @ApiModelProperty("身份证号码")
    @Column(name = "person_id_card", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '身份证号码 '")
    private String personIdCard;
    /**
     * 人员类型
     */
    @ApiModelProperty("人员类型")
    @Column(name = "person_type", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '人员类型 '")
    private String personType;
    /**
     * 人员名称
     */
    @ApiModelProperty("人员名称")
    @Column(name = "person_name", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '人员名称 '")
    private String personName;
    /**
     * 人员编码
     */
    @ApiModelProperty("人员编码")
    @Column(name = "person_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '人员编码 '")
    private String personCode;

    /**
     * 物料编码
     */
    @ApiModelProperty("物料编码")
    @Column(name = "material_code", length = 32, columnDefinition = "varchar(32) COMMENT '物料编码'")
    private String materialCode;
    /**
     * 物料名称
     */
    @ApiModelProperty("物料名称")
    @Column(name = "material_name", length = 255, columnDefinition = "varchar(255) COMMENT '物料名称'")
    private String materialName;
    /**
     * 物料单位
     */
    @ApiModelProperty("物料单位")
    @Column(name = "material_unit", length = 32, columnDefinition = "varchar(32) COMMENT '物料单位'")
    private String materialUnit;
    /**
     * 物料单价
     */
    @ApiModelProperty("物料单价")
    @Column(name = "material_price", length = 24, columnDefinition = "decimal(24,6) COMMENT '物料单价'")
    private BigDecimal materialPrice;
    /**
     * 物料数量
     */
    @ApiModelProperty("物料数量")
    @Column(name = "material_quantity", length = 11, columnDefinition = "int(11) COMMENT '物料数量'")
    private BigDecimal materialQuantity;


    /**
     * 数量
     */
    @ApiModelProperty("数量")
    @Column(name = "quantity", length = 11, columnDefinition = "int(11) COMMENT '数量'")
    private Integer quantity;

    /**
     * 单价
     */
    @ApiModelProperty("单价")
    @Column(name = "price", length = 32, columnDefinition = "varchar(32) COMMENT '陈列类型'")
    private BigDecimal price;

    /**
     * 采购类型
     */
    @ApiModelProperty("采购类型")
    @Column(name = "procurement_type", length = 32, columnDefinition = "varchar(32) COMMENT '采购类型'")
    private String procurementType;


    /**
     * 费用金额
     */
    @ApiModelProperty("费用金额")
    @Column(name = "fee_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '费用金额'")
    private BigDecimal feeAmount;

    /**
     * 大区承担金额
     */
    @ApiModelProperty("大区承担金额")
    @Column(name = "department_fee_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '大区承担金额'")
    private BigDecimal departmentFeeAmount;
    /**
     * 已发生大区费用
     */
    @ApiModelProperty("已发生大区费用")
    @Column(name = "used_department_fee_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '已发生大区费用'")
    private BigDecimal usedDepartmentFeeAmount;
    /**
     * 客户承担金额
     */
    @ApiModelProperty("客户承担金额")
    @Column(name = "customer_fee_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '客户承担金额'")
    private BigDecimal customerFeeAmount;
    /**
     * 已发生客户费用
     */
    @ApiModelProperty("已发生客户费用")
    @Column(name = "used_customer_fee_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '已发生客户费用'")
    private BigDecimal usedCustomerFeeAmount;
    /**
     * 费用合计
     */
    @ApiModelProperty("费用合计")
    @Column(name = "total_fee_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '费用合计'")
    private BigDecimal totalFeeAmount;
    /**
     * 总部承担金额
     */
    @ApiModelProperty("总部承担金额")
    @Column(name = "head_fee_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '总部承担金额'")
    private BigDecimal headFeeAmount;
    /**
     * 已发生总部费用
     */
    @ApiModelProperty("已发生总部费用")
    @Column(name = "used_head_fee_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '已发生总部费用'")
    private BigDecimal usedHeadFeeAmount;
    /**
     * 大区公投预算金额
     */
    @ApiModelProperty("大区公投预算金额（元）")
    @Column(name = "region_referendum_fee_amount", nullable = true, length = 24, columnDefinition = "decimal(24,6) COMMENT '大区公投预算金额（元）'")
    private BigDecimal regionReferendumFeeAmount;

    /**
     * 大区自投预算金额
     */
    @ApiModelProperty("大区自投预算金额（元）")
    @Column(name = "region_automatic_fee_amount", nullable = true, length = 24, columnDefinition = "decimal(24,6) COMMENT '大区自投预算金额（元）'")
    private BigDecimal regionAutomaticFeeAmount;

    /**
     * 分子公司点内金额
     */
    @ApiModelProperty("分子公司点内金额")
    @Column(name = "intra_company_amount", columnDefinition = "DECIMAL(24,6) COMMENT '分子公司点内金额'")
    private BigDecimal intraCompanyAmount;

    /**
     * 分子公司点外金额
     */
    @ApiModelProperty("分子公司点外金额")
    @Column(name = "off_point_amount", columnDefinition = "DECIMAL(24,6) COMMENT '分子公司点外金额'")
    private BigDecimal offPointAmount;
    @ApiModelProperty("是否扣减费用池")
    @Column(name = "is_deduction_fee_pool", length = 255, columnDefinition = "varchar(16) COMMENT '是否扣减费用池'")
    private String isDeductionFeePool;
    /**
     * 核销类型
     */
    @ApiModelProperty("核销类型")
    @Column(name = "audit_type", length = 30, columnDefinition = "varchar(30) COMMENT '核销类型'")
    private String auditType;
    /**
     * 核销条件编码
     */
    @ApiModelProperty("核销条件编码")
    @Column(name = "audit_condition_code", length = 32, columnDefinition = "varchar(32) COMMENT '核销条件编码'")
    private String auditConditionCode;
    /**
     * 核销条件名称
     */
    @ApiModelProperty("核销条件名称")
    @Column(name = "audit_condition_name", length = 255, columnDefinition = "varchar(255) COMMENT '核销条件名称'")
    private String auditConditionName;
    /**
     * 结案形式
     */
    @ApiModelProperty("结案形式")
    @Column(name = "audit_form", length = 32, columnDefinition = "varchar(32) COMMENT '结案形式'")
    private String auditForm;
    /**
     * 付款方式
     */
    @ApiModelProperty("付款方式")
    @Column(name = "payment_method", length = 32, columnDefinition = "varchar(32) COMMENT '付款方式'")
    private String paymentMethod;
    /**
     * 是否和价格有关
     */
    @ApiModelProperty("是否和价格有关")
    @Column(name = "relate_to_price", length = 10, columnDefinition = "varchar(10) COMMENT '是否和价格有关'")
    private String relateToPrice;


    /**
     * 形式说明
     */
    @ApiModelProperty("形式说明")
    @CrmExcelColumn(value = "形式说明")
    @Column(name = "form_description", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '形式说明'")
    private String formDescription;

    /**
     * 是否涨价政策
     */
    @ApiModelProperty("是否涨价政策")
    @CrmExcelColumn(value = "是否涨价政策")
    @Column(name = "increase_price_promotion", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '是否涨价政策'")
    private String increasePricePromotion;

    /**
     * 是否责任利润调整
     */
    @ApiModelProperty("是否责任利润调整")
    @Column(name = "duty_profit_adjust", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '是否责任利润调整'")
    private String dutyProfitAdjust;

    /**
     * 促销对象
     */
    @ApiModelProperty("促销对象")
    @Column(name = "promotion_object", length = 32, columnDefinition = "varchar(32) COMMENT '促销对象'")
    private String promotionObject;

    /**
     * 新品归类
     */
    @ApiModelProperty("新品归类")
    @Column(name = "new_product_type", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '新品归类'")
    private String newProductType;
    /**
     * 扣款方式
     */
    @ApiModelProperty("扣款方式/是否扣款，   Y是N否")
    @Column(name = "deduct_type", length = 32, columnDefinition = "varchar(32) COMMENT '扣款方式'")
    private String deductType;
    /**
     * 是否占用划拨预算
     */
    @ApiModelProperty("是否占用划拨预算")
    @Column(name = "occupy_transfer_budget", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '是否占用划拨预算'")
    private String occupyTransferBudget;
    /**
     * 活动力度
     */
    @ApiModelProperty("活动力度")
    @Column(name = "activity_intensity", nullable = true, length = 255, columnDefinition = "varchar(255) COMMENT '活动力度'")
    private String activityIntensity;


    @ApiModelProperty("陈列批次")
    @Column(name = "display_lot", columnDefinition = "VARCHAR(1) COMMENT '陈列批次'")
    private String displayLot;

    @ApiModelProperty("是否客户上账")
    @Column(name = "is_customer_account", columnDefinition = "VARCHAR(1) COMMENT '是否客户上账'")
    private String isCustomerAccount;

    /**
     * 承接类型编码 字典编码 accept_type
     */
    @ApiModelProperty("活动承接形式")
    @Column(name = "undertaking_mode", length = 32, columnDefinition = "VARCHAR(32) COMMENT '活动承接形式'")
    private String undertakingMode;

    /**
     * 调整前版本号
     */
    @ApiModelProperty("调整前变更编码")
    @Column(name = "curr_modify_business_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '调整前版本号'")
    private String currModifyBusinessCode;
}

