package com.biz.crm.tpm.business.activity.detail.plan.local.modify.entity;


import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * 活动细案(ActivityDetailPlan)
 *
 * @author wanghaojia
 * @since 2022-11-05 10:22:21
 */
@ApiModel(value = "ActivityDetailPlanModify", description = "活动细案变更")
@TableName("tpm_activity_detail_plan_modify")
@Getter
@Setter
@Entity(name = "tpm_activity_detail_plan_modify")
@org.hibernate.annotations.Table(appliesTo = "tpm_activity_detail_plan_modify", comment = "活动细案变更")
@Table(
    name = "tpm_activity_detail_plan_modify",
    indexes = {
            @Index(name = "tpm_activity_detail_plan_modify_inx1", columnList = "modify_business_code",unique = true),
        @Index(name = "tpm_activity_detail_plan_modify_inx2", columnList = "detail_plan_code"),
    }
)
public class ActivityDetailPlanModify extends TenantFlagOpEntity {

    /**
     * 变更编码
     */
    @ApiModelProperty("变更编码")
    @Column(name = "modify_business_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '变更编码'")
    private String modifyBusinessCode;

    /**
     * 活动细案编码
     */
    @ApiModelProperty("活动细案编码")
    @Column(name = "detail_plan_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '活动细案编码'")
    private String detailPlanCode;
    /**
     * 活动细案名称
     */
    @ApiModelProperty("活动细案名称")
    @Column(name = "detail_plan_name", nullable = true, length = 255, columnDefinition = "varchar(255) COMMENT '活动细案名称'")
    private String detailPlanName;

    /**
     * 业态
     */
    @ApiModelProperty("业态 数据字典：mdm_business_format")
    @Column(name = "business_format_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '业态'")
    private String businessFormatCode;
    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty("业务单元")
    @Column(name = "business_unit_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '业务单元'")
    private String businessUnitCode;

    /**
     * 方案模板编码
     */
    @ApiModelProperty("方案模板编码")
    @Column(name = "template_config_code", nullable = true, length = 512, columnDefinition = "varchar(512) COMMENT '方案模板编码'")
    private String templateConfigCode;

    /**
     * 方案模板名称
     */
    @ApiModelProperty("方案模板名称")
    @Column(name = "template_config_name", nullable = true, length = 1024, columnDefinition = "varchar(1024) COMMENT '方案模板名称'")
    private String templateConfigName;

    /**
     * 是否临时方案
     */
    @ApiModelProperty("是否临时方案")
    @Column(name = "is_temporary", length = 1, columnDefinition = "VARCHAR(1) COMMENT '是否临时方案，   Y是N否'")
    private String isTemporary;
    /**
     * 申请金额
     */
    @ApiModelProperty("申请金额")
    @Column(name = "fee_amount", nullable = true, length = 24, columnDefinition = "decimal(24,6) COMMENT '申请金额'")
    private BigDecimal feeAmount;
    /**
     * 总部承担金额
     */
    @ApiModelProperty("总部承担金额")
    @Column(name = "head_fee_amount", nullable = true, length = 24, columnDefinition = "decimal(24,6) COMMENT '总部承担金额'")
    private BigDecimal headFeeAmount;
    /**
     * 大区承担金额
     */
    @ApiModelProperty("大区承担金额")
    @Column(name = "department_fee_amount", nullable = true, length = 24, columnDefinition = "decimal(24,6) COMMENT '大区承担金额'")
    private BigDecimal departmentFeeAmount;
    /**
     * 客户承担金额
     */
    @ApiModelProperty("客户承担金额")
    @Column(name = "customer_fee_amount", nullable = true, length = 24, columnDefinition = "decimal(24,6) COMMENT '客户承担金额'")
    private BigDecimal customerFeeAmount;
    /**
     * 费用合计
     */
    @ApiModelProperty("费用合计")
    @Column(name = "total_fee_amount", nullable = true, length = 24, columnDefinition = "decimal(24,6) COMMENT '费用合计'")
    private BigDecimal totalFeeAmount;

    /**
     * 细案说明
     */
    @ApiModelProperty("细案说明")
    @Column(name = "detail_plan_explain", nullable = true, length = 1000, columnDefinition = "varchar(1000) COMMENT '结案说明'")
    private String detailPlanExplain;
    /**
     * 流程编号
     */
    @ApiModelProperty("流程编号")
    @Column(name = "process_no", nullable = true, length = 64, columnDefinition = "varchar(64) COMMENT '流程编号'")
    private String processNo;
    /**
     * 审批状态
     */
    @ApiModelProperty("审批状态")
    @Column(name = "process_status", nullable = true, length = 10, columnDefinition = "varchar(10) COMMENT '审批状态'")
    private String processStatus;

    @ApiModelProperty("方案编码")
    @Column(name = "plan_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '方案编码'")
    private String planCode;

    /**
     * 部门编码
     */
    @ApiModelProperty("部门编码")
    @Column(name = "department_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '部门编码'")
    private String departmentCode;

    /**
     * 区域编码(字典MDM_CUSTOMIZE_ORG)
     */
    @ApiModelProperty(name = "区域编码", notes = "")
    @Column(name = "region_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '区域编码 '")
    private String regionCode;

    /**
     * 部门编码
     */
    @ApiModelProperty("部门名称")
    @Column(name = "department_name", nullable = true, length = 255, columnDefinition = "varchar(1024) COMMENT '方案结束时间'")
    private String departmentName;

    @ApiModelProperty("是否汇总")
    @Column(name = "is_gather", length = 1, columnDefinition = "varchar(1) COMMENT '是否汇总'")
    private String isGather;

    @ApiModelProperty("汇总维度")
    @Column(name = "summary_dimension", length = 256, columnDefinition = "varchar(256) COMMENT '汇总维度'")
    private String summaryDimension;

}

