package com.biz.crm.tpm.business.activity.detail.plan.local.modify.exports;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemModifyDto;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.service.ActivityDetailPlanItemModifyService;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.vo.ActivityDetailPlanItemModifyExportsVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.constant.ActivityDetailPlanConstant;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.*;

/**
 * @Author : dengwei
 * @Date :2023/8/10  16:31
 * @Description: 活动细案明细调整导出
 */
@Slf4j
@Component
public class ActivityDetailPlanItemModifyExportsProcess implements ExportProcess<ActivityDetailPlanItemModifyExportsVo> {

    @Autowired(required = false)
    private ActivityDetailPlanItemModifyService activityDetailPlanItemModifyService;
    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required = false)
    private DictToolkitService dictToolkitService;


    @Override
    public Integer getPageSize(){
        return CommonConstant.IE_EXPORT_MAX_TOTAL;
    }

    @Override
    public Integer getTotal(Map<String, Object> params) {
        Validate.notNull(params.get("cacheKey"), "缓存键，参数未传入");
        Integer total = activityDetailPlanItemModifyService.getTotal(params);
        Validate.isTrue(total < CommonConstant.IE_EXPORT_MAX_TOTAL, "导出时，" +
                "单次最大导出[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]条,请输入更多查询条件!!");
        return total;
    }

    @Override
    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        Validate.notNull(params.get("cacheKey"), "缓存键，参数未传入");
        List<ActivityDetailPlanItemModifyDto> cacheList = activityDetailPlanItemModifyService.findCacheByDetailPlanCodesForExports(params);
        if (CollectionUtils.isEmpty(cacheList)) {
            return new JSONArray();
        }
        Collection<ActivityDetailPlanItemModifyExportsVo> exportsVos = nebulaToolkitService.copyCollectionByWhiteList(
                cacheList, ActivityDetailPlanItemModifyDto.class, ActivityDetailPlanItemModifyExportsVo.class, LinkedHashSet.class, ArrayList.class);
        //调整
        adjustData(exportsVos);
        return JSON.parseArray(JSON.toJSONString(exportsVos));
    }

    private void adjustData(Collection<ActivityDetailPlanItemModifyExportsVo> data) {
        Map<String, String> poMap = dictToolkitService.findMapByDictTypeCode(ActivityDetailPlanConstant.DICT_TPM_PROMOTION_OBJECT);
        Map<String, String> atMap = dictToolkitService.findMapByDictTypeCode(ActivityDetailPlanConstant.DICT_TPM_AUDIT_TYPE);
        Map<String, String> ynMap = dictToolkitService.findMapByDictTypeCode(ActivityDetailPlanConstant.DICT_YESORNO);

        for (ActivityDetailPlanItemModifyExportsVo vo : data) {
            if (null != vo.getActivityBeginDate()) {
                vo.setActivityBeginDateStr(DateUtil.dateToStr(DateUtil.date_yyyy_MM_dd, vo.getActivityBeginDate()));
            }
            if (null != vo.getActivityEndDate()) {
                vo.setActivityEndDateStr(DateUtil.dateToStr(DateUtil.date_yyyy_MM_dd, vo.getActivityEndDate()));
            }
            if (null != vo.getOrderBeginDate()) {
                vo.setOrderBeginDateStr(DateUtil.dateToStr(DateUtil.date_yyyy_MM_dd, vo.getOrderBeginDate()));
            }
            if (null != vo.getOrderEndDate()) {
                vo.setOrderEndDateStr(DateUtil.dateToStr(DateUtil.date_yyyy_MM_dd, vo.getOrderEndDate()));
            }
            if (StringUtils.isNotBlank(vo.getPromotionObject())) {
                vo.setPromotionObject(poMap.getOrDefault(vo.getPromotionObject(), vo.getPromotionObject()));
            }
            if (StringUtils.isNotBlank(vo.getAuditType())) {
                vo.setAuditType(atMap.getOrDefault(vo.getAuditType(), vo.getAuditType()));
            }
            if (StringUtils.isNotBlank(vo.getIsStartPatrol())) {
                vo.setIsStartPatrol(ynMap.getOrDefault(vo.getIsStartPatrol(), vo.getIsStartPatrol()));
            }
            if (StringUtils.isNotBlank(vo.getRelateToPrice())) {
                vo.setRelateToPrice(ynMap.getOrDefault(vo.getRelateToPrice(), vo.getRelateToPrice()));
            }
            if (StringUtils.isNotBlank(vo.getIncreasePricePromotion())) {
                vo.setIncreasePricePromotion(ynMap.getOrDefault(vo.getIncreasePricePromotion(), vo.getIncreasePricePromotion()));
            }
            if (StringUtils.isNotBlank(vo.getDeductType())) {
                vo.setDeductType(ynMap.getOrDefault(vo.getDeductType(), vo.getDeductType()));
            }
            if (StringUtils.isNotBlank(vo.getDutyProfitAdjust())) {
                vo.setDutyProfitAdjust(ynMap.getOrDefault(vo.getDutyProfitAdjust(), vo.getDutyProfitAdjust()));
            }
            if (StringUtils.isNotBlank(vo.getOccupyTransferBudget())) {
                vo.setOccupyTransferBudget(ynMap.getOrDefault(vo.getOccupyTransferBudget(), vo.getOccupyTransferBudget()));
            }


        }
    }

    @Override
    public String getBusinessCode() {
        return "TPM_ACTIVITY_DETAIL_PLAN_ITEM_MODIFY_EXPORT";
    }

    @Override
    public String getBusinessName() {
        return "活动细案明细调整导出";
    }
}
