package com.biz.crm.tpm.business.activity.detail.plan.local.modify.listener;

import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.rocketmq.event.RocketMqProducerEvent;
import com.biz.crm.mn.common.rocketmq.util.RocketMqUtil;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.service.ActivityDetailPlanModifyService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.constant.ActivityDetailPlanConstant;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.modify.constant.ActivityDetailPlanModifyMqConstant;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.modify.enums.ActivityDetailPlanModifyMqTagEnum;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.listener.ProcessCompleteListener;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Objects;

/**
 * 分子公司活动细案审批通过
 */
@Slf4j
@Component
public class ActivityDetailPlanModifyCompleteListener implements ProcessCompleteListener {

    @Autowired(required = false)
    private ActivityDetailPlanModifyService activityPlanModifyService;

    @Autowired(required = false)
    private ApplicationEventPublisher eventPublisher;

    @Autowired(required = false)
    private LoginUserService loginUserService;


    @Override
    public String getBusinessCode() {
        return ActivityDetailPlanConstant.PROCESS_NAME_ACTIVITY_DETAIL_PLAN_MODIFY;
    }

    @Override
    public void onProcessComplete(ProcessStatusDto dto) {

        if (StringUtils.isEmpty(dto.getBusinessNo())) {
            return;
        }
        String processStatus = dto.getProcessStatus();
        Validate.notEmpty(dto.getProcessNo(), "流程编码不能为空！");

        //审批通过
        if (ProcessStatusEnum.PASS.getDictCode().equals(processStatus)) {
            activityPlanModifyService.processPass(dto);
            passPushMq(dto.getProcessNo(), dto.getBusinessNo());
        }
        //审批驳回|流程追回
        else if (ProcessStatusEnum.REJECT.getDictCode().equals(processStatus) ||
                ProcessStatusEnum.RECOVER.getDictCode().equals(processStatus)) {
            activityPlanModifyService.processRejectAndRecover(dto);
        }

    }

    /**
     * 审批通过推送mq处理
     * @param processNo 流程编号
     * @param businessNo 业务编码
     */
    private void passPushMq(String processNo,String businessNo){
        if (StringUtils.isEmpty(businessNo)){
            return;
        }

        List<ActivityDetailPlanModifyMqTagEnum> pushTagList = Lists.newArrayList();
        for (ActivityDetailPlanModifyMqTagEnum mqTagEnum : ActivityDetailPlanModifyMqTagEnum.values()) {
            if (ActivityDetailPlanModifyMqTagEnum.PushType.code.equals(mqTagEnum.getPushType())){
                pushTagList.add(mqTagEnum);
            }
        }

        if (CollectionUtils.isEmpty(pushTagList)){
            return;
        }
        String accountJson = "";
        String currentAccount = "";
        if (loginUserService != null) {
            currentAccount = loginUserService.getLoginAccountName();
            AbstractCrmUserIdentity userIdentity = loginUserService.getAbstractLoginUser();
            accountJson = Objects.isNull(userIdentity) ? null : JSON.toJSONString(userIdentity);
        }
        for (ActivityDetailPlanModifyMqTagEnum mqTagEnum : pushTagList) {
            RocketMqProducerEvent rocketMqProducerEvent = new RocketMqProducerEvent(this, currentAccount,  accountJson,
                    false,businessNo,
                    ActivityDetailPlanModifyMqConstant.PROCESS_PASS_TOPIC + RocketMqUtil.mqEnvironment(),
                    mqTagEnum.getCode(),businessNo);
            eventPublisher.publishEvent(rocketMqProducerEvent);
        }
    }

}
