package com.biz.crm.tpm.business.activity.detail.plan.local.modify.register;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 * 活动细案(ActivityDetailPlan)数据视图注册器
 *
 * @author wanghaojia
 * @since 2022-11-11 10:31:00
 */
@Component
public class ActivityDetailPlanModifyDataViewRegister implements DataviewRegister {

  @Override
  public String code() {
    return "tpm_activity_detail_plan_modify_data_view";
  }

  @Override
  public String desc() {
    return "TPM-活动细案变更";
  }

  @Override
  public String buildSql() {
    return "select\n" +
            "a.*\n" +
            " from tpm_activity_detail_plan_modify a\n" +
            "where a.tenant_code = :tenantCode\n" +
            "and a.del_flag = '"+ DelFlagStatusEnum.NORMAL.getCode()+"'";
  }

}
