package com.biz.crm.tpm.business.activity.detail.plan.local.modify.repository;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mn.common.base.util.ObjectConvertStringUtil;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanBudgetModifyDto;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.entity.ActivityDetailPlanBudgetModify;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.mapper.ActivityDetailPlanBudgetModifyMapper;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanBudgetVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.beans.PropertyDescriptor;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


/**
 * 活动方案表(ActivityDetailPlan)表数据库访问层
 *
 * @author wanghaojia
 * @since 2022-10-31 15:55:54
 */
@Component
public class ActivityDetailPlanBudgetModifyRepository extends ServiceImpl<ActivityDetailPlanBudgetModifyMapper, ActivityDetailPlanBudgetModify> {

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    /**
     * 根据方案编码，查询方案对应预算
     **/
    public List<ActivityDetailPlanBudgetModifyDto> listDtoByModifyCodeList(List<String> modifyCodeList) {
        List<ActivityDetailPlanBudgetModify> activityPlanBudgets = listByModifyCodeList(modifyCodeList);
        if (CollectionUtils.isNotEmpty(activityPlanBudgets)){
            List<ActivityDetailPlanBudgetModifyDto> dtoList = (List<ActivityDetailPlanBudgetModifyDto>) nebulaToolkitService.copyCollectionByBlankList(activityPlanBudgets,ActivityDetailPlanBudgetModify.class,ActivityDetailPlanBudgetModifyDto.class, HashSet.class, ArrayList.class);
            return dtoList;
        }
        return Lists.newArrayList();
    }

    /**
     * 根据方案编码，查询方案对应预算
     * @param modifyCodeList 方案编码集合
     **/
    public List<ActivityDetailPlanBudgetModify> listByModifyCodeList(List<String> modifyCodeList) {
        if (org.springframework.util.CollectionUtils.isEmpty(modifyCodeList)) {
            return Lists.newArrayList();
        }
        return this.lambdaQuery()
                .in(ActivityDetailPlanBudgetModify::getModifyBusinessCode, modifyCodeList)
                .eq(UuidFlagOpEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(TenantFlagOpEntity::getTenantCode, TenantUtils.getTenantCode())
                .list();
    }

    /**
     * 根据明细编码，批量查询方案明细对应预算
     *
     * @param itemCodeList
     * @return java.util.List<com.biz.crm.tpm.business.activity.plan.local.entity.ActivityDetailPlanBudgetModify>
     * @author huojia
     * @date 2022/11/28 16:56
     **/
    public List<ActivityDetailPlanBudgetModify> listByDetailCodeList(List<String> itemCodeList) {
        if (CollectionUtils.isEmpty(itemCodeList)) {
            return null;
        }
        return this.lambdaQuery()
                .in(ActivityDetailPlanBudgetModify::getDetailPlanItemCode, itemCodeList)
                .eq(UuidFlagOpEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(TenantFlagOpEntity::getTenantCode, TenantUtils.getTenantCode())
                .list();
    }

    public void deleteByIds(List<String> ids) {
        if (org.springframework.util.CollectionUtils.isEmpty(ids)){
            return;
        }
        LambdaUpdateWrapper<ActivityDetailPlanBudgetModify> updateWrapper = new UpdateWrapper<ActivityDetailPlanBudgetModify>().lambda();
        updateWrapper.set(ActivityDetailPlanBudgetModify::getDelFlag, DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.in(ActivityDetailPlanBudgetModify::getId, ids);
        this.update(updateWrapper);
    }

    public void deletePhysicalByModifyBusinessCode(String modifyBusinessCode) {
        if (StringUtils.isEmpty(modifyBusinessCode)){
            return;
        }
        LambdaQueryWrapper<ActivityDetailPlanBudgetModify> updateWrapper = new LambdaQueryWrapper<ActivityDetailPlanBudgetModify>();
//        updateWrapper.set(ActivityDetailPlanBudgetModify::getDelFlag, DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.eq(ActivityDetailPlanBudgetModify::getModifyBusinessCode, modifyBusinessCode);
        this.remove(updateWrapper);
    }

    public void deleteByModifyBusinessCodes(List<String> modifyBusinessCodes) {
        if (org.springframework.util.CollectionUtils.isEmpty(modifyBusinessCodes)){
            return;
        }
        LambdaUpdateWrapper<ActivityDetailPlanBudgetModify> updateWrapper = new UpdateWrapper<ActivityDetailPlanBudgetModify>().lambda();
        updateWrapper.set(ActivityDetailPlanBudgetModify::getDelFlag, DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.in(ActivityDetailPlanBudgetModify::getModifyBusinessCode, modifyBusinessCodes);
        this.update(updateWrapper);
    }

    /**
     * 设置VO里面的几个str属性，前端用此字段，避免出现格式问题
     */
    public void fillVoListProperties(List<ActivityDetailPlanBudgetVo> voList) {
        if (org.springframework.util.CollectionUtils.isEmpty(voList)){
            return;
        }
        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(ActivityDetailPlanBudgetVo.class);
        Map<String, PropertyDescriptor> propertyMap = Arrays.stream(propertyDescriptors).collect(Collectors.toMap(PropertyDescriptor::getName, Function.identity()));
        for (ActivityDetailPlanBudgetVo item : voList) {
            this.fillVoProperties(item,propertyMap);
        }
    }

    /**
     * 设置VO里面的几个str属性，前端用此字段，避免出现格式问题
     */
    public void fillVoProperties(ActivityDetailPlanBudgetVo item) {
        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(ActivityDetailPlanBudgetVo.class);
        Map<String, PropertyDescriptor> propertyMap = Arrays.stream(propertyDescriptors).collect(Collectors.toMap(PropertyDescriptor::getName, Function.identity()));
        this.fillVoProperties(item,propertyMap);
    }

    /**
     * 设置VO里面的几个str属性，前端用此字段，避免出现格式问题
     */
    public void fillVoProperties(ActivityDetailPlanBudgetVo item,Map<String, PropertyDescriptor> propertyMap) {
        if (null == item){
            return;
        }
        //统一做BigDecimal,integer,Date类型格式转换
        ObjectConvertStringUtil.fillObjectStrProperties(item, ActivityDetailPlanBudgetVo.class,propertyMap);
    }


}

