package com.biz.crm.tpm.business.activity.detail.plan.local.modify.repository;


import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mn.common.base.util.ObjectConvertStringUtil;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.entity.ActivityDetailPlanItemModify;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.mapper.ActivityDetailPlanItemModifyMapper;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.vo.ActivityDetailPlanItemModifyVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemModifyDto;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.dto.ActivityPlanItemModifyDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;


/**
 * 活动细案(ActivityDetailPlan)表数据库访问层
 *
 * @author wanghaojia
 * @since 2022-11-04 16:52:04
 */
@Component
public class ActivityDetailPlanItemModifyRepository extends ServiceImpl<ActivityDetailPlanItemModifyMapper, ActivityDetailPlanItemModify> {


    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    /**
     * 查询dto集合
     * @param modifyCode 变更编码
     * @return
     */
    public List<ActivityDetailPlanItemModifyDto> findDtoListByModifyCode(String modifyCode) {
        if (StringUtils.isBlank(modifyCode)){
            return Lists.newArrayList();
        }
        ActivityPlanItemModifyDto dto = new ActivityPlanItemModifyDto();
        dto.setModifyBusinessCode(modifyCode);
        List<ActivityDetailPlanItemModify> itemList = findList(dto);
        List<ActivityDetailPlanItemModifyDto> dtoList = (List<ActivityDetailPlanItemModifyDto>) nebulaToolkitService.copyCollectionByWhiteList(itemList, ActivityDetailPlanItemModify.class, ActivityDetailPlanItemModifyDto.class, HashSet.class, ArrayList.class);
        fillDtoListProperties(dtoList);
        return dtoList;
    }

    /**
     * 查询dto集合
     * @param planItem 查询参数
     * @return
     */
    public List<ActivityDetailPlanItemModifyDto> findDtoList(ActivityPlanItemModifyDto planItem) {
        List<ActivityDetailPlanItemModify> itemList = findList(planItem);
        List<ActivityDetailPlanItemModifyDto> dtoList = (List<ActivityDetailPlanItemModifyDto>) nebulaToolkitService.copyCollectionByWhiteList(itemList, ActivityDetailPlanItemModify.class, ActivityDetailPlanItemModifyDto.class, HashSet.class, ArrayList.class);
        fillDtoListProperties(dtoList);
        return dtoList;
    }

    /**
     * 根据查询条件筛选集合
     * @param modifyBusinessCode 变更编码
     */
    public List<ActivityDetailPlanItemModify> findListByModifyBusinessCode(String modifyBusinessCode) {
        if (StringUtils.isBlank(modifyBusinessCode)){
            return Lists.newArrayList();
        }
        ActivityPlanItemModifyDto dto = new ActivityPlanItemModifyDto();
        dto.setModifyBusinessCode(modifyBusinessCode);
        return findList(dto);
    }

    /**
     * 根据查询条件筛选集合
     * @param planItem 查询参数
     */
    public List<ActivityDetailPlanItemModify> findList(ActivityPlanItemModifyDto planItem) {
        return this.list(Wrappers.lambdaQuery(ActivityDetailPlanItemModify.class)
//                .eq(StringUtils.isNotBlank(planItem.getPlanCode()),ActivityPlanItemModify::getPlanCode, planItem.getPlanCode())
                        .eq(StringUtils.isNotBlank(planItem.getModifyBusinessCode()),ActivityDetailPlanItemModify::getModifyBusinessCode, planItem.getModifyBusinessCode())
//                .eq(StringUtils.isNotBlank(planItem.getTemplateConfigCode()),ActivityPlanItemModify::getTemplateConfigCode, planItem.getTemplateConfigCode())
                        .eq(ActivityDetailPlanItemModify::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
        );
    }



    /**
     * 设置VO里面的几个str属性，前端用此字段，避免出现格式问题
     */
    public void fillVoListProperties(List<ActivityDetailPlanItemModifyVo> voList) {
        if (CollectionUtils.isEmpty(voList)){
            return;
        }
        for (ActivityDetailPlanItemModifyVo item : voList) {
            this.fillVoProperties(item);
        }
    }

    /**
     * 设置VO里面的几个str属性，前端用此字段，避免出现格式问题
     */
    public void fillVoProperties(ActivityDetailPlanItemModifyVo item) {
        if (null == item){
            return;
        }
        ObjectConvertStringUtil.fillObjectStrProperties(item,ActivityDetailPlanItemModifyVo.class);
        BigDecimal feeAmount = Optional.ofNullable(item.getTotalFeeAmount()).orElse(BigDecimal.ZERO);
//        BigDecimal usedAmount = Optional.ofNullable(item.getUsedAmount()).orElse(BigDecimal.ZERO);
//        item.setUsedAmount(usedAmount);
//        item.setUsableAmount(feeAmount.subtract(usedAmount));
    }

    /**
     * 设置VO里面的几个str属性，前端用此字段，避免出现格式问题
     */
    public void fillDtoListProperties(List<ActivityDetailPlanItemModifyDto> dtoList) {
        if (CollectionUtils.isEmpty(dtoList)){
            return;
        }
        for (ActivityDetailPlanItemModifyDto item : dtoList) {
            this.fillDtoProperties(item);
        }
    }

    /**
     * 设置VO里面的几个str属性，前端用此字段，避免出现格式问题
     */
    public void fillDtoProperties(ActivityDetailPlanItemModifyDto item) {
        if (null == item){
            return;
        }
        ObjectConvertStringUtil.fillObjectStrProperties(item,ActivityDetailPlanItemModifyDto.class);
        item.setActivityType(item.getActivityTypeCode());
        item.setActivityForm(item.getActivityFormCode());
    }

    public void deleteByIds(ArrayList<String> ids) {
        if (CollectionUtils.isEmpty(ids)){
            return;
        }
        LambdaUpdateWrapper<ActivityDetailPlanItemModify> updateWrapper = new UpdateWrapper<ActivityDetailPlanItemModify>().lambda();
        updateWrapper.set(ActivityDetailPlanItemModify::getDelFlag, DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.in(ActivityDetailPlanItemModify::getId, ids);
        this.update(updateWrapper);
    }

    public void deleteByDetailModifyBusinessCodes(List<String> modifyBusinessCodeList) {
        if (CollectionUtils.isEmpty(modifyBusinessCodeList)){
            return;
        }
        LambdaUpdateWrapper<ActivityDetailPlanItemModify> updateWrapper = new UpdateWrapper<ActivityDetailPlanItemModify>().lambda();
        updateWrapper.set(ActivityDetailPlanItemModify::getDelFlag, DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.in(ActivityDetailPlanItemModify::getModifyBusinessCode, modifyBusinessCodeList);
        this.update(updateWrapper);
    }

    public List<ActivityDetailPlanItemModifyDto> findListByModifyBusinessCodes(List<String> modifyBusinessCodes) {
        if(org.apache.commons.collections4.CollectionUtils.isEmpty(modifyBusinessCodes)) {
            return Lists.newArrayListWithCapacity(0);
        }
        List<ActivityDetailPlanItemModify> itemList = this.lambdaQuery()
                .eq(ActivityDetailPlanItemModify::getTenantCode, TenantUtils.getTenantCode())
                .eq(ActivityDetailPlanItemModify::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .in(ActivityDetailPlanItemModify::getModifyBusinessCode, modifyBusinessCodes)
                .list();
        List<ActivityDetailPlanItemModifyDto> dtoList = (List<ActivityDetailPlanItemModifyDto>) nebulaToolkitService.copyCollectionByWhiteList(itemList, ActivityDetailPlanItemModify.class, ActivityDetailPlanItemModifyDto.class, HashSet.class, ArrayList.class);
        fillDtoListProperties(dtoList);
        return dtoList;
    }


    public Page<ActivityDetailPlanItemModifyVo> findByConditions(Pageable pageable, ActivityDetailPlanItemModifyDto dto) {
        Page<ActivityDetailPlanItemModifyVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page<ActivityDetailPlanItemModifyVo> pageList = this.baseMapper.findByConditions(page, dto);
        this.fillVoListProperties(pageList.getRecords());
        return pageList;
    }


    public Page<ActivityDetailPlanItemModifyVo> findItemBeforeModifyList(Pageable pageable, ActivityDetailPlanItemModifyDto dto) {
        Page<ActivityDetailPlanItemModifyVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page<ActivityDetailPlanItemModifyVo> pageList = this.baseMapper.findItemBeforeModifyList(page, dto);
        this.fillVoListProperties(pageList.getRecords());
        return pageList;
    }

}

